/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.valueAdjuster;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.liveEdit.CssPsiUtil;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizerFactory;
import com.jetbrains.liveEdit.valueAdjuster.AbstractAdjuster;
import com.jetbrains.liveEdit.valueAdjuster.Mapper;
import com.jetbrains.liveEdit.valueAdjuster.ValueAdjusterFactory;
import org.jetbrains.annotations.Nullable;

class CssNumberAdjusterFactory
extends ValueAdjusterFactory {
    CssNumberAdjusterFactory() {
    }

    @Nullable
    private static PsiElement getNumberElement(PsiElement elementAtCaret) {
        if (elementAtCaret.getNode().getElementType() == CssElementTypes.CSS_NUMBER) {
            return elementAtCaret;
        }
        ASTNode parent = TreeUtil.findParent((ASTNode)elementAtCaret.getNode(), (IElementType)CssElementTypes.CSS_NUMBER);
        return parent != null ? parent.getPsi() : null;
    }

    @Override
    @Nullable
    public ValueAdjusterFactory.ValueAdjuster createAdjuster(PsiElement elementAtCaret) {
        PsiElement element = CssNumberAdjusterFactory.getNumberElement(elementAtCaret);
        if (element == null) {
            return null;
        }
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        if (declaration == null) {
            return null;
        }
        CssTermList declarationValue = declaration.getValue();
        if (declarationValue == null) {
            return null;
        }
        final Couple<CharSequence> textAround = CssPsiUtil.collectBeforeAndAfterText(element, declarationValue);
        PsiFile file = elementAtCaret.getContainingFile();
        return (ValueAdjusterFactory.ValueAdjuster)RangeValueSynchronizerFactory.applyAndGet(element, file, synchronizer -> new AbstractAdjuster<Integer>(element){

            @Override
            protected Integer valueFromString(String s) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    return 1;
                }
            }

            @Override
            protected String valueToString(Integer value) {
                return String.valueOf(value);
            }

            @Override
            protected void sync(Integer value) {
                String v = String.valueOf(textAround.first) + value + textAround.second;
                synchronizer.sync(v);
            }

            @Override
            protected Mapper<Integer> createMapper(Integer currentValue) {
                return new Mapper.LinearNumberMapper(0, 100);
            }
        });
    }
}

