/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.database.remote.jdbc.impl.RemotePreparedStatementImpl;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JdbcInjection
extends Serializable {
    public void inject(int var1, @NotNull RemotePreparedStatementImpl var2) throws Exception;

    public static class OraTimestampInjection
    implements JdbcInjection {
        private final String myValue;

        public OraTimestampInjection(@NotNull String value) {
            if (value == null) {
                OraTimestampInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement) throws Exception {
            Class<?> aClass;
            if (statement == null) {
                OraTimestampInjection.$$$reportNull$$$0(1);
            }
            Constructor<?> constructor = (aClass = Class.forName("oracle.sql.TIMESTAMPTZ")) == null ? null : aClass.getConstructor(Connection.class, String.class);
            String o = constructor == null ? this.myValue : constructor.newInstance(statement.get(), this.myValue.replaceAll("\\+", ""));
            statement.setObject(idx, o);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$OraTimestampInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MssqlDateTimeOffsetInjection
    implements JdbcInjection {
        private final String myValue;

        public MssqlDateTimeOffsetInjection(@NotNull String value) {
            if (value == null) {
                MssqlDateTimeOffsetInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement) throws Exception {
            if (statement == null) {
                MssqlDateTimeOffsetInjection.$$$reportNull$$$0(1);
            }
            statement.setObject(idx, this.myValue, -155);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$MssqlDateTimeOffsetInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PgTimestampInjection
    implements JdbcInjection {
        private final String myValue;

        public PgTimestampInjection(@NotNull String value) {
            if (value == null) {
                PgTimestampInjection.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement) throws Exception {
            if (statement == null) {
                PgTimestampInjection.$$$reportNull$$$0(1);
            }
            statement.setObject(idx, this.myValue, 93);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$PgTimestampInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DateInjection
    implements JdbcInjection {
        private final Calendar myCalendar;
        private final Date myDate;

        public DateInjection(@Nullable Calendar calendar, @NotNull Date date) {
            if (date == null) {
                DateInjection.$$$reportNull$$$0(0);
            }
            this.myCalendar = calendar;
            this.myDate = date;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement) throws Exception {
            if (statement == null) {
                DateInjection.$$$reportNull$$$0(1);
            }
            if (this.myCalendar != null) {
                statement.setDate(idx, this.myDate, this.myCalendar);
                return;
            }
            statement.setDate(idx, this.myDate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "date";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$DateInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TimeInjection
    implements JdbcInjection {
        private final Calendar myCalendar;
        private final Time myDate;

        public TimeInjection(@Nullable Calendar calendar, @NotNull Time date) {
            if (date == null) {
                TimeInjection.$$$reportNull$$$0(0);
            }
            this.myCalendar = calendar;
            this.myDate = date;
        }

        @Override
        public void inject(int idx, @NotNull RemotePreparedStatementImpl statement) throws Exception {
            if (statement == null) {
                TimeInjection.$$$reportNull$$$0(1);
            }
            if (this.myCalendar != null) {
                statement.setTime(idx, this.myDate, this.myCalendar);
                return;
            }
            statement.setTime(idx, this.myDate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "date";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/remote/jdbc/JdbcInjection$TimeInjection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

