/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;

@Deprecated
public class CodeInsightServicesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.CodeInsightServicesUtil");
    private static final IElementType[] ourTokenMap = new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GE, JavaTokenType.LE, JavaTokenType.GT, JavaTokenType.OROR, JavaTokenType.ANDAND};

    public static PsiExpression invertCondition(PsiExpression booleanExpression) throws IncorrectOperationException {
        PsiExpression operand;
        Object value;
        PsiPolyadicExpression expression;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)booleanExpression.getProject()).getElementFactory();
        if (booleanExpression instanceof PsiPolyadicExpression) {
            expression = (PsiPolyadicExpression)booleanExpression;
            IElementType operationSign = expression.getOperationTokenType();
            for (int i = 0; i < ourTokenMap.length; ++i) {
                IElementType tokenType = ourTokenMap[i];
                if (operationSign != tokenType) continue;
                expression = (PsiPolyadicExpression)expression.copy();
                PsiExpression[] operands = expression.getOperands();
                for (int o = 0; o < operands.length; ++o) {
                    PsiExpression op = operands[o];
                    if (o != 0) {
                        expression.getTokenBeforeOperand(op).replace(CodeInsightServicesUtil.createOperationToken(factory, ourTokenMap[i + (i % 2 == 0 ? 1 : -1)]));
                    }
                    if (tokenType != JavaTokenType.OROR && tokenType != JavaTokenType.ANDAND) continue;
                    PsiExpression inverted = CodeInsightServicesUtil.invertCondition(op);
                    op.replace((PsiElement)inverted);
                }
                if (tokenType == JavaTokenType.ANDAND && booleanExpression.getParent() instanceof PsiPolyadicExpression) {
                    PsiParenthesizedExpression parth = (PsiParenthesizedExpression)factory.createExpressionFromText("(a)", (PsiElement)expression);
                    parth.getExpression().replace((PsiElement)expression);
                    return parth;
                }
                return expression;
            }
        } else if (booleanExpression instanceof PsiPrefixExpression) {
            expression = (PsiPrefixExpression)booleanExpression;
            if (expression.getOperationTokenType() == JavaTokenType.EXCL) {
                PsiElement parent;
                PsiExpression operand2 = expression.getOperand();
                if (operand2 instanceof PsiParenthesizedExpression && (parent = booleanExpression.getParent()) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType() == JavaTokenType.ANDAND) {
                    operand2 = ((PsiParenthesizedExpression)operand2).getExpression();
                }
                return operand2;
            }
        } else if (booleanExpression instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)booleanExpression).getValue()) instanceof Boolean) {
            return factory.createExpressionFromText(String.valueOf((Boolean)value == false), (PsiElement)booleanExpression);
        }
        if (booleanExpression instanceof PsiParenthesizedExpression && (operand = ((PsiParenthesizedExpression)booleanExpression).getExpression()) != null) {
            operand.replace((PsiElement)CodeInsightServicesUtil.invertCondition(operand));
            return booleanExpression;
        }
        PsiPrefixExpression result2 = (PsiPrefixExpression)factory.createExpressionFromText("!(a)", null);
        if (!(booleanExpression instanceof PsiPolyadicExpression)) {
            result2.getOperand().replace((PsiElement)booleanExpression);
        } else {
            PsiParenthesizedExpression e = (PsiParenthesizedExpression)result2.getOperand();
            e.getExpression().replace((PsiElement)booleanExpression);
        }
        return result2;
    }

    private static PsiElement createOperationToken(PsiElementFactory factory, IElementType tokenType) throws IncorrectOperationException {
        String s;
        if (tokenType == JavaTokenType.EQEQ) {
            s = "==";
        } else if (tokenType == JavaTokenType.NE) {
            s = "!=";
        } else if (tokenType == JavaTokenType.LT) {
            s = "<";
        } else if (tokenType == JavaTokenType.LE) {
            s = "<=";
        } else if (tokenType == JavaTokenType.GT) {
            s = ">";
        } else if (tokenType == JavaTokenType.GE) {
            s = ">=";
        } else if (tokenType == JavaTokenType.ANDAND) {
            s = "&&";
        } else if (tokenType == JavaTokenType.OROR) {
            s = "||";
        } else {
            LOG.error("Unknown token type");
            s = "==";
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)factory.createExpressionFromText("a" + s + "b", null);
        return expression.getOperationSign();
    }
}

