/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ExceptionInfoCache {
    private final ConcurrentMap<String, Pair<PsiClass[], PsiFile[]>> myCache = ContainerUtil.createConcurrentSoftValueMap();
    private final Project myProject;
    private final GlobalSearchScope mySearchScope;

    public ExceptionInfoCache(GlobalSearchScope searchScope) {
        this.myProject = (Project)ObjectUtils.assertNotNull((Object)searchScope.getProject());
        this.mySearchScope = searchScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExceptionInfoCache.$$$reportNull$$$0(0);
        }
        return project;
    }

    @NotNull
    private PsiClass[] findClassesPreferringMyScope(String className) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiClass[] result2 = psiFacade.findClasses(className, this.mySearchScope);
        PsiClass[] psiClassArray = result2.length != 0 ? result2 : psiFacade.findClasses(className, GlobalSearchScope.allScope(this.myProject));
        if (psiClassArray == null) {
            ExceptionInfoCache.$$$reportNull$$$0(1);
        }
        return psiClassArray;
    }

    Pair<PsiClass[], PsiFile[]> resolveClass(String className) {
        int dollarIndex;
        Pair cached = (Pair)this.myCache.get(className);
        if (cached != null) {
            return cached;
        }
        if (DumbService.isDumb(this.myProject)) {
            return Pair.create((Object)PsiClass.EMPTY_ARRAY, (Object)PsiFile.EMPTY_ARRAY);
        }
        PsiClass[] classes = this.findClassesPreferringMyScope(className);
        if (classes.length == 0 && (dollarIndex = className.indexOf(36)) >= 0) {
            classes = this.findClassesPreferringMyScope(className.substring(0, dollarIndex));
        }
        PsiFile[] files = new PsiFile[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            files[i] = (PsiFile)classes[i].getContainingFile().getNavigationElement();
        }
        Pair result2 = Pair.create((Object)classes, (Object)files);
        this.myCache.put(className, (Pair<PsiClass[], PsiFile[]>)result2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/filters/ExceptionInfoCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesPreferringMyScope";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

