/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.UrlOpener;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000b\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\"\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014JK\u0010\u0010\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J<\u0010\u0017\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0014J6\u0010\u001e\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0007J[\u0010\u001f\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010 J[\u0010\u001f\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010#J\u0014\u0010$\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00112\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002JH\u0010(\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001dH\u0014J\u0010\u0010+\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless;", "Lcom/intellij/ide/browsers/BrowserLauncher;", "()V", "browse", "", "file", "Ljava/io/File;", "url", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "project", "Lcom/intellij/openapi/project/Project;", "browseUsingNotSystemDefaultBrowserPolicy", "settings", "Lcom/intellij/ide/GeneralSettings;", "browseUsingPath", "", "browserPath", "openInNewWindow", "additionalParameters", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/openapi/project/Project;Z[Ljava/lang/String;)Z", "checkCreatedProcess", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "process", "Ljava/lang/Process;", "launchTask", "Lkotlin/Function0;", "checkPath", "doLaunch", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/openapi/project/Project;Z[Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Z", "command", "", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Z", "getEffectiveBrowser", "open", "openOrBrowse", "_url", "showError", "error", "title", "signUrl", "Companion", "intellij.platform.ide"})
public class BrowserLauncherAppless
extends BrowserLauncher {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void open(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        BrowserLauncherAppless.openOrBrowse$default(this, url, false, null, 4, null);
    }

    @Override
    public void browse(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String path2 = file.getAbsolutePath();
        if (SystemInfo.isWindows && path2.charAt(0) != '/') {
            path2 = '/' + path2;
        }
        BrowserLauncherAppless.openOrBrowse$default(this, "file://" + path2, true, null, 4, null);
    }

    protected void browseUsingNotSystemDefaultBrowserPolicy(@NotNull String url, @NotNull GeneralSettings settings, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        BrowserLauncher.browseUsingPath$default(this, url, settings.getBrowserPath(), null, project, null, 20, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void openOrBrowse(String _url, boolean browse, Project project) {
        String string;
        String url;
        void $receiver$iv;
        String string2 = _url;
        BrowserLauncherAppless browserLauncherAppless = this;
        CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (StringsKt.startsWith$default((String)(url = browserLauncherAppless.signUrl(string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())), (String)"mailto:", (boolean)false, (int)2, null) && Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            try {
                Desktop.getDesktop().mail(new URI(url));
            }
            catch (Exception e) {
                LOG.warn("failed to open: " + url, (Throwable)e);
            }
            return;
        }
        if (!BrowserUtil.isAbsoluteURL(url)) {
            File file = new File(url);
            if (!browse && BrowserLauncherAppless.Companion.isDesktopActionSupported(Desktop.Action.OPEN)) {
                if (!file.exists()) {
                    this.showError(IdeBundle.message("error.file.does.not.exist", file.getPath()), null, null, null, null);
                    return;
                }
                try {
                    Desktop.getDesktop().open(file);
                    return;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            this.browse(file);
            return;
        }
        LOG.debug("Launch browser: [" + url + ']');
        GeneralSettings settings = BrowserLauncherAppless.Companion.getGeneralSettings();
        if (settings.isUseDefaultBrowser()) {
            URI uri = VfsUtil.toUri(url);
            if (uri == null) {
                BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.malformed.url", url), null, project, null, null, 26, null);
                return;
            }
            boolean tryToUseCli = true;
            if (BrowserLauncherAppless.Companion.isDesktopActionSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(uri);
                    LOG.debug("Browser launched using JDK 1.6 API");
                    return;
                }
                catch (Exception e) {
                    LOG.warn("Error while using Desktop API, fallback to CLI", (Throwable)e);
                    String string3 = e.getMessage();
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    boolean bl = tryToUseCli = !StringsKt.contains$default((CharSequence)string3, (CharSequence)"Error code: -10814", (boolean)false, (int)2, null);
                }
            }
            if (tryToUseCli) {
                List list = BrowserLauncherAppless.Companion.getDefaultBrowserCommand();
                if (list != null) {
                    List list2;
                    List it = list2 = list;
                    BrowserLauncherAppless.doLaunch$default(this, url, it, null, project, null, null, 48, null);
                    return;
                }
            }
        }
        this.browseUsingNotSystemDefaultBrowserPolicy(url, settings, project);
    }

    static /* bridge */ /* synthetic */ void openOrBrowse$default(BrowserLauncherAppless browserLauncherAppless, String string, boolean bl, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openOrBrowse");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        browserLauncherAppless.openOrBrowse(string, bl, project);
    }

    @NotNull
    protected String signUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return url;
    }

    @Override
    public final void browse(@NotNull String url, @Nullable WebBrowser browser, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        WebBrowser effectiveBrowser = this.getEffectiveBrowser(browser);
        if (effectiveBrowser == null || browser == null && !StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) {
            this.openOrBrowse(url, true, project);
        } else {
            Object element$iv;
            UrlOpener it;
            ExtensionPointName<UrlOpener> extensionPointName = UrlOpener.EP_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"UrlOpener.EP_NAME");
            Object[] objectArray = extensionPointName.getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"UrlOpener.EP_NAME.extensions");
            Object[] $receiver$iv = objectArray;
            int n = $receiver$iv.length;
            for (int i = 0; i < n && !(it = (UrlOpener)(element$iv = $receiver$iv[i])).openUrl(effectiveBrowser, this.signUrl(url), project); ++i) {
            }
        }
    }

    @Override
    public boolean browseUsingPath(@Nullable String url, @Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, boolean openInNewWindow, @NotNull String[] additionalParameters) {
        Intrinsics.checkParameterIsNotNull((Object)additionalParameters, (String)"additionalParameters");
        String browserPathEffective = browserPath;
        Function0 launchTask = null;
        if (browserPath == null && browser != null) {
            browserPathEffective = PathUtil.toSystemDependentName(browser.getPath());
            launchTask = (Function0)new Function0<Unit>(this, url, browser, project, openInNewWindow, additionalParameters){
                final /* synthetic */ BrowserLauncherAppless this$0;
                final /* synthetic */ String $url;
                final /* synthetic */ WebBrowser $browser;
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $openInNewWindow;
                final /* synthetic */ String[] $additionalParameters;

                public final void invoke() {
                    this.this$0.browseUsingPath(this.$url, null, this.$browser, this.$project, this.$openInNewWindow, this.$additionalParameters);
                }
                {
                    this.this$0 = browserLauncherAppless;
                    this.$url = string;
                    this.$browser = webBrowser;
                    this.$project = project;
                    this.$openInNewWindow = bl;
                    this.$additionalParameters = stringArray;
                    super(0);
                }
            };
        }
        return this.doLaunch(url, browserPathEffective, browser, project, openInNewWindow, additionalParameters, (Function0<Unit>)launchTask);
    }

    private final boolean doLaunch(String url, String browserPath, WebBrowser browser, Project project, boolean openInNewWindow, String[] additionalParameters, Function0<Unit> launchTask) {
        if (!this.checkPath(browserPath, browser, project, launchTask)) {
            return false;
        }
        String string = browserPath;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        List<String> list = BrowserUtil.getOpenBrowserCommand(string, openInNewWindow);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"BrowserUtil.getOpenBrows\u2026rPath!!, openInNewWindow)");
        return this.doLaunch(url, list, browser, project, additionalParameters, launchTask);
    }

    @Contract(value="null, _, _, _ -> false")
    public final boolean checkPath(@Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, @Nullable Function0<Unit> launchTask) {
        CharSequence charSequence = browserPath;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return true;
        }
        Object object = browser;
        if (object == null || (object = ((WebBrowser)object).getBrowserNotFoundMessage()) == null) {
            object = IdeBundle.message("error.please.specify.path.to.web.browser", CommonBundle.settingsActionPath());
        }
        Object message = object;
        this.showError((String)message, browser, project, IdeBundle.message("title.browser.not.found", new Object[0]), launchTask);
        return false;
    }

    private final boolean doLaunch(String url, List<String> command, WebBrowser browser, Project project, String[] additionalParameters, Function0<Unit> launchTask) {
        boolean bl;
        BrowserSpecificSettings browserSpecificSettings;
        if (url != null && StringsKt.startsWith$default((String)url, (String)"jar:", (boolean)false, (int)2, null)) {
            return false;
        }
        List commandWithUrl = CollectionsKt.toMutableList((Collection)command);
        if (url != null) {
            if (browser != null) {
                browser.addOpenUrlParameter(commandWithUrl, url);
            } else {
                commandWithUrl.add(url);
            }
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(commandWithUrl);
        WebBrowser webBrowser = browser;
        BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = webBrowser != null ? webBrowser.getSpecificSettings() : null;
        if (browserSpecificSettings != null) {
            Map<String, String> map = commandLine.getEnvironment();
            Map<String, String> map2 = browserSpecificSettings.getEnvironmentVariables();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"browserSpecificSettings.environmentVariables");
            map.putAll(map2);
        }
        BrowserLauncherAppless.Companion.addArgs(commandLine, browserSpecificSettings, additionalParameters);
        try {
            Process process = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"commandLine.createProcess()");
            this.checkCreatedProcess(browser, project, commandLine, process, launchTask);
            bl = true;
        }
        catch (ExecutionException e) {
            this.showError(e.getMessage(), browser, project, null, null);
            bl = false;
        }
        return bl;
    }

    static /* bridge */ /* synthetic */ boolean doLaunch$default(BrowserLauncherAppless browserLauncherAppless, String string, List list, WebBrowser webBrowser, Project project, String[] stringArray, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doLaunch");
        }
        if ((n & 0x10) != 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"ArrayUtil.EMPTY_STRING_ARRAY");
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if ((n & 0x20) != 0) {
            function0 = null;
        }
        return browserLauncherAppless.doLaunch(string, list, webBrowser, project, stringArray, (Function0<Unit>)function0);
    }

    protected void checkCreatedProcess(@Nullable WebBrowser browser, @Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull Process process, @Nullable Function0<Unit> launchTask) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
    }

    protected void showError(@Nullable String error, @Nullable WebBrowser browser, @Nullable Project project, @Nullable String title, @Nullable Function0<Unit> launchTask) {
        LOG.warn(error);
    }

    public static /* bridge */ /* synthetic */ void showError$default(BrowserLauncherAppless browserLauncherAppless, String string, WebBrowser webBrowser, Project project, String string2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showError");
        }
        if ((n & 2) != 0) {
            webBrowser = null;
        }
        if ((n & 4) != 0) {
            project = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            function0 = null;
        }
        browserLauncherAppless.showError(string, webBrowser, project, string2, (Function0<Unit>)function0);
    }

    @Nullable
    protected WebBrowser getEffectiveBrowser(@Nullable WebBrowser browser) {
        return browser;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(BrowserLauncherAppless.class);
    }

    @JvmStatic
    public static final boolean canUseSystemDefaultBrowserPolicy() {
        return Companion.canUseSystemDefaultBrowserPolicy();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_ide", "()Lcom/intellij/openapi/diagnostic/Logger;", "defaultBrowserCommand", "", "", "getDefaultBrowserCommand", "()Ljava/util/List;", "generalSettings", "Lcom/intellij/ide/GeneralSettings;", "getGeneralSettings", "()Lcom/intellij/ide/GeneralSettings;", "addArgs", "", "command", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "settings", "Lcom/intellij/ide/browsers/BrowserSpecificSettings;", "additional", "", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/ide/browsers/BrowserSpecificSettings;[Ljava/lang/String;)V", "canUseSystemDefaultBrowserPolicy", "", "isDesktopActionSupported", "action", "Ljava/awt/Desktop$Action;", "isOpenCommandUsed", "intellij.platform.ide"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$intellij_platform_ide() {
            return LOG;
        }

        private final boolean isDesktopActionSupported(Desktop.Action action) {
            return !Patches.SUN_BUG_ID_6486393 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
        }

        @JvmStatic
        public final boolean canUseSystemDefaultBrowserPolicy() {
            return this.isDesktopActionSupported(Desktop.Action.BROWSE) || SystemInfo.isMac || SystemInfo.isWindows || SystemInfo.isUnix && SystemInfo.hasXdgOpen();
        }

        private final GeneralSettings getGeneralSettings() {
            if (ApplicationManager.getApplication() != null) {
                GeneralSettings generalSettings = GeneralSettings.getInstance();
                if (generalSettings != null) {
                    GeneralSettings generalSettings2;
                    GeneralSettings it = generalSettings2 = generalSettings;
                    return it;
                }
            }
            return new GeneralSettings();
        }

        private final List<String> getDefaultBrowserCommand() {
            List list;
            if (SystemInfo.isWindows) {
                Object[] objectArray = new String[4];
                objectArray[0] = ExecUtil.getWindowsShellName();
                objectArray[1] = "/c";
                objectArray[2] = "start";
                String string = GeneralCommandLine.inescapableQuote("");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GeneralCommandLine.inescapableQuote(\"\")");
                objectArray[3] = string;
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = SystemInfo.isMac ? CollectionsKt.listOf((Object)ExecUtil.getOpenCommandPath()) : (SystemInfo.isUnix && SystemInfo.hasXdgOpen() ? CollectionsKt.listOf((Object)"xdg-open") : null);
            }
            return list;
        }

        private final void addArgs(GeneralCommandLine command, BrowserSpecificSettings settings, String[] additional) {
            Object specific;
            Object object = settings;
            if (object == null || (object = ((BrowserSpecificSettings)object).getAdditionalParameters()) == null) {
                object = specific = CollectionsKt.emptyList();
            }
            if (specific.size() + additional.length > 0) {
                if (this.isOpenCommandUsed(command)) {
                    if (BrowserUtil.isOpenCommandSupportArgs()) {
                        command.addParameter("--args");
                    } else {
                        this.getLOG$intellij_platform_ide().warn("'open' command doesn't allow to pass command line arguments so they will be ignored: " + StringUtil.join((Collection)((Collection)specific), (String)", ") + " " + Arrays.toString(additional));
                        return;
                    }
                }
                command.addParameters((List<String>)specific);
                command.addParameters(Arrays.copyOf(additional, additional.length));
            }
        }

        public final boolean isOpenCommandUsed(@NotNull GeneralCommandLine command) {
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            return SystemInfo.isMac && Intrinsics.areEqual((Object)ExecUtil.getOpenCommandPath(), (Object)command.getExePath());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

