/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RootType {
    public static final ExtensionPointName<RootType> ROOT_EP = ExtensionPointName.create((String)"com.intellij.scratch.rootType");
    private final String myId;
    private final String myDisplayName;

    @NotNull
    public static RootType[] getAllRootIds() {
        RootType[] rootTypeArray = (RootType[])Extensions.getExtensions(ROOT_EP);
        if (rootTypeArray == null) {
            RootType.$$$reportNull$$$0(0);
        }
        return rootTypeArray;
    }

    @NotNull
    public static RootType findById(@NotNull String id) {
        if (id == null) {
            RootType.$$$reportNull$$$0(1);
        }
        for (RootType type : RootType.getAllRootIds()) {
            if (!id.equals(type.getId())) continue;
            RootType rootType = type;
            if (rootType == null) {
                RootType.$$$reportNull$$$0(2);
            }
            return rootType;
        }
        throw new AssertionError((Object)id);
    }

    @NotNull
    public static <T extends RootType> T findByClass(Class<T> aClass) {
        RootType rootType = (RootType)Extensions.findExtension(ROOT_EP, aClass);
        if (rootType == null) {
            RootType.$$$reportNull$$$0(3);
        }
        return (T)rootType;
    }

    @Nullable
    public static RootType forFile(@Nullable VirtualFile file) {
        return ScratchFileService.getInstance().getRootType(file);
    }

    protected RootType(@NotNull String id, @Nullable String displayName) {
        if (id == null) {
            RootType.$$$reportNull$$$0(4);
        }
        this.myId = id;
        this.myDisplayName = displayName;
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            RootType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public final String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isHidden() {
        return StringUtil.isEmpty((String)this.myDisplayName);
    }

    public boolean containsFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        ScratchFileService service = ScratchFileService.getInstance();
        return service != null && service.getRootType(file) == this;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            RootType.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RootType.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            RootType.$$$reportNull$$$0(8);
        }
        if (file == null) {
            RootType.$$$reportNull$$$0(9);
        }
        if (file.isDirectory()) {
            return null;
        }
        Language language = this.substituteLanguage(project, file);
        FileType fileType = LanguageUtil.getLanguageFileType(language);
        if (fileType == null) {
            String extension = file.getExtension();
            fileType = extension == null ? null : FileTypeManager.getInstance().getFileTypeByFileName(file.getNameSequence());
        }
        return fileType != null ? fileType.getIcon() : null;
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            RootType.$$$reportNull$$$0(10);
        }
        if (file == null) {
            RootType.$$$reportNull$$$0(11);
        }
        return null;
    }

    public VirtualFile findFile(@Nullable Project project, @NotNull String pathName, ScratchFileService.Option option) throws IOException {
        if (pathName == null) {
            RootType.$$$reportNull$$$0(12);
        }
        return ScratchFileService.getInstance().findFile(this, pathName, option);
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            RootType.$$$reportNull$$$0(13);
        }
        if (source == null) {
            RootType.$$$reportNull$$$0(14);
        }
    }

    public void fileClosed(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            RootType.$$$reportNull$$$0(15);
        }
        if (source == null) {
            RootType.$$$reportNull$$$0(16);
        }
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        if (project == null) {
            RootType.$$$reportNull$$$0(17);
        }
        if (element == null) {
            RootType.$$$reportNull$$$0(18);
        }
        return false;
    }

    public void registerTreeUpdater(@NotNull Project project, @NotNull Disposable disposable, @NotNull Runnable onUpdate) {
        if (project == null) {
            RootType.$$$reportNull$$$0(19);
        }
        if (disposable == null) {
            RootType.$$$reportNull$$$0(20);
        }
        if (onUpdate == null) {
            RootType.$$$reportNull$$$0(21);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/RootType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootIds";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/RootType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findById";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findByClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "substituteIcon";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerTreeUpdater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

