/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.SimpleContent");
    private final byte[] myOriginalBytes;
    private final String myOriginalText;
    private final LineSeparators myLineSeparators;
    private final Document myDocument;
    private final FileType myType;
    private Charset myCharset;
    private byte[] myBOM;

    public SimpleContent(String text) {
        this(text, null);
    }

    public SimpleContent(@NotNull String text, @Nullable FileType type) {
        if (text == null) {
            SimpleContent.$$$reportNull$$$0(0);
        }
        this(text, type, EditorFactory.getInstance());
    }

    public SimpleContent(@NotNull String text, FileType type, EditorFactory f) {
        if (text == null) {
            SimpleContent.$$$reportNull$$$0(1);
        }
        this.myLineSeparators = new LineSeparators();
        this.myOriginalBytes = text.getBytes();
        this.myOriginalText = this.myLineSeparators.correctText(text);
        this.myDocument = f.createDocument(this.myOriginalText);
        this.setReadOnly(true);
        this.myType = type;
    }

    public static SimpleContent createEmpty() {
        SimpleContent content = new SimpleContent("");
        content.setIsEmpty(true);
        return content;
    }

    public void setReadOnly(boolean readOnly) {
        this.myDocument.setReadOnly(readOnly);
    }

    public String getText() {
        return this.myLineSeparators.restoreText(this.myDocument.getText());
    }

    @Override
    public Document getDocument() {
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return null;
    }

    @Override
    public VirtualFile getFile() {
        return null;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        return this.myType;
    }

    @Override
    public byte[] getBytes() {
        String currentText = this.getText();
        if (this.myOriginalText.equals(this.myDocument.getText()) && this.myCharset == null) {
            return this.myOriginalBytes;
        }
        if (this.myCharset != null) {
            ByteBuffer buffer = this.myCharset.encode(currentText).compact();
            int bomLength = this.myBOM != null ? this.myBOM.length : 0;
            int encodedLength = buffer.position();
            byte[] result2 = new byte[encodedLength + bomLength];
            if (bomLength > 0) {
                System.arraycopy(this.myBOM, 0, result2, 0, bomLength);
            }
            buffer.position(0);
            buffer.get(result2, bomLength, encodedLength);
            return result2;
        }
        return currentText.getBytes();
    }

    @Override
    @NotNull
    public LineSeparator getLineSeparator() {
        LineSeparator lineSeparator = LineSeparator.fromString((String)this.myLineSeparators.mySeparator);
        if (lineSeparator == null) {
            SimpleContent.$$$reportNull$$$0(2);
        }
        return lineSeparator;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public static SimpleContent forFileContent(String text, String fileName) {
        FileType fileType = fileName != null ? FileTypeManager.getInstance().getFileTypeByFileName(fileName) : null;
        return new SimpleContent(text, fileType);
    }

    public static SimpleContent fromBytes(byte[] bytes, String charset, FileType fileType) throws UnsupportedEncodingException {
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset().name();
        }
        return new SimpleContent(new String(bytes, charset), fileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiffContent fromIoFile(File file, String charset, FileType fileType) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException(file.toString());
        }
        if (fileType == null) {
            fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName());
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            byte[] bytes = new byte[(int)file.length()];
            int bytesRead = stream.read(bytes, 0, bytes.length);
            LOG.assertTrue(file.length() == (long)bytesRead);
            SimpleContent simpleContent = SimpleContent.fromBytes(bytes, charset, fileType);
            return simpleContent;
        }
    }

    public void setBOM(byte[] BOM) {
        this.myBOM = BOM;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/SimpleContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/SimpleContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LineSeparators {
        private String mySeparator;

        private LineSeparators() {
        }

        @NotNull
        public String correctText(@NotNull String text) {
            if (text == null) {
                LineSeparators.$$$reportNull$$$0(0);
            }
            DiffString.LineTokenizer lineTokenizer = new DiffString.LineTokenizer(DiffString.create((String)text));
            DiffString[] lines = lineTokenizer.execute();
            this.mySeparator = lineTokenizer.getLineSeparator();
            LOG.assertTrue(this.mySeparator == null || !this.mySeparator.isEmpty());
            if (this.mySeparator == null) {
                this.mySeparator = SystemProperties.getLineSeparator();
            }
            String string = DiffString.concatenate((DiffString[])lines).toString();
            if (string == null) {
                LineSeparators.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String restoreText(@NotNull String text) {
            if (text == null) {
                LineSeparators.$$$reportNull$$$0(2);
            }
            if (this.mySeparator == null) {
                throw new NullPointerException();
            }
            String string = text.replaceAll("\n", this.mySeparator);
            if (string == null) {
                LineSeparators.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/SimpleContent$LineSeparators";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/SimpleContent$LineSeparators";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "correctText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "restoreText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "correctText";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "restoreText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

