/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem;

import com.intellij.openapi.externalSystem.ExternalProjectSystemRegistryImpl;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/externalSystem/ExternalProjectSystemRegistryImpl;", "Lcom/intellij/openapi/roots/ExternalProjectSystemRegistry;", "()V", "idToSource", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getExternalSource", "module", "Lcom/intellij/openapi/module/Module;", "getSourceById", "id", "ProjectModelExternalSourceImpl", "intellij.platform.externalSystem"})
public final class ExternalProjectSystemRegistryImpl
implements ExternalProjectSystemRegistry {
    private final ConcurrentHashMap<String, ProjectModelExternalSource> idToSource = new ConcurrentHashMap();

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.Companion.getInstance(module);
        String externalSystemId = modulePropertyManager.getExternalSystemId();
        if (externalSystemId != null) {
            return this.getSourceById(externalSystemId);
        }
        if (modulePropertyManager.isMavenized()) {
            return this.getSourceById("Maven");
        }
        return null;
    }

    @Override
    @NotNull
    public ProjectModelExternalSource getSourceById(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        ProjectModelExternalSource projectModelExternalSource = this.idToSource.computeIfAbsent(id, getSourceById.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectModelExternalSource, (String)"idToSource.computeIfAbse\u2026ExternalSourceImpl(it) })");
        return projectModelExternalSource;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/ExternalProjectSystemRegistryImpl$ProjectModelExternalSourceImpl;", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "myId", "", "(Ljava/lang/String;)V", "displayName", "getDisplayName", "getId", "intellij.platform.externalSystem"})
    private static final class ProjectModelExternalSourceImpl
    implements ProjectModelExternalSource {
        private final String displayName;
        private final String myId;

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public String getId() {
            return this.myId;
        }

        public ProjectModelExternalSourceImpl(@NotNull String myId) {
            Intrinsics.checkParameterIsNotNull((Object)myId, (String)"myId");
            String string = this.myId = myId;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            ProjectModelExternalSourceImpl projectModelExternalSourceImpl = this;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
            String string4 = string3;
            projectModelExternalSourceImpl.displayName = StringUtil.capitalize((String)string4);
        }
    }
}

