/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.layout.AbstractLayoutAction;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;

public class ApplyCurrentLayoutAction
extends AbstractGraphAction<Graph2D> {
    private static final String NAME = ActionsBundle.message("action.Graph.layout.apply.current", new Object[0]);

    public ApplyCurrentLayoutAction() {
        super(NAME, AllIcons.Graph.Layout);
    }

    public ApplyCurrentLayoutAction(Graph2D graph) {
        super(graph, NAME, AllIcons.Graph.Layout);
    }

    @Override
    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        GraphBuilder builder;
        Graph2DView view = AbstractGraphAction.getGraph2DView(graph);
        Project project = ApplyCurrentLayoutAction.getProject(e);
        if (project != null && (builder = this.getBuilder(e)) != null) {
            GraphSettings settings = builder.getGraphPresentationModel().getSettings();
            AbstractLayoutAction.doLayout(view, settings.getCurrentLayouter(), project, settings);
        }
    }

    @Override
    public void update(AnActionEvent e, Graph2D graph) {
        Project project = ApplyCurrentLayoutAction.getProject(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(project != null && graph != null && graph.getNodeArray().length > 0 && ApplyCurrentLayoutAction.canLayout(this.getBuilder(e), project));
    }

    private static boolean canLayout(GraphBuilder graphBuilder, Project project) {
        if (graphBuilder == null) {
            return false;
        }
        try {
            return graphBuilder.getGraphPresentationModel().getSettings().getCurrentLayouter().canLayout(graphBuilder.getGraph());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

