/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.StringKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0007\u001a\u0010\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u001c\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\b\u001a\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a:\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2#\b\u0004\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u001a0\u001cH\u0086\b\u001a\"\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001fH\u0007\u001a\n\u0010 \u001a\u00020!*\u00020\n\u001a\u001a\u0010\"\u001a\u00020\u0006*\u00020\n2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0006\u001a(\u0010%\u001a\u00020!*\u00020\n2\u0006\u0010&\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020\f2\b\b\u0002\u0010$\u001a\u00020\u0006H\u0007\u001a\u001e\u0010%\u001a\u00020!*\u00020\n2\u0006\u0010'\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\fH\u0007\u001a\n\u0010(\u001a\u00020\b*\u00020\n\u001a3\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\n2\u0019\b\u0004\u0010+\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u0002H*0\u001c\u00a2\u0006\u0002\b-H\u0086\b\u00a2\u0006\u0002\u0010.\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\n2\u0006\u0010\u001b\u001a\u00020/\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00060"}, d2={"rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "Lcom/intellij/openapi/module/Module;", "getRootManager", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/ModuleRootManager;", "calcRelativeToProjectPath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "includeFilePath", "", "includeUniqueFilePath", "keepModuleAlwaysOnTheLeft", "guessCurrentProject", "component", "Ljavax/swing/JComponent;", "guessProjectForContentFile", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessProjectForFile", "isProjectDirectoryExistsUsingIo", "parent", "isProjectOrWorkspaceFile", "runWhenProjectOpened", "", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Ljava/util/function/Consumer;", "getExternalConfigurationDir", "Ljava/nio/file/Path;", "getProjectCacheFileName", "forceNameUse", "hashSeparator", "getProjectCachePath", "baseDir", "cacheName", "guessProjectDir", "modifyModules", "T", "task", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Ljava/lang/Runnable;", "intellij.platform.ide"})
@JvmName(name="ProjectUtil")
public final class ProjectUtil {
    @NotNull
    public static final ModuleRootManager getRootManager(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        return moduleRootManager;
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath, boolean keepModuleAlwaysOnTheLeft) {
        String string;
        String url;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file instanceof VirtualFilePathWrapper && ((VirtualFilePathWrapper)((Object)file)).enforcePresentableName()) {
            String string2;
            if (includeFilePath) {
                String string3 = ((VirtualFilePathWrapper)((Object)file)).getPresentablePath();
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.presentablePath");
            } else {
                String string4 = file.getName();
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"file.name");
            }
            return string2;
        }
        String string5 = includeFilePath ? file.getPresentableUrl() : (url = includeUniqueFilePath && project != null ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : file.getName());
        if (project == null) {
            String string6 = url;
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"url");
        } else {
            String string7 = url;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"url");
            string = ProjectUtilCore.displayUrlRelativeToProject(file, string7, project, includeFilePath, keepModuleAlwaysOnTheLeft);
        }
        return string;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ String calcRelativeToProjectPath$default(VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return ProjectUtil.calcRelativeToProjectPath(virtualFile2, project, bl, bl2, bl3);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, includeUniqueFilePath, false, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, false, false, 24, null);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, false, false, false, 28, null);
    }

    @Nullable
    public static final Project guessProjectForFile(@Nullable VirtualFile file) {
        return ProjectLocator.getInstance().guessProjectForFile(file);
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file, @NotNull FileType fileType) {
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file, fileType)) {
                return null;
            }
            v0 = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"ProjectManager.getInstance()");
            v1 = v0.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"ProjectManager.getInstance().openProjects");
            var4_3 = $receiver$iv = v1;
            destination$iv$iv = new ArrayList<E>();
            var6_5 = ((void)$receiver$iv$iv).length;
            for (var7_7 = 0; var7_7 < var6_5; ++var7_7) {
                v2 = it = (element$iv$iv = $receiver$iv$iv[var7_7]);
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                if (v2.isDefault() || !it.isInitialized() || it.isDisposed()) ** GOTO lbl-1000
                v3 = ProjectRootManager.getInstance((Project)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"ProjectRootManager.getInstance(it)");
                if (v3.getFileIndex().isInContent(file)) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            $receiver$iv = list;
            var4_3 = $receiver$iv.iterator();
            while (var4_3.hasNext()) {
                element$iv = var4_3.next();
                it = (Project)element$iv;
                v5 = WindowManager.getInstance().getFrame(it);
                if (!(v5 != null ? v5.isActive() : false)) continue;
                v6 = element$iv;
                break block6;
            }
            v6 = null;
        }
        if ((v7 = (Project)v6) == null) {
            v7 = (Project)CollectionsKt.firstOrNull((List)list);
        }
        return v7;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Project guessProjectForContentFile$default(VirtualFile virtualFile2, FileType fileType, int n, Object object) {
        if ((n & 2) != 0) {
            FileType fileType2 = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence());
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType2, (String)"FileTypeManager.getInsta\u2026leName(file.nameSequence)");
            fileType = fileType2;
        }
        return ProjectUtil.guessProjectForContentFile(virtualFile2, fileType);
    }

    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file) {
        return ProjectUtil.guessProjectForContentFile$default(file, null, 2, null);
    }

    public static final boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file);
    }

    @NotNull
    public static final Project guessCurrentProject(@Nullable JComponent component) {
        Project project;
        Project project2;
        Project project3;
        Project project4 = null;
        if (component != null) {
            project4 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component));
        }
        if ((project3 = project4) == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Object[] objectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ProjectManager.getInstance().openProjects");
            project3 = project2 = (Project)ArraysKt.firstOrNull((Object[])objectArray);
        }
        if (project3 == null) {
            DataManager dataManager = DataManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataManager, (String)"DataManager.getInstance()");
            project2 = project = CommonDataKeys.PROJECT.getData(dataManager.getDataContext());
        }
        if (project2 == null) {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project project5 = projectManager.getDefaultProject();
            project = project5;
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"ProjectManager.getInstance().defaultProject");
        }
        return project;
    }

    public static final <T> T modifyModules(@NotNull Project $receiver, @NotNull Function1<? super ModifiableModuleModel, ? extends T> task) {
        ModifiableModuleModel model;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        ModuleManager moduleManager = ModuleManager.getInstance($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
        ModifiableModuleModel modifiableModuleModel = model = moduleManager.getModifiableModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)modifiableModuleModel, (String)"model");
        Object result2 = task.invoke((Object)modifiableModuleModel);
        ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(model){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return (T)result2;
    }

    public static final boolean isProjectDirectoryExistsUsingIo(@NotNull VirtualFile parent) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        try {
            Path path2 = Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), ".idea");
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(FileUtil.toSys\u2026t.DIRECTORY_STORE_FOLDER)");
            bl = PathKt.exists(path2);
        }
        catch (InvalidPathException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final VirtualFile guessProjectDir(@NotNull Project $receiver) {
        Object module;
        Object object;
        Object[] objectArray;
        Object object2;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if ($receiver.isDefault()) {
                throw (Throwable)new IllegalStateException("Not applicable for default project");
            }
            ModuleManager moduleManager = ModuleManager.getInstance($receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(this)");
            Object[] modules = moduleManager.getModules();
            if (modules.length == 1) {
                Intrinsics.checkExpressionValueIsNotNull((Object)modules, (String)"modules");
                object2 = ArraysKt.first((Object[])modules);
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)modules, (String)"modules");
                Object[] objectArray2 = objectArray = modules;
                int n = objectArray2.length;
                for (int i = 0; i < n; ++i) {
                    Object object3;
                    Object it;
                    Object object4 = it = (object3 = objectArray2[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"it");
                    if (!Intrinsics.areEqual((Object)object4.getName(), (Object)$receiver.getName())) continue;
                    object2 = object3;
                    break block6;
                }
                object2 = null;
            }
        }
        if ((object = (module = object2)) != null && (object = ProjectUtil.getRootManager((Module)object)) != null && (object = object.getContentRoots()) != null && (object = (VirtualFile)ArraysKt.firstOrNull((Object[])object)) != null) {
            Object[] it = objectArray = object;
            return it;
        }
        VirtualFile virtualFile2 = $receiver.getBaseDir();
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile2;
    }

    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $receiver, boolean forceNameUse, @NotNull String hashSeparator) {
        String name;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)hashSeparator, (String)"hashSeparator");
        String presentableUrl = $receiver.getPresentableUrl();
        if (forceNameUse || presentableUrl == null) {
            string = $receiver.getName();
        } else {
            String string2 = PathUtilRt.getFileName((String)presentableUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getFileName(presentableUrl)");
            String string3 = string2;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = StringsKt.removeSuffix((String)string5, (CharSequence)".ipr");
        }
        String string6 = name = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"name");
        name = PathKt.sanitizeFileName$default(string6, null, false, 2, null);
        String string7 = presentableUrl;
        if (string7 == null) {
            string7 = name;
        }
        String locationHash = Integer.toHexString(string7.hashCode());
        String string8 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"name");
        name = StringKt.trimMiddle(string8, Math.min(name.length(), 255 - hashSeparator.length() - locationHash.length()), false);
        return name + hashSeparator + locationHash;
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull String cacheName, boolean forceNameUse) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)cacheName, (String)"cacheName");
        Path path2 = PathManagerEx.getAppSystemDir().resolve(cacheName);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"appSystemDir.resolve(cacheName)");
        return ProjectUtil.getProjectCachePath$default($receiver, path2, forceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Path getProjectCachePath$default(Project project, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ProjectUtil.getProjectCachePath(project, string, bl);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull String cacheName) {
        return ProjectUtil.getProjectCachePath$default($receiver, cacheName, false, 2, null);
    }

    @NotNull
    public static final Path getExternalConfigurationDir(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ProjectUtil.getProjectCachePath$default($receiver, "external_build_system", false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull Path baseDir, boolean forceNameUse, @NotNull String hashSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull((Object)hashSeparator, (String)"hashSeparator");
        Path path2 = baseDir.resolve(ProjectUtil.getProjectCacheFileName($receiver, forceNameUse, hashSeparator));
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"baseDir.resolve(getProje\u2026eNameUse, hashSeparator))");
        return path2;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Path getProjectCachePath$default(Project project, Path path2, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = ".";
        }
        return ProjectUtil.getProjectCachePath(project, path2, bl, string);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull Path baseDir, boolean forceNameUse) {
        return ProjectUtil.getProjectCachePath$default($receiver, baseDir, forceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $receiver, @NotNull Path baseDir) {
        return ProjectUtil.getProjectCachePath$default($receiver, baseDir, false, null, 6, null);
    }

    public static final void runWhenProjectOpened(@NotNull Project $receiver, @NotNull Runnable handler) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        MessageBusConnection connection$iv = ((ComponentManager)$receiver).getMessageBus().connect();
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener($receiver, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Runnable $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = runnable;
            }

            public void projectOpened(@NotNull Project eventProject) {
                Intrinsics.checkParameterIsNotNull((Object)eventProject, (String)"eventProject");
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    this.$handler$inlined.run();
                }
            }
        });
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Consumer<Project> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        Project project2 = project;
        ComponentManager componentManager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentManager, (String)"(project ?: ApplicationManager.getApplication())");
        MessageBusConnection connection$iv = componentManager.getMessageBus().connect();
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Consumer $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = consumer;
            }

            public void projectOpened(@NotNull Project eventProject) {
                Intrinsics.checkParameterIsNotNull((Object)eventProject, (String)"eventProject");
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    this.$handler$inlined.accept(it);
                }
            }
        });
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void runWhenProjectOpened$default(Project project, Consumer consumer, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        ProjectUtil.runWhenProjectOpened(project, consumer);
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@NotNull Consumer<Project> handler) {
        ProjectUtil.runWhenProjectOpened$default(null, handler, 1, null);
    }

    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Function1<? super Project, Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        Project project2 = project;
        ComponentManager componentManager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentManager, (String)"(project ?: ApplicationManager.getApplication())");
        MessageBusConnection connection = componentManager.getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ Function1 $handler;

            public void projectOpened(@NotNull Project eventProject) {
                Intrinsics.checkParameterIsNotNull((Object)eventProject, (String)"eventProject");
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    this.$handler.invoke((Object)eventProject);
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
            }
        });
    }

    public static /* bridge */ /* synthetic */ void runWhenProjectOpened$default(Project project, Function1 handler, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Project project2 = project;
        ComponentManager componentManager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)componentManager, (String)"(project ?: ApplicationManager.getApplication())");
        MessageBusConnection connection = componentManager.getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new /* invalid duplicate definition of identical inner class */);
    }
}

