/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class PackageWrapper {
    private final PsiManager myManager;
    @NotNull
    private final String myQualifiedName;

    public PackageWrapper(PsiManager manager, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PackageWrapper.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public PackageWrapper(PsiPackage aPackage) {
        this.myManager = aPackage.getManager();
        this.myQualifiedName = aPackage.getQualifiedName();
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public PsiDirectory[] getDirectories() {
        String qName = this.myQualifiedName;
        while (qName.endsWith(".")) {
            qName = StringUtil.trimEnd((String)qName, (String)".");
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(qName);
        if (aPackage != null) {
            return aPackage.getDirectories();
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public boolean exists() {
        Project project = this.myManager.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(this.myQualifiedName);
        return aPackage != null && aPackage.getDirectories(GlobalSearchScope.projectScope(project)).length > 0;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            PackageWrapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean equalToPackage(PsiPackage aPackage) {
        return aPackage != null && this.myQualifiedName.equals(aPackage.getQualifiedName());
    }

    public static PackageWrapper create(PsiPackage aPackage) {
        return new PackageWrapper(aPackage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/PackageWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/PackageWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

