/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectTaskManager {
    @NotNull
    protected final Project myProject;

    public ProjectTaskManager(@NotNull Project project) {
        if (project == null) {
            ProjectTaskManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static ProjectTaskManager getInstance(Project project) {
        return ServiceManager.getService(project, ProjectTaskManager.class);
    }

    public abstract void run(@NotNull ProjectTask var1, @Nullable ProjectTaskNotification var2);

    public abstract void run(@NotNull ProjectTaskContext var1, @NotNull ProjectTask var2, @Nullable ProjectTaskNotification var3);

    public abstract void buildAllModules(@Nullable ProjectTaskNotification var1);

    public void buildAllModules() {
        this.buildAllModules(null);
    }

    public abstract void rebuildAllModules(@Nullable ProjectTaskNotification var1);

    public void rebuildAllModules() {
        this.rebuildAllModules(null);
    }

    public abstract void build(@NotNull Module[] var1, @Nullable ProjectTaskNotification var2);

    public void build(Module ... modules) {
        if (modules == null) {
            ProjectTaskManager.$$$reportNull$$$0(1);
        }
        this.build(modules, (ProjectTaskNotification)null);
    }

    public abstract void rebuild(@NotNull Module[] var1, @Nullable ProjectTaskNotification var2);

    public void rebuild(Module ... modules) {
        if (modules == null) {
            ProjectTaskManager.$$$reportNull$$$0(2);
        }
        this.rebuild(modules, (ProjectTaskNotification)null);
    }

    public abstract void compile(@NotNull VirtualFile[] var1, @Nullable ProjectTaskNotification var2);

    public void compile(VirtualFile ... files) {
        if (files == null) {
            ProjectTaskManager.$$$reportNull$$$0(3);
        }
        this.compile(files, (ProjectTaskNotification)null);
    }

    public abstract void build(@NotNull ProjectModelBuildableElement[] var1, @Nullable ProjectTaskNotification var2);

    public void build(ProjectModelBuildableElement ... buildableElements) {
        if (buildableElements == null) {
            ProjectTaskManager.$$$reportNull$$$0(4);
        }
        this.build(buildableElements, (ProjectTaskNotification)null);
    }

    public abstract void rebuild(@NotNull ProjectModelBuildableElement[] var1, @Nullable ProjectTaskNotification var2);

    public void rebuild(ProjectModelBuildableElement ... buildableElements) {
        if (buildableElements == null) {
            ProjectTaskManager.$$$reportNull$$$0(5);
        }
        this.rebuild(buildableElements, (ProjectTaskNotification)null);
    }

    public abstract ProjectTask createAllModulesBuildTask(boolean var1, Project var2);

    public abstract ProjectTask createModulesBuildTask(Module var1, boolean var2, boolean var3, boolean var4);

    public abstract ProjectTask createModulesBuildTask(Module[] var1, boolean var2, boolean var3, boolean var4);

    public abstract ProjectTask createBuildTask(boolean var1, ProjectModelBuildableElement ... var2);

    public ProjectTask createArtifactsBuildTask(boolean isIncrementalBuild, ProjectModelBuildableElement ... artifacts) {
        return this.createBuildTask(isIncrementalBuild, artifacts);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildableElements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/task/ProjectTaskManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuild";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

