/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.parsing.HbRawLexer;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HbHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1;
    private static final Map<IElementType, TextAttributesKey> keys2;
    private static final TextAttributesKey MUSTACHES;
    private static final TextAttributesKey IDENTIFIERS;
    private static final TextAttributesKey COMMENTS;
    private static final TextAttributesKey OPERATORS;
    private static final TextAttributesKey VALUES;
    private static final TextAttributesKey STRINGS;
    private static final TextAttributesKey DATA_PREFIX;
    private static final TextAttributesKey ESCAPE;
    public static final Map<TextAttributesKey, Pair<String, HighlightSeverity>> DISPLAY_NAMES;

    @NotNull
    public Lexer getHighlightingLexer() {
        HbRawLexer hbRawLexer = new HbRawLexer();
        if (hbRawLexer == null) {
            HbHighlighter.$$$reportNull$$$0(0);
        }
        return hbRawLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = HbHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
        if (textAttributesKeyArray == null) {
            HbHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        MUSTACHES = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.MUSTACHES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        IDENTIFIERS = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.IDENTIFIERS", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        COMMENTS = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.COMMENTS", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        OPERATORS = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.OPERATORS", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        VALUES = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.VALUES", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        STRINGS = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.STRINGS", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        DATA_PREFIX = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.DATA_PREFIX", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        ESCAPE = TextAttributesKey.createTextAttributesKey((String)"HANDLEBARS.ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        keys1 = new HashMap<IElementType, TextAttributesKey>();
        keys2 = new HashMap<IElementType, TextAttributesKey>();
        keys1.put(HbTokenTypes.OPEN, MUSTACHES);
        keys1.put(HbTokenTypes.OPEN_BLOCK, MUSTACHES);
        keys1.put(HbTokenTypes.OPEN_PARTIAL, MUSTACHES);
        keys1.put(HbTokenTypes.OPEN_ENDBLOCK, MUSTACHES);
        keys1.put(HbTokenTypes.OPEN_INVERSE, MUSTACHES);
        keys1.put(HbTokenTypes.OPEN_UNESCAPED, MUSTACHES);
        keys1.put(HbTokenTypes.CLOSE_UNESCAPED, MUSTACHES);
        keys1.put(HbTokenTypes.CLOSE, MUSTACHES);
        keys1.put(HbTokenTypes.ID, IDENTIFIERS);
        keys1.put(HbTokenTypes.COMMENT, COMMENTS);
        keys1.put(HbTokenTypes.COMMENT_OPEN, COMMENTS);
        keys1.put(HbTokenTypes.COMMENT_CLOSE, COMMENTS);
        keys1.put(HbTokenTypes.COMMENT_CONTENT, COMMENTS);
        keys1.put(HbTokenTypes.UNCLOSED_COMMENT, COMMENTS);
        keys1.put(HbTokenTypes.EQUALS, OPERATORS);
        keys1.put(HbTokenTypes.SEP, OPERATORS);
        keys1.put(HbTokenTypes.NUMBER, VALUES);
        keys1.put(HbTokenTypes.ELSE, IDENTIFIERS);
        keys1.put(HbTokenTypes.BOOLEAN, VALUES);
        keys1.put(HbTokenTypes.STRING, STRINGS);
        keys1.put(HbTokenTypes.DATA_PREFIX, DATA_PREFIX);
        keys1.put(HbTokenTypes.ESCAPE_CHAR, ESCAPE);
        DISPLAY_NAMES = new LinkedHashMap<TextAttributesKey, Pair<String, HighlightSeverity>>();
        DISPLAY_NAMES.put(MUSTACHES, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.mustaches.key", new Object[0]), null));
        DISPLAY_NAMES.put(IDENTIFIERS, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.identifiers.key", new Object[0]), null));
        DISPLAY_NAMES.put(COMMENTS, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.comments.key", new Object[0]), null));
        DISPLAY_NAMES.put(OPERATORS, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.operators.key", new Object[0]), null));
        DISPLAY_NAMES.put(VALUES, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.values.key", new Object[0]), null));
        DISPLAY_NAMES.put(STRINGS, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.strings.key", new Object[0]), null));
        DISPLAY_NAMES.put(DATA_PREFIX, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.data.prefix.key", new Object[0]), null));
        DISPLAY_NAMES.put(ESCAPE, (Pair<String, HighlightSeverity>)new Pair((Object)HbBundle.message("hb.page.colors.descriptor.escape.key", new Object[0]), null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/dmarcotte/handlebars/HbHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

