/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.braces;

import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HbBraceMatcher
implements BraceMatcher {
    private static final Set<IElementType> LEFT_BRACES = new HashSet<IElementType>();
    private static final Set<IElementType> RIGHT_BRACES = new HashSet<IElementType>();

    public boolean isPairBraces(IElementType tokenType1, IElementType tokenType2) {
        return LEFT_BRACES.contains(tokenType1) && RIGHT_BRACES.contains(tokenType2) || RIGHT_BRACES.contains(tokenType1) && LEFT_BRACES.contains(tokenType2);
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        return LEFT_BRACES.contains(iterator.getTokenType());
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        if (!RIGHT_BRACES.contains(iterator.getTokenType())) {
            return false;
        }
        boolean isRBraceToken = false;
        int iteratorRetreatCount = 0;
        block0: while (true) {
            iterator.retreat();
            ++iteratorRetreatCount;
            if (iterator.atEnd() || iterator.getTokenType() == HbTokenTypes.OPEN_BLOCK) break;
            if (iterator.getTokenType() == HbTokenTypes.OPEN_INVERSE) {
                while (iteratorRetreatCount-- > 0) {
                    iterator.advance();
                    if (iterator.getTokenType() == HbTokenTypes.ID) break block0;
                    if (iterator.getTokenType() != HbTokenTypes.CLOSE) continue;
                    isRBraceToken = true;
                    break block0;
                }
                break;
            }
            if (iterator.getTokenType() != HbTokenTypes.OPEN && iterator.getTokenType() != HbTokenTypes.OPEN_PARTIAL && iterator.getTokenType() != HbTokenTypes.OPEN_UNESCAPED && iterator.getTokenType() != HbTokenTypes.OPEN_ENDBLOCK) continue;
            isRBraceToken = true;
        }
        while (iteratorRetreatCount-- > 0) {
            iterator.advance();
        }
        return isRBraceToken;
    }

    public int getBraceTokenGroupId(IElementType tokenType) {
        return 1;
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        return false;
    }

    @Nullable
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            HbBraceMatcher.$$$reportNull$$$0(0);
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            HbBraceMatcher.$$$reportNull$$$0(1);
        }
        return true;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }

    static {
        LEFT_BRACES.add(HbTokenTypes.OPEN);
        LEFT_BRACES.add(HbTokenTypes.OPEN_PARTIAL);
        LEFT_BRACES.add(HbTokenTypes.OPEN_UNESCAPED);
        LEFT_BRACES.add(HbTokenTypes.OPEN_BLOCK);
        LEFT_BRACES.add(HbTokenTypes.OPEN_INVERSE);
        RIGHT_BRACES.add(HbTokenTypes.CLOSE);
        RIGHT_BRACES.add(HbTokenTypes.CLOSE_UNESCAPED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
        }
        objectArray2[1] = "com/dmarcotte/handlebars/editor/braces/HbBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

