/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.folding;

import com.dmarcotte.handlebars.config.HbConfig;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbBlockWrapper;
import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HbFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            HbFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            HbFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        this.appendDescriptors(node.getPsi(), descriptors, document);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            HbFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private void appendDescriptors(PsiElement psi, List<FoldingDescriptor> descriptors, Document document) {
        ASTNode commentNode;
        String commentText;
        if (HbFoldingBuilder.isSingleLine(psi, document)) {
            return;
        }
        if (HbTokenTypes.COMMENT == psi.getNode().getElementType() && (commentText = (commentNode = psi.getNode()).getText()).length() > 6 && commentText.substring(0, 3).equals("{{!") && commentText.substring(commentText.length() - 2).equals("}}")) {
            TextRange range = new TextRange(commentNode.getTextRange().getStartOffset() + 3, commentNode.getTextRange().getEndOffset() - 2);
            descriptors.add(new FoldingDescriptor(commentNode, range));
        }
        if (psi instanceof HbBlockWrapper) {
            PsiElement endOpenBlockStache = this.getOpenBlockCloseStacheElement(psi.getFirstChild());
            PsiElement endCloseBlockStache = this.getCloseBlockCloseStacheElement(psi.getLastChild());
            if (endOpenBlockStache != null && endCloseBlockStache != null) {
                int endOfFirstOpenStacheLine = document.getLineEndOffset(document.getLineNumber(psi.getTextRange().getStartOffset()));
                int foldingRangeStartOffset = Math.min(endOpenBlockStache.getTextRange().getStartOffset(), endOfFirstOpenStacheLine);
                int foldingRangeEndOffset = endCloseBlockStache.getTextRange().getStartOffset();
                TextRange range = new TextRange(foldingRangeStartOffset, foldingRangeEndOffset);
                descriptors.add(new FoldingDescriptor(psi, range));
            }
        }
        for (PsiElement child = psi.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.appendDescriptors(child, descriptors, document);
        }
    }

    private PsiElement getOpenBlockCloseStacheElement(PsiElement psiElement) {
        if (!(psiElement instanceof HbOpenBlockMustache)) {
            return null;
        }
        PsiElement endOpenStache = psiElement.getLastChild();
        if (endOpenStache == null || endOpenStache.getNode().getElementType() != HbTokenTypes.CLOSE) {
            return null;
        }
        return endOpenStache;
    }

    private PsiElement getCloseBlockCloseStacheElement(PsiElement psiElement) {
        if (!(psiElement instanceof HbCloseBlockMustache)) {
            return null;
        }
        PsiElement endCloseStache = psiElement.getLastChild();
        if (endCloseStache == null || endCloseStache.getNode().getElementType() != HbTokenTypes.CLOSE) {
            return null;
        }
        return endCloseStache;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            HbFoldingBuilder.$$$reportNull$$$0(3);
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            HbFoldingBuilder.$$$reportNull$$$0(4);
        }
        return HbConfig.isAutoCollapseBlocksEnabled();
    }

    private static boolean isSingleLine(PsiElement element, Document document) {
        TextRange range = element.getTextRange();
        return document.getLineNumber(range.getStartOffset()) == document.getLineNumber(range.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/editor/folding/HbFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/editor/folding/HbFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

