/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.inspections;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.inspections.HbBlockMismatchFix;
import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbMustacheName;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class HbBlockMismatchAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        HbCloseBlockMustache closeBlockMustache;
        HbOpenBlockMustache openBlockElement;
        if (element == null) {
            HbBlockMismatchAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HbBlockMismatchAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof HbOpenBlockMustache) {
            HbOpenBlockMustache openBlockMustache = (HbOpenBlockMustache)element;
            HbMustacheName openBlockMustacheName = openBlockMustache.getBlockMustacheName();
            HbCloseBlockMustache closeBlockMustache2 = openBlockMustache.getPairedElement();
            if (closeBlockMustache2 != null) {
                String closeBlockName;
                HbMustacheName closeBlockMustacheName = closeBlockMustache2.getBlockMustacheName();
                if (openBlockMustacheName == null || closeBlockMustacheName == null) {
                    return;
                }
                String openBlockName = openBlockMustacheName.getName();
                if (!openBlockName.equals(closeBlockName = closeBlockMustacheName.getName())) {
                    Annotation openBlockAnnotation = holder.createErrorAnnotation((PsiElement)openBlockMustacheName, HbBundle.message("hb.block.mismatch.inspection.open.block", openBlockName, closeBlockName));
                    openBlockAnnotation.registerFix((IntentionAction)new HbBlockMismatchFix(closeBlockName, openBlockName, true));
                    openBlockAnnotation.registerFix((IntentionAction)new HbBlockMismatchFix(openBlockName, closeBlockName, false));
                    Annotation closeBlockAnnotation = holder.createErrorAnnotation((PsiElement)closeBlockMustacheName, HbBundle.message("hb.block.mismatch.inspection.close.block", openBlockName, closeBlockName));
                    closeBlockAnnotation.registerFix((IntentionAction)new HbBlockMismatchFix(openBlockName, closeBlockName, false));
                    closeBlockAnnotation.registerFix((IntentionAction)new HbBlockMismatchFix(closeBlockName, openBlockName, true));
                }
            } else {
                if (openBlockMustacheName == null) {
                    return;
                }
                holder.createErrorAnnotation((PsiElement)openBlockMustacheName, HbBundle.message("hb.block.mismatch.inspection.missing.end.block", openBlockMustache.getName()));
            }
        }
        if (element instanceof HbCloseBlockMustache && (openBlockElement = (closeBlockMustache = (HbCloseBlockMustache)element).getPairedElement()) == null) {
            HbMustacheName closeBlockMustacheName = closeBlockMustache.getBlockMustacheName();
            if (closeBlockMustacheName == null) {
                return;
            }
            holder.createErrorAnnotation((PsiElement)closeBlockMustacheName, HbBundle.message("hb.block.mismatch.inspection.missing.start.block", closeBlockMustache.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/dmarcotte/handlebars/inspections/HbBlockMismatchAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

