/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lexer.FlexLexer;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public enum DialectOptionHolder {
    ECMA_4("ECMA_4"),
    ECMA_6("ECMA_6"),
    JS_1_5("JS_1_5"),
    JS_1_6("JS_1_6"),
    JS_1_7("JS_1_7"),
    JS_1_8("JS_1_8"),
    E4X("E4X"),
    JSX("JSX"),
    GWT("GWT"),
    TS("TS"),
    TSX("TSX"),
    NASHORN("NASHORN"),
    FLOW("FLOW"),
    COFFEESCRIPT("COFFEESCRIPT"),
    JS_IN_JADE("JS_IN_JADE"),
    OTHER("OTHER");

    public final boolean isECMA4;
    private final boolean isJavaScript1_6_OrHigher;
    private final boolean hasE4X;
    private final boolean isJavaScript1_7_OrHigher;
    private final boolean isJavaScript1_8_OrHigher;
    public final boolean isGwt;
    public final boolean isECMA6;
    public final boolean isTypeScript;
    public final boolean isNashorn;
    public final boolean isFlow;
    public final boolean isTSX;
    public final boolean isJSX;
    public final boolean isCoffeeScript;
    private final ImmutableSet<JSLanguageFeature> myFeatures;
    private final Constructor myLexerClass;

    private DialectOptionHolder(String name) {
        if (name == null) {
            DialectOptionHolder.$$$reportNull$$$0(0);
        }
        this.isECMA4 = "ECMA_4".equals(name);
        this.isGwt = "GWT".equals(name);
        this.isFlow = "FLOW".equals(name);
        this.isTSX = "TSX".equals(name);
        this.isJavaScript1_8_OrHigher = "JS_1_8".equals(name);
        this.isJavaScript1_7_OrHigher = this.isJavaScript1_8_OrHigher || "JS_1_7".equals(name);
        this.isJavaScript1_6_OrHigher = this.isJavaScript1_7_OrHigher || "JS_1_6".equals(name) || "JS_IN_JADE".equals(name);
        this.hasE4X = this.isJavaScript1_6_OrHigher || "E4X".equals(name) || "JSX".equals(name) || this.isFlow || this.isTSX;
        this.isNashorn = "NASHORN".equals(name);
        this.isECMA6 = "ECMA_6".equals(name) || "JSX".equals(name) || this.isFlow || this.isNashorn;
        this.isTypeScript = "TS".equals(name) || this.isTSX;
        this.isCoffeeScript = "COFFEESCRIPT".equals(name);
        this.isJSX = this.isTSX || this.isFlow || "JSX".equals(name) || this.isCoffeeScript;
        this.myFeatures = this.defineFeatures(name);
        if (!this.isCoffeeScript) {
            try {
                this.myLexerClass = Class.forName("com.intellij.lang.javascript._" + name + "Lexer").getConstructor(Reader.class, Boolean.TYPE);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.myLexerClass = null;
        }
    }

    private ImmutableSet<JSLanguageFeature> defineFeatures(@NotNull String name) {
        if (name == null) {
            DialectOptionHolder.$$$reportNull$$$0(1);
        }
        EnumSet<JSLanguageFeature> features = EnumSet.noneOf(JSLanguageFeature.class);
        if (this.hasE4X || this.isJavaScript1_6_OrHigher || this.isECMA4) {
            features.add(JSLanguageFeature.E4X);
        }
        if (this.isJavaScript1_6_OrHigher || this.isECMA4 || this.isNashorn) {
            features.add(JSLanguageFeature.FOR_EACH);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.FOR_OF);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.LET_DEFINITIONS);
            features.add(JSLanguageFeature.CONST_DEFINITIONS);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.YIELD_GENERATORS);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.ARRAY_COMPREHENSIONS);
        }
        if (this.isJavaScript1_7_OrHigher) {
            features.add(JSLanguageFeature.LET_SCOPE);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.DESTRUCTURING_PARAMETERS);
        }
        if (this.isJavaScript1_8_OrHigher || this.isNashorn) {
            features.add(JSLanguageFeature.EXPRESSION_CLOSURES);
        }
        if (this.isJavaScript1_8_OrHigher) {
            features.add(JSLanguageFeature.GENERATOR_EXPRESSIONS);
        }
        features.add(JSLanguageFeature.ACCESSORS);
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.ARROW_FUNCTIONS);
        }
        if (this.isECMA4 || this.isECMA6 || this.isTypeScript || name.equals("JS_IN_JADE")) {
            features.add(JSLanguageFeature.REST_PARAMETERS);
        }
        if (this.isTypeScript || this.isFlow) {
            features.add(JSLanguageFeature.GENERICS);
        }
        if (this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.IMPORT_DECLARATIONS);
        }
        if (this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        if (this.isECMA4 || this.isTypeScript || this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.CLASSES);
        }
        if (this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.ANNOTATIONS);
            features.add(JSLanguageFeature.ASYNC_AWAIT);
            features.add(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            features.add(JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            features.add(JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
            features.add(JSLanguageFeature.STRING_TEMPLATES);
        }
        if (this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.BIND_EXPRESSIONS);
            features.add(JSLanguageFeature.UNICODE_ESCAPES_WITH_BRACES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA4) {
            features.add(JSLanguageFeature.TYPES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.TRAILING_FUNCTION_COMMA);
            features.add(JSLanguageFeature.OPTIONAL_CATCH_BINDING);
        }
        if (this.isECMA6 && !this.isNashorn) {
            if (!this.isFlow) {
                features.add(JSLanguageFeature.BIG_INT);
                features.add(JSLanguageFeature.OPTIONAL_CHAINING_OPERATOR);
            }
            features.add(JSLanguageFeature.PRIVATE_SHARP_SYNTAX);
        }
        if (this.isTypeScript || this.isECMA4) {
            features.add(JSLanguageFeature.VISIBILITY_MODIFIERS);
        }
        return Sets.immutableEnumSet(features);
    }

    public boolean hasFeature(@NotNull JSLanguageFeature feature) {
        if (feature == null) {
            DialectOptionHolder.$$$reportNull$$$0(2);
        }
        return this.myFeatures.contains((Object)feature);
    }

    public boolean isJavaScript() {
        return this != ECMA_4 && this != TS && this != TSX && this != OTHER;
    }

    public boolean hasE4XStandard() {
        return this.isECMA4 || this.isJavaScript1_6_OrHigher;
    }

    @NotNull
    public FlexLexer createLexer(boolean highlightMode) {
        FlexLexer flexLexer;
        try {
            flexLexer = (FlexLexer)this.myLexerClass.newInstance(null, highlightMode);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (flexLexer == null) {
            DialectOptionHolder.$$$reportNull$$$0(3);
        }
        return flexLexer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/DialectOptionHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/DialectOptionHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "defineFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasFeature";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

