/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;

public class JSReplaceConditionalWithIfIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = element -> {
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            JSConditionalExpression condExpr = (JSConditionalExpression)element;
            JSSourceElement statementCandidate = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)condExpr, (Class[])new Class[]{JSStatement.class, JSFunction.class});
            if (!(statementCandidate instanceof JSStatement) || statementCandidate instanceof ES6FieldStatementImpl) {
                return false;
            }
            return condExpr.getCondition() != null && condExpr.getThen() != null && condExpr.getElse() != null;
        };
        if (jSElementPredicate == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(0);
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(1);
        }
        JSConditionalExpression conditional = (JSConditionalExpression)element;
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        JSExpression topExpression = JSReplaceConditionalWithIfIntention.getTopExpressionInStatement(conditional);
        assert (statement != null);
        if (topExpression.getParent() instanceof JSVariable && topExpression.getParent().getParent() == statement && statement instanceof JSVarStatement) {
            JSType type;
            JSVariable declaration = (JSVariable)topExpression.getParent();
            JSExpression initializer = declaration.getInitializer();
            if (initializer == null) {
                return;
            }
            String replacementText = JSReplaceConditionalWithIfIntention.getReplacementText(declaration.getName() + " = ", JSCodeStyleSettings.getSemicolon((PsiElement)initializer), conditional, (JSElement)initializer);
            if (DialectDetector.hasFeature((PsiElement)declaration, (JSLanguageFeature)JSLanguageFeature.TYPES) && declaration.getTypeElement() == null && (type = JSResolveUtil.getExpressionJSType((JSExpression)initializer)) != null) {
                JSRefactoringUtil.setType((JSElement)declaration, (String)BaseCreateFix.getTypeText((JSType)type, (PsiElement)initializer));
            }
            JSRefactoringUtil.removeInitializer((JSInitializerOwner)declaration);
            JSStatement replacement = (JSStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)replacementText, (PsiElement)declaration, JSStatement.class);
            if (replacement == null) {
                return;
            }
            JSChangeUtil.doAddAfter((PsiElement)statement.getParent(), (PsiElement)replacement, (PsiElement)statement);
        } else {
            JSElementFactory.replaceStatement((JSStatement)statement, (String)JSReplaceConditionalWithIfIntention.getReplacementText("", "", conditional, (JSElement)statement));
        }
    }

    @NotNull
    private static JSExpression getTopExpressionInStatement(@NotNull JSConditionalExpression conditional) {
        if (conditional == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(2);
        }
        JSConditionalExpression result = conditional;
        while (true) {
            JSExpression next;
            if ((next = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)result, JSExpression.class, (boolean)true, (Class[])new Class[]{JSSourceElement.class})) == null) {
                JSConditionalExpression jSConditionalExpression = result;
                if (jSConditionalExpression == null) {
                    JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(3);
                }
                return jSConditionalExpression;
            }
            result = next;
        }
    }

    @NotNull
    private static String getReplacementText(@NotNull String prefix, String postfix, @NotNull JSConditionalExpression conditional, @NotNull JSElement toReplace) {
        if (prefix == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(4);
        }
        if (conditional == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(5);
        }
        if (toReplace == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(6);
        }
        String statementText = toReplace.getText();
        String conditionalText = JSPsiImplUtils.getTopmostParenthesizedOrSelf((JSExpression)conditional).getText();
        int conditionalIndex = statementText.indexOf(conditionalText);
        String statementStart = statementText.substring(0, conditionalIndex);
        String statementEnd = statementText.substring(conditionalIndex + conditionalText.length());
        JSExpression condition = ParenthesesUtils.stripParentheses((JSExpression)conditional.getCondition());
        JSExpression thenExpression = ParenthesesUtils.stripParentheses((JSExpression)conditional.getThen());
        JSExpression elseExpression = ParenthesesUtils.stripParentheses((JSExpression)conditional.getElse());
        String string = "if (" + condition.getText() + ") {" + prefix + statementStart + thenExpression.getText() + statementEnd + postfix + "} else {" + prefix + statementStart + elseExpression.getText() + statementEnd + postfix + '}';
        if (string == null) {
            JSReplaceConditionalWithIfIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditional";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/conditional/JSReplaceConditionalWithIfIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopExpressionInStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopExpressionInStatement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

