/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.codeInsight.NodePathManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleManager {
    private final Project myProject;
    private final NodePathManager myNodePathManager;
    private final NodeJsCoreLibraryManager myCoreLibraryManager;

    public NodeModuleManager(@NotNull Project project, @NotNull NodeJsCoreLibraryManager coreLibraryManager) {
        if (project == null) {
            NodeModuleManager.$$$reportNull$$$0(0);
        }
        if (coreLibraryManager == null) {
            NodeModuleManager.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myNodePathManager = new NodePathManager(project);
        this.myCoreLibraryManager = coreLibraryManager;
    }

    @NotNull
    public static NodeModuleManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeModuleManager.$$$reportNull$$$0(2);
        }
        NodeModuleManager nodeModuleManager = (NodeModuleManager)ServiceManager.getService((Project)project, NodeModuleManager.class);
        if (nodeModuleManager == null) {
            NodeModuleManager.$$$reportNull$$$0(3);
        }
        return nodeModuleManager;
    }

    private void collectCoreModules(@NotNull VirtualFile requester, @NotNull Map<String, CompletionModuleInfo> modules) {
        if (requester == null) {
            NodeModuleManager.$$$reportNull$$$0(4);
        }
        if (modules == null) {
            NodeModuleManager.$$$reportNull$$$0(5);
        }
        if (this.myCoreLibraryManager.isAssociatedWithNodeCoreLibrary(requester)) {
            NodeJsCoreLibraryManager coreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)this.myProject);
            Collection coreModuleNames = coreLibraryManager.listCoreModuleNames();
            for (String coreModuleName : coreModuleNames) {
                modules.put(coreModuleName, new CompletionModuleInfo(coreModuleName, null, ModuleType.CORE_MODULE));
            }
        }
    }

    @NotNull
    public Collection<CompletionModuleInfo> collectVisibleNodeModules(@Nullable VirtualFile requester) {
        HashMap modules = ContainerUtil.newHashMap();
        if (requester != null) {
            this.collectCoreModules(requester, modules);
        }
        NodeSettings settings = this.getSettings();
        NodeModuleSearchUtil.collectVisibleNodeModules((Map)modules, (Project)this.myProject, (VirtualFile)requester, (NodeSettings)settings);
        Collection<CompletionModuleInfo> collection = modules.values();
        if (collection == null) {
            NodeModuleManager.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    private NodeSettings getSettings() {
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)this.myProject).getInterpreter();
        return NodeSettings.create((NodeJsLocalInterpreter)NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter));
    }

    @Nullable
    public ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester) {
        NodeJsCoreLibraryManager coreLibraryManager;
        VirtualFile resolvedModuleFile;
        if (requiredModuleName == null) {
            NodeModuleManager.$$$reportNull$$$0(7);
        }
        if ((resolvedModuleFile = (coreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)this.myProject)).findCoreModuleFileByName(requiredModuleName)) != null) {
            return new ResolvedModuleInfo(resolvedModuleFile, ModuleType.CORE_MODULE);
        }
        List<VirtualFile> nodePathFolders = this.myNodePathManager.getNodePaths();
        return NodeModuleSearchUtil.resolveModule((String)requiredModuleName, (VirtualFile)requester, (NodeSettings)this.getSettings(), nodePathFolders, (boolean)true, (Project)this.myProject);
    }

    public void dropNodePathCache() {
        this.myNodePathManager.dropCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLibraryManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/NodeModuleManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requester";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/NodeModuleManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleNodeModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectCoreModules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

