/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.core.NodeJsCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.boilerplate.express.ExpressProjectPeer;
import com.jetbrains.nodejs.boilerplate.express.ExpressProjectSettings;
import com.jetbrains.nodejs.boilerplate.express.ExpressStylesheetEngine;
import com.jetbrains.nodejs.boilerplate.express.ExpressTemplateEngine;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressProjectGenerator
extends WebProjectTemplate<ExpressProjectSettings> {
    private static final Logger LOG = Logger.getInstance(ExpressProjectGenerator.class);
    static final String EXPRESS_GENERATOR_PKG_NAME = "express-generator";

    @NotNull
    @Nls
    public String getName() {
        if ("Node.js Express App" == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(0);
        }
        return "Node.js Express App";
    }

    public String getDescription() {
        return "<html>Express.js application skeleton from <a href='http://expressjs.com'>http://expressjs.com</a></html>";
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Nodejs.Nodejs;
    }

    @Nullable
    public String getHelpId() {
        return "create.from.express-js.skeleton";
    }

    public boolean postponeValidation() {
        return false;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull ExpressProjectSettings settings, @NotNull Module module) {
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(4);
        }
        try {
            File projectDir = new File(baseDir.getPath());
            TmpData tmpData = ExpressProjectGenerator.installExpressGeneratorPackage(project, settings);
            ExpressProjectGenerator.generateExpressApp(project, projectDir, tmpData, settings);
            ExpressProjectGenerator.installDependencies(project, projectDir, settings);
            NodeJsInterpreterManager.getInstance((Project)project).setInterpreterRef(settings.getInterpreterRef());
            ExpressProjectGenerator.promptNodeCoreSourcesConfiguration(project, settings.getInterpreter());
            RefreshQueue.getInstance().refresh(true, true, () -> {
                if (project == null) {
                    ExpressProjectGenerator.$$$reportNull$$$0(40);
                }
                if (baseDir == null) {
                    ExpressProjectGenerator.$$$reportNull$$$0(41);
                }
                if (project.isDisposed()) {
                    return;
                }
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (project == null) {
                        ExpressProjectGenerator.$$$reportNull$$$0(42);
                    }
                    if (baseDir == null) {
                        ExpressProjectGenerator.$$$reportNull$$$0(43);
                    }
                    ExpressProjectGenerator.createRunConfiguration(project, baseDir);
                });
            }, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance()));
            if (!FileUtil.delete((File)tmpData.getRootDir())) {
                LOG.warn("Cannot delete " + tmpData.getRootDir());
            } else {
                LOG.info("Successfully deleted " + tmpData.getRootDir());
            }
        }
        catch (GeneratorException e) {
            LOG.warn((Throwable)e);
            ExpressProjectGenerator.showErrorMessage(project, e.getMessage());
        }
    }

    private static void promptNodeCoreSourcesConfiguration(@NotNull Project project, @NotNull NodeJsInterpreter interpreter) {
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(5);
        }
        if (interpreter == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(6);
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (interpreter == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(36);
            }
            if (project == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(37);
            }
            interpreter.provideCachedVersionOrFetch(version -> {
                if (project == null) {
                    ExpressProjectGenerator.$$$reportNull$$$0(38);
                }
                if (interpreter == null) {
                    ExpressProjectGenerator.$$$reportNull$$$0(39);
                }
                if (version != null) {
                    NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance((Project)project);
                    configurator.configureAndAssociateWithProject(interpreter, version, null);
                }
            });
        });
    }

    private static void createRunConfiguration(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(8);
        }
        Ref appFileRef = Ref.create();
        String name = FileUtil.toSystemDependentName((String)"bin/www");
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(34);
            }
            if (baseDir == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(35);
            }
            for (RunnerAndConfigurationSettings settings : RunManager.getInstance((Project)project).getAllSettings()) {
                if (!name.equals(settings.getName())) continue;
                return;
            }
            appFileRef.set((Object)VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{"bin", "www"}));
        });
        if (appFileRef.isNull()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(32);
            }
            if (baseDir == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(33);
            }
            ConfigurationFactory configurationFactory = NodeJsRunConfigurationType.getInstance().getFactory();
            RunnerAndConfigurationSettings rac = RunManager.getInstance((Project)project).createRunConfiguration("", configurationFactory);
            NodeJsRunConfiguration runConfig = (NodeJsRunConfiguration)((Object)((Object)ObjectUtils.tryCast((Object)rac.getConfiguration(), NodeJsRunConfiguration.class)));
            if (runConfig == null) {
                return;
            }
            VirtualFile appFile = (VirtualFile)appFileRef.get();
            runConfig.setName(name);
            runConfig.setWorkingDirectory(baseDir.getPath());
            runConfig.setInputPath(VfsUtilCore.getRelativePath((VirtualFile)appFile, (VirtualFile)baseDir, (char)File.separatorChar));
            LinkedHashMap env = new LinkedHashMap();
            env.putAll(runConfig.getEnvs());
            env.put("DEBUG", ExpressProjectGenerator.createAppName(baseDir.getName()) + ":*");
            runConfig.setEnvs((Map<String, String>)env);
            StartBrowserSettings browserSettings = new StartBrowserSettings();
            browserSettings.setUrl("http://localhost:3000/");
            runConfig.setStartBrowserSettings(browserSettings);
            RunManager runManager = RunManager.getInstance((Project)project);
            rac.setShared(true);
            runManager.addConfiguration(rac);
            runManager.setSelectedConfiguration(rac);
        });
    }

    @NotNull
    public static String createAppName(@NotNull String directoryName) {
        if (directoryName == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(9);
        }
        String string = directoryName.replaceAll("[^A-Za-z0-9.-]+", "-").replaceAll("^[-_.]+|-+$", "").toLowerCase(Locale.ENGLISH);
        if (string == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<ExpressProjectSettings> createPeer() {
        ExpressProjectPeer expressProjectPeer = new ExpressProjectPeer();
        if (expressProjectPeer == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(11);
        }
        return expressProjectPeer;
    }

    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private static void showErrorMessage(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(12);
        }
        if (message == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(13);
        }
        String fullMessage = "Cannot create Node.js Express App: " + message;
        String title = "Create Express Project";
        Messages.showErrorDialog((Project)project, (String)fullMessage, (String)title);
        Notifications.Bus.notify((Notification)new Notification("Express Project Generator", title, fullMessage, NotificationType.ERROR));
    }

    @NotNull
    private static TmpData installExpressGeneratorPackage(@NotNull Project project, @NotNull ExpressProjectSettings settings) throws GeneratorException {
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(14);
        }
        if (settings == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(15);
        }
        TmpData tmpData = new TmpData();
        try {
            GeneralCommandLine commandLine = NpmUtil.createNpmCommandLine((Project)project, (File)tmpData.getRootDir(), (NodeJsInterpreter)settings.getInterpreter(), (NpmCommand)NpmCommand.ADD, (List)ContainerUtil.list((Object[])new String[]{"express-generator@" + settings.getExpressGeneratorVersion().getRawVersion()}));
            ExpressProjectGenerator.executeCommandLine(project, commandLine, true);
        }
        catch (ExecutionException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
        TmpData tmpData2 = tmpData;
        if (tmpData2 == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(16);
        }
        return tmpData2;
    }

    private static void generateExpressApp(@NotNull Project project, @NotNull File projectDir, @NotNull TmpData tmpData, @NotNull ExpressProjectSettings settings) throws GeneratorException {
        String binJsFile;
        File expressGeneratorPackageDir;
        File expressGeneratorMainFile;
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(17);
        }
        if (projectDir == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(18);
        }
        if (tmpData == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(19);
        }
        if (settings == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(20);
        }
        if (!(expressGeneratorMainFile = new File(expressGeneratorPackageDir = new File(tmpData.getNodeModulesDir(), EXPRESS_GENERATOR_PKG_NAME), binJsFile = ExpressProjectGenerator.findBinJsFileForExpressGenerator(settings.getExpressGeneratorVersion()))).isFile()) {
            throw new GeneratorException("Cannot find " + expressGeneratorMainFile.getAbsolutePath());
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setWorkDirectory(projectDir);
        commandLine.addParameter(expressGeneratorMainFile.getAbsolutePath());
        ExpressProjectGenerator.addExpressParams(commandLine, settings);
        try {
            NodeCommandLineConfigurator.find((NodeJsInterpreter)settings.getInterpreter()).configure(commandLine);
        }
        catch (ExecutionException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
        ExpressProjectGenerator.executeCommandLine(project, commandLine, true);
    }

    @NotNull
    private static String findBinJsFileForExpressGenerator(@NotNull NodePackageVersion version) {
        SemVer semVer;
        if (version == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(21);
        }
        if ((semVer = SemVer.parseFromText((String)version.getRawVersion())) == null || semVer.isGreaterOrEqualThan(4, 15, 0)) {
            String string = "bin" + File.separator + "express-cli.js";
            if (string == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = "bin" + File.separator + "express";
        if (string == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static void addExpressParams(@NotNull GeneralCommandLine commandLine, @NotNull ExpressProjectSettings settings) {
        if (commandLine == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(24);
        }
        if (settings == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(25);
        }
        commandLine.addParameter("--force");
        ExpressStylesheetEngine stylesheetEngine = settings.getStylesheetEngine();
        String option = stylesheetEngine.getCliOption();
        if (option != null) {
            commandLine.addParameter("--css");
            commandLine.addParameter(option);
        }
        ExpressTemplateEngine templateEngine = settings.getTemplateEngine();
        SemVer ver = SemVer.parseFromText((String)settings.getExpressGeneratorVersion().getRawVersion());
        if (ver == null || ver.isGreaterOrEqualThan(4, 15, 0)) {
            if (templateEngine == ExpressTemplateEngine.NO_VIEW) {
                commandLine.addParameters(new String[]{"--no-view"});
            } else {
                commandLine.addParameters(new String[]{"--view"});
                commandLine.addParameters(new String[]{templateEngine.getCliOption()});
            }
        } else if (templateEngine != ExpressTemplateEngine.JADE) {
            if (templateEngine == ExpressTemplateEngine.EJS) {
                commandLine.addParameter("--ejs");
            } else if (templateEngine == ExpressTemplateEngine.HBS) {
                commandLine.addParameter("--hbs");
            } else if (templateEngine == ExpressTemplateEngine.HOGAN) {
                commandLine.addParameter("--hogan");
            } else {
                throw new RuntimeException("Unexpected template option: " + templateEngine);
            }
        }
    }

    private static void installDependencies(@NotNull Project project, @NotNull File projectDir, @NotNull ExpressProjectSettings settings) throws GeneratorException {
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(26);
        }
        if (projectDir == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(27);
        }
        if (settings == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(28);
        }
        try {
            GeneralCommandLine commandLine = NpmUtil.createNpmCommandLine((Project)project, (File)projectDir, (NodeJsInterpreter)settings.getInterpreter(), (NpmCommand)NpmCommand.INSTALL, Collections.emptyList());
            ExpressProjectGenerator.executeCommandLine(project, commandLine, false);
        }
        catch (ExecutionException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    private static void executeCommandLine(@NotNull Project project, @NotNull GeneralCommandLine commandLine, boolean logStdStreams) throws GeneratorException {
        GeneratorException exception;
        if (project == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(29);
        }
        if (commandLine == null) {
            ExpressProjectGenerator.$$$reportNull$$$0(30);
        }
        LOG.info("Running '" + commandLine.getCommandLineString() + "' in " + commandLine.getWorkDirectory());
        Ref exceptionRef = Ref.create(null);
        boolean success = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProcessOutput output;
            if (commandLine == null) {
                ExpressProjectGenerator.$$$reportNull$$$0(31);
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText(commandLine.getCommandLineString());
            try {
                output = NodeCommandLineUtil.execute((GeneralCommandLine)commandLine, (ProgressIndicator)indicator, (long)TimeUnit.DAYS.toMillis(1L));
            }
            catch (ExecutionException e) {
                exceptionRef.set((Object)new GeneratorException("Cannot execute " + commandLine.getCommandLineString(), e));
                return;
            }
            if (logStdStreams) {
                LOG.info("stdout: " + output.getStdout().trim());
                LOG.info("stderr: " + output.getStderr().trim());
            }
            String errorMessage = null;
            if (output.isTimeout()) {
                errorMessage = "Time limit exceeded for command:\n" + commandLine.getCommandLineString();
            }
            if (output.getExitCode() != 0) {
                errorMessage = "Failed command:\n" + commandLine.getCommandLineString() + "\nExit code: " + output.getExitCode();
            }
            if (errorMessage != null) {
                if (!output.getStdout().isEmpty()) {
                    errorMessage = errorMessage + "\nStandard output:\n" + output.getStdout();
                }
                if (!output.getStderr().isEmpty()) {
                    errorMessage = errorMessage + "\nStandard error:\n" + output.getStderr();
                }
                exceptionRef.set((Object)new GeneratorException(errorMessage));
            }
        }, "Express Project Generator", true, project);
        if (!success) {
            exceptionRef.set((Object)new GeneratorException("Interrupted by user"));
        }
        if ((exception = (GeneratorException)exceptionRef.get()) != null) {
            throw exception;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 33: 
            case 35: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: 
            case 15: 
            case 20: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpData";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 24: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "installExpressGeneratorPackage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinJsFileForExpressGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "promptNodeCoreSourcesConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAppName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "installExpressGeneratorPackage";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "generateExpressApp";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findBinJsFileForExpressGenerator";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addExpressParams";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "installDependencies";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "executeCommandLine";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeCommandLine$6";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRunConfiguration$5";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRunConfiguration$4";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$promptNodeCoreSourcesConfiguration$3";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$1";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TmpData {
        private final File myRootDir;
        private final File myNodeModulesDir;

        private TmpData() throws GeneratorException {
            try {
                this.myRootDir = FileUtil.createTempDirectory((String)"intellij-express-generator", null, (boolean)false);
            }
            catch (IOException e) {
                throw new GeneratorException("Can't create temporary directory for express-generator installation", e);
            }
            this.myNodeModulesDir = new File(this.myRootDir, "node_modules");
            if (!this.myNodeModulesDir.mkdirs()) {
                throw new GeneratorException("Can not create " + this.myNodeModulesDir.getAbsolutePath() + " directory");
            }
        }

        @NotNull
        public File getRootDir() {
            File file = this.myRootDir;
            if (file == null) {
                TmpData.$$$reportNull$$$0(0);
            }
            return file;
        }

        @NotNull
        public File getNodeModulesDir() {
            File file = this.myNodeModulesDir;
            if (file == null) {
                TmpData.$$$reportNull$$$0(1);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator$TmpData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootDir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeModulesDir";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class GeneratorException
    extends Exception {
        GeneratorException(String message) {
            super(message);
        }

        GeneratorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

