/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.javascript.nodejs.packages.NodePackageInfo;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionList;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionListener;
import com.jetbrains.nodejs.util.ui.UIHelper;
import com.jetbrains.nodejs.util.ui.WithDisplayName;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class NodePackageVersionView {
    private final String myPackageName;
    private final NodePackageVersionListener myListener;
    private final boolean myCacheOnFs;
    private final ComboBox myComboBox;
    private final JPanel myRefreshPanel;
    private Status myCurrentStatus;
    private final Ref<NodePackageVersion> myLastExpressVersionRef;
    private boolean myFirstUpdate;

    public NodePackageVersionView(@NotNull String packageName, @NotNull NodePackageVersionListener listener, boolean cacheOnFs) {
        if (packageName == null) {
            NodePackageVersionView.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            NodePackageVersionView.$$$reportNull$$$0(1);
        }
        this.myLastExpressVersionRef = Ref.create(null);
        this.myFirstUpdate = true;
        this.myPackageName = packageName;
        this.myListener = listener;
        this.myCacheOnFs = cacheOnFs;
        this.myComboBox = this.createEmptyComboBox();
        this.myRefreshPanel = new JPanel(new CardLayout(0, 0));
        this.addRefreshCard(Status.READY_TO_REFRESH, this.createRefreshActionComponent());
        this.addRefreshCard(Status.REFRESHING, NodePackageVersionView.createRefreshingComponent(this.myPackageName));
        this.setStatus(Status.READY_TO_REFRESH);
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NodePackageVersionView.this.fireSelectedVersionUpdatedEventIfNeeded();
            }
        });
    }

    @NotNull
    private ComboBox createEmptyComboBox() {
        ComboBox<WithDisplayName> comboBox = UIHelper.createCombobox("Unavailable   ", new WithDisplayName(){

            @Override
            public String getDisplayName() {
                if (NodePackageVersionView.this.isLoadingVersions()) {
                    return "Loading...";
                }
                return "Unavailable";
            }
        });
        if (comboBox == null) {
            NodePackageVersionView.$$$reportNull$$$0(2);
        }
        return comboBox;
    }

    private void addRefreshCard(@NotNull Status status, @NotNull Component child) {
        if (status == null) {
            NodePackageVersionView.$$$reportNull$$$0(3);
        }
        if (child == null) {
            NodePackageVersionView.$$$reportNull$$$0(4);
        }
        this.myRefreshPanel.add(child, status.name());
    }

    @NotNull
    private Component createRefreshActionComponent() {
        AnAction reloadAction = new AnAction("Reload " + this.myPackageName + " versions", null, AllIcons.Actions.Refresh){

            public void actionPerformed(AnActionEvent e) {
                NodePackageVersionView.this.asyncUpdateVersions();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(true);
            }
        };
        ActionButton actionButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        if (actionButton == null) {
            NodePackageVersionView.$$$reportNull$$$0(5);
        }
        return actionButton;
    }

    @NotNull
    private static Component createRefreshingComponent(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageVersionView.$$$reportNull$$$0(6);
        }
        AsyncProcessIcon icon = new AsyncProcessIcon(packageName + " versions loading");
        icon.setToolTipText("Updating " + packageName + " package versions");
        AsyncProcessIcon asyncProcessIcon = icon;
        if (asyncProcessIcon == null) {
            NodePackageVersionView.$$$reportNull$$$0(7);
        }
        return asyncProcessIcon;
    }

    private void fireSelectedVersionUpdatedEventIfNeeded() {
        NodePackageVersion newVersion = this.getVersion();
        NodePackageVersion lastVersion = (NodePackageVersion)this.myLastExpressVersionRef.get();
        if (newVersion == null || !newVersion.equals(lastVersion)) {
            this.myListener.onVersionSelected(newVersion);
            this.myLastExpressVersionRef.set((Object)newVersion);
        }
    }

    private void setStatus(@NotNull Status status) {
        if (status == null) {
            NodePackageVersionView.$$$reportNull$$$0(8);
        }
        CardLayout layout = (CardLayout)this.myRefreshPanel.getLayout();
        layout.show(this.myRefreshPanel, status.name());
        if (this.myCurrentStatus != status) {
            this.myComboBox.repaint();
            this.myCurrentStatus = status;
        }
    }

    boolean isLoadingVersions() {
        return this.myCurrentStatus == Status.REFRESHING;
    }

    @Nullable
    public NodePackageVersion getVersion() {
        return (NodePackageVersion)ObjectUtils.tryCast((Object)this.myComboBox.getSelectedItem(), NodePackageVersion.class);
    }

    @NotNull
    public ComboBox getComboBox() {
        ComboBox comboBox = this.myComboBox;
        if (comboBox == null) {
            NodePackageVersionView.$$$reportNull$$$0(9);
        }
        return comboBox;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add((Component)this.myComboBox);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.myRefreshPanel);
        JPanel jPanel = panel;
        if (jPanel == null) {
            NodePackageVersionView.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    public void update() {
        if (this.myFirstUpdate && this.myCacheOnFs) {
            this.setStatus(Status.REFRESHING);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                NodePackageInfo info = NodePackageUtil.loadCachedPackageInfo((String)this.myPackageName);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (info != null) {
                        NodePackageVersionList versionList = NodePackageVersionList.create(info);
                        this.setVersions(versionList);
                    }
                    this.asyncUpdateVersions();
                });
            });
        } else {
            this.asyncUpdateVersions();
        }
        this.myFirstUpdate = false;
    }

    private void asyncUpdateVersions() {
        this.setStatus(Status.REFRESHING);
        Promise promise = NpmRegistryService.getInstance().asyncUpdateAndGetPackageDistTags(this.myPackageName);
        promise.onSuccess(pairs -> {
            List versions = ContainerUtil.map((Collection)pairs, pair -> ((SemVer)pair.getSecond()).getRawVersion());
            NodePackageVersionList list = NodePackageVersionList.create(versions, (String)ContainerUtil.getFirstItem((List)versions));
            UIUtil.invokeLaterIfNeeded(() -> this.setVersions(list));
        });
    }

    private void setVersions(@NotNull NodePackageVersionList versionList) {
        if (versionList == null) {
            NodePackageVersionView.$$$reportNull$$$0(11);
        }
        ImmutableList<NodePackageVersion> newSortedVersions = versionList.getVersionsInDecreasingOrder();
        NodePackageVersion newSelectedVersion = null;
        for (NodePackageVersion version : newSortedVersions) {
            if (!version.isStable()) continue;
            if (newSelectedVersion == null) {
                newSelectedVersion = version;
            }
            if (!version.isSelectByDefault()) continue;
            newSelectedVersion = version;
            break;
        }
        SwingHelper.updateItems((JComboBox)this.myComboBox, newSortedVersions, newSelectedVersion);
        this.setStatus(Status.READY_TO_REFRESH);
        this.fireSelectedVersionUpdatedEventIfNeeded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyComboBox";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefreshActionComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefreshingComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComboBox";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRefreshCard";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRefreshingComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Status {
        READY_TO_REFRESH,
        REFRESHING;

    }
}

