/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePathManager {
    private static final String NODE_PATH = "NODE_PATH";
    private static final char NODE_PATH_SEPARATOR = (char)(SystemInfo.isWindows ? 59 : 58);
    private final Project myProject;
    private volatile List<VirtualFile> myNodePathDirs;

    public NodePathManager(@NotNull Project project) {
        if (project == null) {
            NodePathManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void dropCache() {
        this.myNodePathDirs = null;
    }

    @NotNull
    public List<VirtualFile> getNodePaths() {
        if (this.myNodePathDirs == null) {
            NodeJsRunConfiguration defaultConfiguration = NodeJsRunConfiguration.getDefaultRunConfiguration(this.myProject);
            String nodePathStr = null;
            String workingDirPath = null;
            if (defaultConfiguration != null) {
                nodePathStr = defaultConfiguration.getEnvs().get(NODE_PATH);
                workingDirPath = defaultConfiguration.getWorkingDirectory();
            }
            if (nodePathStr == null) {
                nodePathStr = EnvironmentUtil.getValue((String)NODE_PATH);
            }
            if (StringUtil.isEmptyOrSpaces(workingDirPath)) {
                workingDirPath = this.myProject.getBasePath();
            }
            List<File> nodePathIoFiles = NodePathManager.parsePathsFromNodePathEnvVariable(nodePathStr, workingDirPath);
            this.myNodePathDirs = NodeSettings.toVirtualFiles(nodePathIoFiles);
        }
        List<VirtualFile> list = this.myNodePathDirs;
        if (list == null) {
            NodePathManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static EnvironmentVariablesData prependPath(@NotNull EnvironmentVariablesData envData, @NotNull String extraNodePath) {
        String value;
        if (envData == null) {
            NodePathManager.$$$reportNull$$$0(2);
        }
        if (extraNodePath == null) {
            NodePathManager.$$$reportNull$$$0(3);
        }
        if ((value = (String)envData.getEnvs().get(NODE_PATH)) == null && envData.isPassParentEnvs()) {
            value = (String)EnvironmentUtil.getEnvironmentMap().get(NODE_PATH);
        }
        value = (value = StringUtil.notNullize((String)value)).isEmpty() || StringUtil.startsWithChar((CharSequence)value, (char)NODE_PATH_SEPARATOR) ? extraNodePath + value : extraNodePath + NODE_PATH_SEPARATOR + value;
        LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>(envData.getEnvs());
        envs.put(NODE_PATH, value);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)ImmutableMap.copyOf(envs), (boolean)envData.isPassParentEnvs());
        if (environmentVariablesData == null) {
            NodePathManager.$$$reportNull$$$0(4);
        }
        return environmentVariablesData;
    }

    @NotNull
    private static List<File> parsePathsFromNodePathEnvVariable(@Nullable String nodePath, @Nullable String workingDirPath) {
        if (nodePath == null || workingDirPath == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                NodePathManager.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (StringUtil.isEmptyOrSpaces((String)nodePath) || StringUtil.isEmptyOrSpaces((String)workingDirPath)) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                NodePathManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        Iterable res = Splitter.on((char)NODE_PATH_SEPARATOR).split((CharSequence)nodePath);
        File workingDir = new File(workingDirPath);
        if (!workingDir.isAbsolute() || !workingDir.isDirectory()) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                NodePathManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList dirs = Lists.newArrayList();
        for (String dirPath : res) {
            if (!StringUtil.isNotEmpty((String)dirPath)) continue;
            File dir = new File(dirPath);
            if (!dir.isAbsolute()) {
                dir = new File(workingDirPath, dirPath);
            }
            if (!dir.isDirectory()) continue;
            dirs.add(dir);
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            NodePathManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/codeInsight/NodePathManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraNodePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/codeInsight/NodePathManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prependPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePathsFromNodePathEnvVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prependPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

