/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.execution;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.nodejs.NodeProfilingRuntimeSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ReadV8LogRawAction;
import com.jetbrains.nodejs.run.profile.heap.TakeHeapSnapshotAction;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeProfilingRuntimeConfigurer {
    private final Logger LOG;
    @NotNull
    private final NodeJsRunConfiguration myConfiguration;
    @NotNull
    private final ExecutionEnvironment myEnvironment;
    @Nullable
    private NodeProfilingRuntimeSettings myRuntimeSettings;
    private final boolean myTakeHeapSnapshots;
    private final boolean myProfileCpu;
    private final ProfilingExecutionListener myListener;

    public NodeProfilingRuntimeConfigurer(@NotNull NodeJsRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (configuration == null) {
            NodeProfilingRuntimeConfigurer.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NodeProfilingRuntimeConfigurer.$$$reportNull$$$0(1);
        }
        this.LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.execution.NodeProfilingRuntimeConfigurer");
        this.myConfiguration = configuration;
        this.myEnvironment = environment;
        this.myTakeHeapSnapshots = NodeProfilingRuntimeConfigurer.proxyForHeapSnapshots(this.myConfiguration);
        this.myProfileCpu = NodeProfilingRuntimeConfigurer.configurationOkForProfiling(this.myConfiguration);
        this.myListener = new ProfilingExecutionListener(this.myConfiguration);
    }

    public static boolean configurationOkForProfiling(NodeJsRunConfiguration configuration) {
        return configuration.getNodeProfilingSettings().isProfile() && configuration.getNodeProfilingSettings().isOpenViewer();
    }

    public static boolean proxyForHeapSnapshots(NodeJsRunConfiguration configuration) {
        return configuration.getNodeProfilingSettings().isAllowRuntimeHeapSnapshot() && !StringUtil.isEmptyOrSpaces((String)configuration.getExePath());
    }

    public void setRuntimeSettings(@Nullable NodeProfilingRuntimeSettings runtimeSettings) {
        this.myRuntimeSettings = runtimeSettings;
    }

    public void onCommandLineCreation() {
        Project project = this.myEnvironment.getProject();
        if (this.myProfileCpu) {
            this.myListener.addAfter((Consumer<NodeJsRunConfiguration>)((Consumer)configuration -> {
                if (this.myRuntimeSettings != null) {
                    this.showProfilingResults();
                }
            }));
        }
        if (this.myProfileCpu || this.myTakeHeapSnapshots) {
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
            this.myListener.setConnection(connection);
            connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)this.myListener);
        }
    }

    public boolean isTakeHeapSnapshots() {
        return this.myTakeHeapSnapshots;
    }

    public TakeHeapSnapshotAction createSnapshotAction(int inspectorPort) {
        assert (this.myTakeHeapSnapshots);
        TakeHeapSnapshotAction action = new TakeHeapSnapshotAction(this.myConfiguration.getProject(), inspectorPort, this.myConfiguration.getName());
        this.myListener.addBefore((Consumer<NodeJsRunConfiguration>)((Consumer)configuration -> action.setDisposed()));
        return action;
    }

    private void showProfilingResults() {
        UsageTrigger.trigger((String)"node.js.v8.profiling.show.profiling.after.run");
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myConfiguration.getProject());
        alarm.addRequest(() -> {
            List<File> logFiles;
            Disposer.dispose((Disposable)alarm);
            try {
                logFiles = this.myRuntimeSettings.getLogFiles();
            }
            catch (IOException e) {
                NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("Error with V8 log files: " + e.getMessage(), MessageType.ERROR).notify(this.myConfiguration.getProject());
                return;
            }
            if (logFiles.isEmpty()) {
                NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("No V8 log files found.", MessageType.ERROR).notify(this.myConfiguration.getProject());
                return;
            }
            logFiles = this.copyFilesToLogFolder(logFiles);
            for (File file : logFiles) {
                UIUtil.invokeLaterIfNeeded(() -> ReadV8LogRawAction.openFile(this.myConfiguration.getProject(), file));
            }
        }, 500);
    }

    private List<File> copyFilesToLogFolder(List<File> logFiles) {
        File logFolder = this.myRuntimeSettings.getLogFolder();
        if (FileUtil.filesEqual((File)logFiles.get(0).getParentFile(), (File)logFolder)) {
            return logFiles;
        }
        ArrayList<File> result = new ArrayList<File>(logFiles.size());
        if (!logFolder.exists()) {
            FileUtilRt.createDirectory((File)logFolder);
        }
        for (File file : logFiles) {
            LogCopier logCopier = new LogCopier(this.myConfiguration.getProject(), file, logFolder);
            if (!logCopier.copy()) continue;
            result.add(logCopier.getToFile());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "environment";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProfilingExecutionListener
    implements ExecutionListener {
        private final List<Consumer<NodeJsRunConfiguration>> myAfterTerminationActions;
        private final List<Consumer<NodeJsRunConfiguration>> myBeforeTerminationActions;
        private final NodeJsRunConfiguration myConfiguration;
        private boolean myWasStartedOk;
        private MessageBusConnection myConnection;

        public ProfilingExecutionListener(NodeJsRunConfiguration configuration) {
            this.myConfiguration = configuration;
            this.myAfterTerminationActions = new ArrayList<Consumer<NodeJsRunConfiguration>>();
            this.myBeforeTerminationActions = new ArrayList<Consumer<NodeJsRunConfiguration>>();
            this.myWasStartedOk = false;
        }

        public void addBefore(Consumer<NodeJsRunConfiguration> consumer) {
            this.myBeforeTerminationActions.add(consumer);
        }

        public void addAfter(Consumer<NodeJsRunConfiguration> consumer) {
            this.myAfterTerminationActions.add(consumer);
        }

        public boolean isEmpty() {
            return this.myBeforeTerminationActions.isEmpty() && this.myAfterTerminationActions.isEmpty();
        }

        public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
            if (executorId == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(0);
            }
            if (env == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(1);
            }
            if (handler == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(2);
            }
            this.myWasStartedOk = true;
        }

        public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
            RunProfile runProfile;
            if (executorId == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(3);
            }
            if (env == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(4);
            }
            if (handler == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(5);
            }
            if (this.myConfiguration != (runProfile = env.getRunProfile())) {
                return;
            }
            if (!this.myWasStartedOk) {
                return;
            }
            if (!(runProfile instanceof NodeJsRunConfiguration)) {
                return;
            }
            for (Consumer<NodeJsRunConfiguration> action : this.myBeforeTerminationActions) {
                action.consume((Object)((NodeJsRunConfiguration)runProfile));
            }
        }

        public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
            RunProfile runProfile;
            if (executorId == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(6);
            }
            if (env == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(7);
            }
            if (handler == null) {
                ProfilingExecutionListener.$$$reportNull$$$0(8);
            }
            if (this.myConfiguration != (runProfile = env.getRunProfile())) {
                return;
            }
            this.myConnection.disconnect();
            if (!this.myWasStartedOk) {
                return;
            }
            if (!(runProfile instanceof NodeJsRunConfiguration)) {
                return;
            }
            for (Consumer<NodeJsRunConfiguration> action : this.myAfterTerminationActions) {
                action.consume((Object)((NodeJsRunConfiguration)runProfile));
            }
        }

        public void setConnection(MessageBusConnection connection) {
            this.myConnection = connection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorId";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$ProfilingExecutionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processStarted";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminating";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LogCopier {
        private static final long TIMEOUT = 300L;
        private static final int NUM_ATTEMPTS = 10;
        private final Project myProject;
        private final File myFile;
        private final File myLogFolder;
        private IOException myIoException;
        private File myToFile;

        public LogCopier(Project project, File file, File logFolder) {
            this.myProject = project;
            this.myFile = file;
            this.myLogFolder = logFolder;
        }

        public boolean copy() {
            String fileName = this.myFile.getName();
            this.myToFile = new File(this.myLogFolder, fileName);
            if (this.myToFile.exists()) {
                try {
                    this.myToFile = this.createNewToFile(fileName);
                }
                catch (IOException e) {
                    this.notifyException(e);
                    return false;
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.myIoException = null;
                try {
                    FileUtil.copy((File)this.myFile, (File)this.myToFile);
                    FileUtil.delete((File)this.myFile);
                    return true;
                }
                catch (IOException e) {
                    this.myIoException = e;
                    LogCopier.sleep();
                    continue;
                }
            }
            this.notifyException(this.myIoException);
            FileUtil.delete((File)this.myToFile);
            return false;
        }

        public File getToFile() {
            return this.myToFile;
        }

        private static void sleep() {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e1) {
                throw new RuntimeException(e1);
            }
        }

        private void notifyException(IOException e) {
            NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("Can not copy file to log folder: " + e.getMessage(), MessageType.ERROR).notify(this.myProject);
        }

        @NotNull
        private File createNewToFile(String fileName) throws IOException {
            String suffix;
            String prefix;
            int dotIdx = fileName.lastIndexOf(46);
            if (dotIdx == -1) {
                prefix = fileName;
                suffix = "";
            } else {
                prefix = fileName.substring(0, dotIdx);
                suffix = fileName.substring(dotIdx + 1);
            }
            File toFile = FileUtil.createTempFile((File)this.myLogFolder, (String)prefix, (String)suffix, (boolean)true, (boolean)false);
            FileUtil.delete((File)toFile);
            File file = toFile;
            if (file == null) {
                LogCopier.$$$reportNull$$$0(0);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/execution/NodeProfilingRuntimeConfigurer$LogCopier", "createNewToFile"));
        }
    }
}

