/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaConfigurationType;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.util.NodeJsCoffeeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunConfigurationProducer
extends JsTestRunConfigurationProducer<MochaRunConfiguration> {
    public MochaRunConfigurationProducer() {
        super((ConfigurationType)MochaConfigurationType.getInstance(), MochaUtil.PACKAGE_DESCRIPTOR.getPackageNames(), MochaRunConfigurationProducer.getStopPackageNames());
    }

    @NotNull
    private static List<String> getStopPackageNames() {
        IdeaPluginDescriptor karma = PluginManager.getPlugin((PluginId)PluginId.getId((String)"Karma"));
        if (karma != null && karma.isEnabled()) {
            ImmutableList immutableList = ImmutableList.of((Object)"karma");
            if (immutableList == null) {
                MochaRunConfigurationProducer.$$$reportNull$$$0(0);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    private boolean isActiveFor(@NotNull PsiElement element, @NotNull ConfigurationContext context) {
        VirtualFile file;
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return false;
        }
        if (this.isTestRunnerPackageAvailableFor(element.getProject(), file)) {
            return true;
        }
        if (context.getOriginalConfiguration((ConfigurationType)MochaConfigurationType.getInstance()) instanceof MochaRunConfiguration) {
            return true;
        }
        List<VirtualFile> roots = MochaRunConfigurationProducer.collectMochaTestRoots(element.getProject());
        if (roots.isEmpty()) {
            return false;
        }
        SmartHashSet dirs = new SmartHashSet();
        for (VirtualFile root : roots) {
            if (root.isDirectory()) {
                dirs.add(root);
                continue;
            }
            if (!root.equals(file)) continue;
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)file, (Set)dirs);
    }

    @NotNull
    private static List<VirtualFile> collectMochaTestRoots(@NotNull Project project) {
        if (project == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        List list = RunManager.getInstance((Project)project).getConfigurationsList((ConfigurationType)MochaConfigurationType.getInstance());
        SmartList roots = new SmartList();
        for (RunConfiguration configuration : list) {
            VirtualFile dir;
            if (!(configuration instanceof MochaRunConfiguration)) continue;
            MochaRunSettings settings = ((MochaRunConfiguration)configuration).getRunSettings();
            String path = null;
            if (settings.getTestKind() == MochaTestKind.DIRECTORY) {
                path = settings.getTestDirPath();
            } else if (settings.getTestKind() == MochaTestKind.TEST_FILE || settings.getTestKind() == MochaTestKind.SUITE || settings.getTestKind() == MochaTestKind.TEST) {
                path = settings.getTestFilePath();
            }
            if (StringUtil.isEmptyOrSpaces((String)path) || (dir = LocalFileSystem.getInstance().findFileByPath(path)) == null) continue;
            roots.add(dir);
        }
        SmartList smartList = roots;
        if (smartList == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile psiFile;
        String compilerMochaOption;
        PsiElement element;
        if (configuration == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (sourceElement == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((element = context.getPsiLocation()) == null) {
            return false;
        }
        if (!this.isActiveFor(element, context)) {
            return false;
        }
        TestElementInfo elementRunInfo = MochaRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        MochaRunSettings runSettings = elementRunInfo.getRunSettings();
        if (runSettings.getTestKind() == MochaTestKind.DIRECTORY) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)runSettings.getExtraMochaOptions()) && (compilerMochaOption = MochaRunConfigurationProducer.getLanguageCompilerMochaOption((psiFile = element.getContainingFile()) != null ? psiFile.getOriginalFile() : null)) != null) {
            runSettings = runSettings.builder().setExtraMochaOptions(compilerMochaOption).build();
        }
        configuration.setRunSettings(runSettings);
        sourceElement.set((Object)elementRunInfo.getEnclosingTestElement());
        configuration.setGeneratedName();
        return true;
    }

    @Nullable
    private static String getLanguageCompilerMochaOption(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        NodePackage pkg = MochaUtil.getMochaPackage(psiFile.getProject(), null);
        if (pkg.getName().equals("mocha-webpack")) {
            return null;
        }
        if (NodeJsCoffeeUtil.isCoffee((PsiElement)psiFile)) {
            return "--compilers coffee:coffee-script/register";
        }
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(psiFile.getFileType())) {
            return "--require ts-node/register";
        }
        return null;
    }

    @Nullable
    private static Pair<String, JsTestElementPath> createSuiteOrTestData(@NotNull PsiElement element) {
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        TextRange textRange = element.getTextRange();
        if (jsFile == null || textRange == null) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        JsTestElementPath path = jasmineStructure.findTestElementPath(textRange);
        if (path != null) {
            return Pair.create((Object)"bdd", (Object)path);
        }
        MochaTddFileStructure tddStructure = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        path = tddStructure.findTestElementPath(textRange);
        if (path != null) {
            if (tddStructure.hasMochaTypeScriptDeclarations()) {
                return Pair.create((Object)"mocha-typescript", (Object)path);
            }
            return Pair.create((Object)"tdd", (Object)path);
        }
        return null;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement element;
        if (configuration == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (context == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if ((element = context.getPsiLocation()) == null) {
            return false;
        }
        TestElementInfo elementRunInfo = MochaRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        MochaRunSettings thisRunSettings = elementRunInfo.getRunSettings();
        MochaRunSettings thatRunSettings = configuration.getRunSettings();
        if (thisRunSettings.getTestKind() != thatRunSettings.getTestKind()) {
            return false;
        }
        MochaTestKind testKind = thisRunSettings.getTestKind();
        if (testKind == MochaTestKind.DIRECTORY) {
            return thisRunSettings.getTestDirPath().equals(thatRunSettings.getTestDirPath());
        }
        if (testKind == MochaTestKind.PATTERN) {
            return thisRunSettings.getTestFilePattern().equals(thatRunSettings.getTestFilePattern());
        }
        if (testKind == MochaTestKind.TEST_FILE) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath());
        }
        if (testKind == MochaTestKind.SUITE) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath()) && thisRunSettings.getSuiteNames().equals(thatRunSettings.getSuiteNames());
        }
        if (testKind == MochaTestKind.TEST) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath()) && thisRunSettings.getTestNames().equals(thatRunSettings.getTestNames());
        }
        return false;
    }

    @Nullable
    private static TestElementInfo createTestElementRunInfo(@NotNull PsiElement element, @NotNull MochaRunSettings templateRunSettings) {
        JsTestElementPath testElementPath;
        String testName;
        VirtualFile virtualFile;
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (templateRunSettings == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        Pair<String, JsTestElementPath> pair = MochaRunConfigurationProducer.createSuiteOrTestData(element);
        if (StringUtil.isEmptyOrSpaces((String)templateRunSettings.getWorkingDir())) {
            String workingDir = MochaRunConfigurationProducer.guessWorkingDir(element.getProject(), virtualFile);
            templateRunSettings = templateRunSettings.builder().setWorkingDir(workingDir).build();
        }
        if (pair == null) {
            return MochaRunConfigurationProducer.createFileInfo(element, virtualFile, templateRunSettings);
        }
        MochaRunSettings.Builder builder = templateRunSettings.builder();
        builder.setTestFilePath(virtualFile.getPath());
        if (templateRunSettings.getUi().isEmpty()) {
            builder.setUi((String)pair.getFirst());
        }
        if ((testName = (testElementPath = (JsTestElementPath)pair.getSecond()).getTestName()) == null) {
            builder.setTestKind(MochaTestKind.SUITE);
            builder.setSuiteNames(testElementPath.getSuiteNames());
        } else {
            builder.setTestKind(MochaTestKind.TEST);
            ArrayList names = ContainerUtil.newArrayList((Iterable)testElementPath.getSuiteNames());
            names.add(testName);
            builder.setTestNames(names);
        }
        return new TestElementInfo(builder.build(), testElementPath.getTestElement());
    }

    @NotNull
    private static String guessWorkingDir(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile root;
        if (project == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (file == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if ((root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file)) == null) {
            root = project.getBaseDir();
        }
        String string = FileUtil.toSystemDependentName((String)root.getPath());
        if (string == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private static TestElementInfo createFileInfo(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull MochaRunSettings templateRunSettings) {
        JSTestFileType testFileType;
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(17);
        }
        if (virtualFile == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(18);
        }
        if (templateRunSettings == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(19);
        }
        if (virtualFile.isDirectory()) {
            MochaRunSettings.Builder builder = templateRunSettings.builder();
            builder.setTestKind(MochaTestKind.DIRECTORY);
            builder.setTestDirPath(virtualFile.getPath());
            return new TestElementInfo(builder.build(), element);
        }
        JSFile psiFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        JSTestFileType jSTestFileType = testFileType = psiFile == null ? null : psiFile.getTestFileType();
        if (psiFile != null && testFileType != null) {
            MochaRunSettings.Builder builder = templateRunSettings.builder();
            builder.setTestKind(MochaTestKind.TEST_FILE);
            builder.setTestFilePath(virtualFile.getPath());
            if (templateRunSettings.getUi().isEmpty()) {
                String ui = MochaUtil.findUi(psiFile);
                builder.setUi((String)ObjectUtils.notNull((Object)ui, (Object)"bdd"));
            }
            return new TestElementInfo(builder.build(), (PsiElement)psiFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStopPackageNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMochaTestRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "guessWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isActiveFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectMochaTestRoots";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromCompatibleContext";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSuiteOrTestData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromCompatibleContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTestElementRunInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "guessWorkingDir";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TestElementInfo {
        private final MochaRunSettings myRunSettings;
        private final PsiElement myEnclosingTestElement;

        public TestElementInfo(@NotNull MochaRunSettings runSettings, @NotNull PsiElement enclosingTestElement) {
            if (runSettings == null) {
                TestElementInfo.$$$reportNull$$$0(0);
            }
            if (enclosingTestElement == null) {
                TestElementInfo.$$$reportNull$$$0(1);
            }
            this.myRunSettings = runSettings;
            this.myEnclosingTestElement = enclosingTestElement;
        }

        @NotNull
        public MochaRunSettings getRunSettings() {
            MochaRunSettings mochaRunSettings = this.myRunSettings;
            if (mochaRunSettings == null) {
                TestElementInfo.$$$reportNull$$$0(2);
            }
            return mochaRunSettings;
        }

        @NotNull
        public PsiElement getEnclosingTestElement() {
            PsiElement psiElement = this.myEnclosingTestElement;
            if (psiElement == null) {
                TestElementInfo.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enclosingTestElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingTestElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

