/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.coverage.MochaCoverageRunState;
import com.jetbrains.nodejs.mocha.execution.MochaConsoleProperties;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.mocha.execution.MochaTestLocationProvider;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final Project myProject;
    private final MochaRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnv;
    private final NodePackage myMochaPackage;
    private final MochaRunSettings myRunSettings;
    private final MochaCoverageRunState myCoverageRunState;
    private List<List<String>> myRerunActionFailedTests;

    public MochaRunProfileState(@NotNull Project project, @NotNull MochaRunConfiguration runConfiguration, @NotNull ExecutionEnvironment env, @NotNull NodePackage mochaPackage, @NotNull MochaRunSettings runSettings) {
        if (project == null) {
            MochaRunProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            MochaRunProfileState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            MochaRunProfileState.$$$reportNull$$$0(2);
        }
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(3);
        }
        if (runSettings == null) {
            MochaRunProfileState.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myEnv = env;
        this.myMochaPackage = mochaPackage;
        this.myRunSettings = runSettings;
        this.myCoverageRunState = MochaCoverageRunState.create(env, this.myMochaPackage, runSettings);
    }

    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        MochaConsoleProperties consoleProperties = new MochaConsoleProperties(this.myRunConfiguration, this.myEnv.getExecutor(), new MochaTestLocationProvider(this.myRunSettings.getUi()), (ProcessHandler)processHandler);
        ConsoleView consoleView = this.createSMTRunnerConsoleView(commandLine.getWorkDirectory(), consoleProperties);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{consoleProperties.createRerunFailedTestsAction(consoleView)});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            MochaRunProfileState.$$$reportNull$$$0(5);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ConsoleView createSMTRunnerConsoleView(@Nullable File workingDirectory, @NotNull SMTRunnerConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            MochaRunProfileState.$$$reportNull$$$0(6);
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)consoleProperties.getTestFrameworkName(), (TestConsoleProperties)consoleProperties);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new UrlFilter());
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            MochaRunProfileState.$$$reportNull$$$0(7);
        }
        return baseTestsOutputConsoleView;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsInterpreter interpreter, int debugPort) throws ExecutionException {
        String grepPattern;
        if (interpreter == null) {
            MochaRunProfileState.$$$reportNull$$$0(8);
        }
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine((Boolean)(SystemInfo.isWindows ? Boolean.valueOf(false) : null));
        commandLine.setCharset(StandardCharsets.UTF_8);
        if (StringUtils.isNotBlank((String)this.myRunSettings.getWorkingDir())) {
            commandLine.withWorkDirectory(this.myRunSettings.getWorkingDir());
        }
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)commandLine);
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, (List)nodeOptionList, (int)debugPort, (boolean)true, (NodeJsInterpreter)interpreter, (boolean)true);
        boolean separateMochaArgs = false;
        if (this.myCoverageRunState != null) {
            separateMochaArgs = this.myCoverageRunState.configure(commandLine, interpreter);
        }
        commandLine.addParameter(MochaRunProfileState.getMochaMainJsFile(interpreter, this.myMochaPackage).getAbsolutePath());
        if (separateMochaArgs) {
            commandLine.addParameter("--");
        }
        List extraMochaOptionList = ParametersListUtil.parse((String)this.myRunSettings.getExtraMochaOptions().trim());
        commandLine.addParameters(extraMochaOptionList);
        if (debugPort != -1) {
            commandLine.addParameter("--timeout");
            commandLine.addParameter("0");
        }
        commandLine.addParameter("--ui");
        commandLine.addParameter(this.myRunSettings.getUi());
        commandLine.addParameter("--reporter");
        commandLine.addParameter(MochaRunProfileState.getMochaReporterFile().getAbsolutePath());
        MochaTestKind testKind = this.myRunSettings.getTestKind();
        if (MochaTestKind.DIRECTORY == testKind) {
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestDirPath()));
            if (this.myRunSettings.isRecursive()) {
                commandLine.addParameter("--recursive");
            }
        } else if (MochaTestKind.PATTERN == testKind) {
            String pattern = this.myRunSettings.getTestFilePattern();
            if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
                commandLine.addParameters(ParametersList.parse((String)NodeInterpreterUtil.toRemoteName((String)pattern, (NodeJsInterpreter)interpreter)));
            }
        } else if (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getTestFilePath()));
        }
        if ((grepPattern = this.getGrepPattern(testKind)) != null) {
            commandLine.addParameter("--grep");
            commandLine.addParameter(grepPattern);
        }
        NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            MochaRunProfileState.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @Nullable
    private String getGrepPattern(@NotNull MochaTestKind testKind) {
        if (testKind == null) {
            MochaRunProfileState.$$$reportNull$$$0(10);
        }
        if (this.myRerunActionFailedTests != null) {
            return MochaRunProfileState.getTestMatchingPattern(this.myRerunActionFailedTests);
        }
        if (MochaTestKind.SUITE == testKind) {
            return MochaUtil.escapeJavaScriptPattern(StringUtil.join(this.myRunSettings.getSuiteNames(), (String)" ") + " ");
        }
        if (MochaTestKind.TEST == testKind) {
            return MochaRunProfileState.getTestMatchingPattern(Collections.singletonList(this.myRunSettings.getTestNames()));
        }
        return null;
    }

    @NotNull
    public MochaRunSettings getRunSettings() {
        MochaRunSettings mochaRunSettings = this.myRunSettings;
        if (mochaRunSettings == null) {
            MochaRunProfileState.$$$reportNull$$$0(11);
        }
        return mochaRunSettings;
    }

    @NotNull
    private static String getTestMatchingPattern(@NotNull List<List<String>> testNames) {
        List patterns;
        if (testNames == null) {
            MochaRunProfileState.$$$reportNull$$$0(12);
        }
        if ((patterns = ContainerUtil.map(testNames, testFqn -> {
            List escaped = ContainerUtil.mapNotNull((Collection)testFqn, s -> MochaUtil.escapeJavaScriptPattern(s));
            return StringUtil.join((Collection)escaped, (String)" ");
        })).isEmpty()) {
            if ("$^" == null) {
                MochaRunProfileState.$$$reportNull$$$0(13);
            }
            return "$^";
        }
        String result = patterns.size() == 1 ? (String)patterns.get(0) : "(" + StringUtil.join((Collection)patterns, (String)")|(") + ")";
        String string = "^" + result + "$";
        if (string == null) {
            MochaRunProfileState.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public MochaCoverageRunState getCoverageRunState() {
        return this.myCoverageRunState;
    }

    public void setFailedTests(@NotNull List<List<String>> rerunActionFailedTests) {
        if (rerunActionFailedTests == null) {
            MochaRunProfileState.$$$reportNull$$$0(15);
        }
        this.myRerunActionFailedTests = rerunActionFailedTests;
    }

    @NotNull
    public static File getMochaMainJsFile(@NotNull NodeJsInterpreter interpreter, @NotNull NodePackage mochaPackage) throws ExecutionException {
        String packageName;
        if (interpreter == null) {
            MochaRunProfileState.$$$reportNull$$$0(16);
        }
        if (mochaPackage == null) {
            MochaRunProfileState.$$$reportNull$$$0(17);
        }
        File mainJsFile = "electron-mocha".equals(packageName = mochaPackage.getName()) ? (interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron() ? new File(mochaPackage.getSystemDependentPath(), "index.js") : new File(mochaPackage.getSystemDependentPath(), "bin" + File.separator + "electron-mocha")) : new File(mochaPackage.getSystemDependentPath(), "bin" + File.separator + "_mocha");
        if (!mainJsFile.isFile()) {
            throw new ExecutionException("Not found " + mainJsFile.getAbsolutePath());
        }
        File file = mainJsFile;
        if (file == null) {
            MochaRunProfileState.$$$reportNull$$$0(18);
        }
        return file;
    }

    @NotNull
    private static File getMochaReporterFile() throws ExecutionException {
        File file;
        try {
            file = NodeJsCodeLocator.getFileRelativeToJsDir("mocha-intellij/lib/mochaIntellijReporter.js");
        }
        catch (IOException e) {
            throw new ExecutionException("IntelliJ Mocha reporter not found", (Throwable)e);
        }
        if (file == null) {
            MochaRunProfileState.$$$reportNull$$$0(19);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaPackage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testKind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunActionFailedTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunProfileState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSMTRunnerConsoleView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMatchingPattern";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaMainJsFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMochaReporterFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSMTRunnerConsoleView";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGrepPattern";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestMatchingPattern";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTests";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMochaMainJsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

