/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitRunConfiguration;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeunitExecutionUtils {
    private NodeunitExecutionUtils() {
    }

    public static ConsoleView createConsole(@NotNull ProcessHandler processHandler, @NotNull ExecutionEnvironment env, @NotNull SMTestLocator locator) {
        if (processHandler == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(0);
        }
        if (env == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(1);
        }
        if (locator == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(2);
        }
        NodeunitRunConfiguration runConfiguration = (NodeunitRunConfiguration)env.getRunProfile();
        NodeunitConsoleProperties testConsoleProperties = new NodeunitConsoleProperties(runConfiguration, env.getExecutor(), locator);
        BaseTestsOutputConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)"Nodeunit", (TestConsoleProperties)testConsoleProperties);
        testsOutputConsoleView.attachToProcess(processHandler);
        Disposer.register((Disposable)env.getProject(), (Disposable)testsOutputConsoleView);
        return testsOutputConsoleView;
    }

    public static void checkConfiguration(@NotNull Project project, @NotNull NodeunitSettings settings) throws RuntimeConfigurationException {
        if (project == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(4);
        }
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(project);
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        String nodeunitModuleDirPath = settings.getNodeunitPackageDir();
        if (nodeunitModuleDirPath.isEmpty() || ".".equals(nodeunitModuleDirPath)) {
            throw new RuntimeConfigurationError("Please specify nodeunit module directory correctly.");
        }
        File nodeunitModuleDir = new File(nodeunitModuleDirPath);
        if (!nodeunitModuleDir.isDirectory()) {
            throw new RuntimeConfigurationError("Please specify nodeunit module directory correctly.");
        }
        String workingDirectoryStr = settings.getWorkingDirectory();
        if (workingDirectoryStr.isEmpty() || ".".equals(workingDirectoryStr)) {
            throw new RuntimeConfigurationError("Please specify working directory correctly.");
        }
        File workingDirectory = new File(workingDirectoryStr);
        if (!workingDirectory.isDirectory()) {
            throw new RuntimeConfigurationError("Please specify working directory correctly.");
        }
        if (settings.getTestType() == NodeunitTestType.DIRECTORY) {
            if (settings.getDirectory().isEmpty()) {
                throw new RuntimeConfigurationError("Please specify nonempty test directory.");
            }
            File testDirectory = new File(workingDirectory, settings.getDirectory());
            if (!testDirectory.isDirectory()) {
                throw new RuntimeConfigurationError("Please specify test directory correctly.");
            }
        } else {
            File jsTestFile = new File(workingDirectory, settings.getJsFile());
            if (!jsTestFile.isFile()) {
                throw new RuntimeConfigurationError("Please specify JavaScript test file correctly.");
            }
        }
    }

    @NotNull
    public static List<String> detectAllNodeunitPackages(@NotNull Project project, @NotNull NodeJsInterpreterRef interpreterRef2) {
        if (project == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(5);
        }
        if (interpreterRef2 == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(6);
        }
        ArrayList paths = ContainerUtil.newArrayList();
        NodeJsInterpreter interpreter = interpreterRef2.resolve(project);
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter);
        VirtualFile requester = project.getBaseDir();
        ArrayList modules = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"nodeunit", (VirtualFile)requester, (boolean)true, (NodeJsInterpreter)localInterpreter);
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            paths.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            NodeunitExecutionUtils.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitExecutionUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllNodeunitPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "detectAllNodeunitPackages";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeunitConsoleProperties
    extends SMTRunnerConsoleProperties {
        private final SMTestLocator myLocator;

        public NodeunitConsoleProperties(NodeunitRunConfiguration configuration, Executor executor, SMTestLocator locator) {
            super((RunConfiguration)configuration, "Nodeunit", executor);
            this.myLocator = locator;
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }
    }
}

