/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeLocalFileTransfer;
import com.intellij.javascript.nodejs.NodeProfilingRuntimeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import com.jetbrains.nodejs.execution.NodeCommandLineStateKt;
import com.jetbrains.nodejs.execution.NodeProfilingRuntimeConfigurer;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtension;
import com.jetbrains.nodejs.run.NodeJSRuntimeSession;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingPanel;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSProfilingRunConfigurationExtension
extends NodeJSRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.NodeJSProfilingRunConfigurationExtension");

    @Override
    protected NodeJSRuntimeSession createRemoteRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodeFileTransfer fileTransfer) throws ExecutionException {
        NodeProfilingSettings settings;
        if (runConfiguration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        if (fileTransfer == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (!(settings = runConfiguration.getNodeProfilingSettings()).isProfile() && !settings.isAllowRuntimeHeapSnapshot()) {
            return null;
        }
        NodeProfilingRuntimeConfigurer configurer = new NodeProfilingRuntimeConfigurer(runConfiguration, environment);
        return new MyLocalRuntimeSessionHelper(settings, runConfiguration, configurer, fileTransfer);
    }

    @Override
    @Nullable
    protected NodeJSRuntimeSession createLocalRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        NodeProfilingSettings settings;
        if (runConfiguration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (!(settings = runConfiguration.getNodeProfilingSettings()).isProfile() && !settings.isAllowRuntimeHeapSnapshot()) {
            return null;
        }
        NodeProfilingRuntimeConfigurer configurer = new NodeProfilingRuntimeConfigurer(runConfiguration, environment);
        return new MyLocalRuntimeSessionHelper(settings, runConfiguration, configurer, (NodeFileTransfer)NodeLocalFileTransfer.INSTANCE);
    }

    protected void writeExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (element == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        runConfiguration.getNodeProfilingSettings().writeExternal(element);
    }

    protected void readExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (element == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        NodeProfilingSettings profilingSettings = NodeProfilingSettings.readExternal(element);
        runConfiguration.setNodeProfilingSettings(profilingSettings);
    }

    @Override
    @Nullable
    public String getEditorTitle() {
        return "V8 Profiling";
    }

    protected boolean isApplicableFor(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        return true;
    }

    protected boolean isEnabledFor(@NotNull NodeJsRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        return true;
    }

    @Override
    @Nullable
    protected <P extends NodeJsRunConfiguration> SettingsEditor<P> createEditor(@NotNull P configuration, Consumer<NodeJsInterpreterChangeListener> listenerRegistrar) {
        if (configuration == null) {
            NodeJSProfilingRunConfigurationExtension.$$$reportNull$$$0(11);
        }
        return new NodeProfilingPanel(configuration.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTransfer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRemoteRuntimeSession";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createLocalRuntimeSession";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLocalRuntimeSessionHelper
    implements NodeJSRuntimeSession {
        private final NodeProfilingSettings mySettings;
        private final NodeJsRunConfiguration myRunConfiguration;
        private final NodeProfilingRuntimeConfigurer myConfigurer;
        private final NodeFileTransfer myFileTransfer;
        private final NodeProfilingRuntimeSettings myRuntimeSettings;
        private int myInspectorPort = -1;

        public MyLocalRuntimeSessionHelper(NodeProfilingSettings settings, NodeJsRunConfiguration runConfiguration, NodeProfilingRuntimeConfigurer configurer, NodeFileTransfer fileTransfer) throws ExecutionException {
            this.mySettings = settings;
            this.myRunConfiguration = runConfiguration;
            this.myConfigurer = configurer;
            this.myFileTransfer = fileTransfer;
            try {
                String workingDirectory = this.myRunConfiguration.getWorkingDirectory();
                assert (workingDirectory != null);
                this.myRuntimeSettings = this.mySettings.createRuntimeSettings(this.myRunConfiguration.getProject(), this.myFileTransfer.getMappingFor(workingDirectory), this.myFileTransfer);
                this.myConfigurer.setRuntimeSettings(this.myRuntimeSettings);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        @Override
        @NotNull
        public List<String> getNodeParameters(int debugPort) throws IOException {
            String runtimeParameters;
            List parameters = ContainerUtil.newSmartList();
            NodeJsInterpreter interpreter = this.myRunConfiguration.getInterpreter();
            if (debugPort == -1) {
                this.myInspectorPort = NetUtils.findAvailableSocketPort();
                parameters.add("--inspect=" + NodeCommandLineStateKt.createDebugPortString(this.myInspectorPort, interpreter));
            }
            if (this.myRuntimeSettings != null && !StringUtil.isEmptyOrSpaces((String)(runtimeParameters = this.myRuntimeSettings.getNodeParameters()))) {
                parameters.addAll(ParametersListUtil.parse((String)runtimeParameters));
            }
            List list = parameters.isEmpty() ? Collections.emptyList() : parameters;
            if (list == null) {
                MyLocalRuntimeSessionHelper.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        public List<AnAction> getRunDebugActions() {
            this.myConfigurer.onCommandLineCreation();
            List<Object> list = this.myConfigurer.isTakeHeapSnapshots() ? Collections.singletonList(this.myConfigurer.createSnapshotAction(this.myInspectorPort)) : Collections.emptyList();
            if (list == null) {
                MyLocalRuntimeSessionHelper.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        public List<Integer> getUsedPorts() {
            if (this.myInspectorPort != -1) {
                List<Integer> list = Collections.singletonList(this.myInspectorPort);
                if (list == null) {
                    MyLocalRuntimeSessionHelper.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<Integer> list = Collections.emptyList();
            if (list == null) {
                MyLocalRuntimeSessionHelper.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$MyLocalRuntimeSessionHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeParameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunDebugActions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUsedPorts";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

