/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.nodejs.execution.NodeCommandLineState;
import com.jetbrains.nodejs.execution.NodeCommandLineStateKt;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtensionsManager;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationRefactoringHandler;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationState;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import com.jetbrains.nodejs.run.NodeRunConfigurationEditor;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.regex.Matcher;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRunConfiguration
extends LocatableConfigurationBase
implements NodeJSDebuggableConfiguration,
RefactoringListenerProvider,
DebuggableProcessRunConfiguration,
PersistentStateComponent<Element>,
JSRunProfileWithCompileBeforeLaunchOption {
    @NotNull
    private StartBrowserSettings myStartBrowserSettings = new StartBrowserSettings();
    @NotNull
    private NodeProfilingSettings myNodeProfilingSettings;
    @NotNull
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;

    protected NodeJsRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.myNodeProfilingSettings = new NodeProfilingSettings();
    }

    protected Class<? extends LocatableRunConfigurationOptions> getOptionsClass() {
        return NodeJsRunConfigurationState.class;
    }

    protected NodeJsRunConfigurationState getOptions() {
        return (NodeJsRunConfigurationState)super.getOptions();
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.getOptions().getWorkingDir();
    }

    public void setWorkingDirectory(@Nullable String workingDir) {
        this.getOptions().setWorkingDir(workingDir);
    }

    @NotNull
    public StartBrowserSettings getStartBrowserSettings() {
        StartBrowserSettings startBrowserSettings = this.myStartBrowserSettings;
        if (startBrowserSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(0);
        }
        return startBrowserSettings;
    }

    public void setStartBrowserSettings(@NotNull StartBrowserSettings settings) {
        if (settings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(1);
        }
        this.myStartBrowserSettings = settings;
    }

    @NotNull
    public NodeProfilingSettings getNodeProfilingSettings() {
        NodeProfilingSettings nodeProfilingSettings = this.myNodeProfilingSettings;
        if (nodeProfilingSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(2);
        }
        return nodeProfilingSettings;
    }

    public void setNodeProfilingSettings(@NotNull NodeProfilingSettings nodeProfilingSettings) {
        if (nodeProfilingSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(3);
        }
        this.myNodeProfilingSettings = nodeProfilingSettings;
    }

    public RunConfiguration clone() {
        NodeJsRunConfiguration clone = (NodeJsRunConfiguration)super.clone();
        clone.myNodeProfilingSettings = new NodeProfilingSettings(this.myNodeProfilingSettings);
        return clone;
    }

    @NotNull
    public SettingsEditor<NodeJsRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        NodeRunConfigurationEditor settings = new NodeRunConfigurationEditor(this.getProject());
        group.addEditor("Configuration", (SettingsEditor)settings);
        NodeJSRunConfigurationExtensionsManager.getInstance().appendEditorsNode(this, (SettingsEditorGroup<NodeJsRunConfiguration>)group, settings);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(4);
        }
        return settingsEditorGroup;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) {
        if (executor == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(5);
        }
        if (executionEnvironment == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(6);
        }
        return this.createState(executionEnvironment);
    }

    @NotNull
    private RunProfileState createState(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(7);
        }
        NodeCommandLineState nodeCommandLineState = new NodeCommandLineState(environment, this);
        if (nodeCommandLineState == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(8);
        }
        return nodeCommandLineState;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Path workingDir;
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            throw new RuntimeConfigurationException("Please specify Node.js interpreter");
        }
        String interpreterError = interpreter.validate(this.getProject());
        if (interpreterError != null) {
            throw new RuntimeConfigurationException(interpreterError);
        }
        NodeJSRunConfigurationExtensionsManager.getInstance().checkConfiguration(this, this.getOptions().getInterpreterRef().getReferenceName());
        String workingDirPath = this.getOptions().getWorkingDir();
        Path path = workingDir = workingDirPath == null ? null : Paths.get(workingDirPath, new String[0]);
        if (!(workingDir == null || workingDir.isAbsolute() && Files.isDirectory(workingDir, new LinkOption[0]))) {
            throw new RuntimeConfigurationError("Please specify working directory correctly");
        }
        NodeJsRunConfiguration.validatePath(this.getProject(), workingDir, this.getOptions().getPathToJsFile());
        if (this.myStartBrowserSettings.isSelected() && this.myStartBrowserSettings.getUrl() == null) {
            throw new RuntimeConfigurationError("The URL is not specified in Browser / Live Edit");
        }
        this.myNodeProfilingSettings.check(interpreter, this.getInputPath());
    }

    private static void validatePath(@NotNull Project project, @Nullable Path workingDir, @Nullable String jsFilePath) throws RuntimeConfigurationError {
        Path dir;
        BasicFileAttributes attributes;
        if (project == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(9);
        }
        if (jsFilePath == null) {
            return;
        }
        if (ScriptFileUtil.isMemoryScriptPath((String)jsFilePath)) {
            if (ScriptFileUtil.findScriptFileByPath((String)jsFilePath) == null) {
                throw new RuntimeConfigurationError("Cannot find script file");
            }
            return;
        }
        Path jsFile = NodeJsRunConfiguration.getPath(jsFilePath);
        if (jsFile != null && jsFile.isAbsolute() && (attributes = PathKt.basicAttributesIfExists((Path)jsFile)) != null && (attributes.isRegularFile() || attributes.isSymbolicLink())) {
            return;
        }
        Path path = dir = workingDir != null ? workingDir : NodeJsRunConfiguration.getPath(project.getBasePath());
        if (dir != null) {
            try {
                jsFile = dir.resolve(jsFilePath);
                BasicFileAttributes attributes2 = PathKt.basicAttributesIfExists((Path)jsFile);
                if (attributes2 != null && (attributes2.isRegularFile() || attributes2.isSymbolicLink())) {
                    return;
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        throw new RuntimeConfigurationError("Please specify path to JavaScript file correctly");
    }

    @Nullable
    private static Path getPath(@Nullable String filePath) {
        if (filePath == null) {
            return null;
        }
        try {
            return Paths.get(filePath, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.getOptions().getInterpreterRef().resolve(this.getProject());
    }

    public String suggestedName() {
        return PathUtilRt.getFileName((String)this.getOptions().getPathToJsFile());
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(10);
        }
        super.readExternal(element);
        this.myEnvData = EnvironmentVariablesData.readExternal((Element)element);
        NodeJSRunConfigurationExtensionsManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    public void addCoffeeScriptNodeOptionIfNeeded() {
        String pathToJsFile = this.getOptions().getPathToJsFile();
        if (pathToJsFile == null || !pathToJsFile.endsWith(".coffee")) {
            return;
        }
        String nodeOption = "--require coffee-script/register";
        String nodeParameters = this.getOptions().getNodeParameters();
        if (nodeParameters == null) {
            this.getOptions().setNodeParameters(nodeOption);
        } else if (!nodeParameters.contains(nodeOption)) {
            if (!nodeParameters.endsWith(" ")) {
                nodeParameters = nodeParameters + " ";
            }
            nodeParameters = nodeParameters + nodeOption;
            this.getOptions().setNodeParameters(nodeParameters);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        super.writeExternal(element);
        if (!EnvironmentVariablesData.DEFAULT.equals((Object)this.myEnvData)) {
            this.myEnvData.writeExternal(element);
        }
        NodeJSRunConfigurationExtensionsManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        return element;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return NodeJsRunConfigurationRefactoringHandler.createRefactoringElementListener(this, element);
    }

    @Nullable
    public String getProgramParameters() {
        return this.getOptions().getNodeParameters();
    }

    public void setProgramParameters(@Nullable String value) {
        this.getOptions().setNodeParameters(value);
    }

    @Nullable
    public String getApplicationParameters() {
        return this.getOptions().getApplicationParameters();
    }

    public void setApplicationParameters(@Nullable String applicationParameters) {
        this.getOptions().setApplicationParameters(applicationParameters);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map map = this.myEnvData.getEnvs();
        if (map == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(11);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(12);
        }
        this.myEnvData = EnvironmentVariablesData.create(envs, (boolean)this.myEnvData.isPassParentEnvs());
    }

    public boolean isPassParentEnvs() {
        return this.myEnvData.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvData = EnvironmentVariablesData.create((Map)this.myEnvData.getEnvs(), (boolean)passParentEnvs);
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(13);
        }
        return environmentVariablesData;
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        if (envData == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(14);
        }
        this.myEnvData = envData;
    }

    public void initializeFields() {
        VirtualFile dir;
        String workingDir = this.getOptions().getWorkingDir();
        if (StringUtil.isEmptyOrSpaces((String)workingDir) && (dir = this.getProject().getBaseDir()) != null) {
            this.getOptions().setWorkingDir(dir.getPath());
        }
    }

    @Nullable
    public static NodeJsRunConfiguration getDefaultRunConfiguration(@NotNull Project project) {
        if (project == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(15);
        }
        ConfigurationFactory configurationFactory = NodeJsRunConfigurationType.getInstance().getFactory();
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.getConfigurationTemplate(configurationFactory);
        return (NodeJsRunConfiguration)((Object)ObjectUtils.tryCast((Object)settings.getConfiguration(), NodeJsRunConfiguration.class));
    }

    @Nullable
    public String getExePath() {
        return PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)this.getRawExePath()));
    }

    public String getRawExePath() {
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            return "";
        }
        return interpreter.getOldPath();
    }

    @Nullable
    public String getInputPath() {
        return this.getOptions().getPathToJsFile();
    }

    public void setInputPath(@Nullable String value) {
        if ((value = StringUtil.nullize((String)value)) == null) {
            this.getOptions().setPathToJsFile(null);
        } else {
            this.getOptions().setPathToJsFile(FileUtilRt.toSystemIndependentName((String)value));
        }
    }

    @Nullable
    public String getEffectiveExePath() throws ExecutionException {
        NodeJSRemoteInterpreterManager manager;
        NodeJsInterpreter interpreter = this.getInterpreter();
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (remoteInterpreter != null && (manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt((String)"Node.js Run Configuration")) != null) {
            try {
                RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(this.getProject(), remoteInterpreter.getRemoteUrl());
                CredentialsType type = data.getRemoteConnectionType();
                boolean isExtended = type instanceof CredentialsTypeEx;
                if (!isExtended || ((CredentialsTypeEx)type).useRemoteCredentials()) {
                    return StringUtil.nullize((String)data.getRemoteSdkCredentials(this.getProject(), true).getInterpreterPath());
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        return StringUtil.nullize((String)this.getRawExePath());
    }

    @Nullable
    public String getEffectiveWorkingDirectory() {
        return PathUtil.toSystemDependentName((String)StringUtil.nullize((String)this.getWorkingDirectory()));
    }

    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(16);
        }
        String string = exePath;
        if (string == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (socketAddress == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(18);
        }
        if (session == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(19);
        }
        if (environment == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(20);
        }
        JavaScriptDebugProcess javaScriptDebugProcess = NodeDebugProgramRunnerKt.createDebugProcess((NodeJSDebuggableConfiguration)this, (InetSocketAddress)socketAddress, (XDebugSession)session, (ExecutionResult)executionResult);
        if (javaScriptDebugProcess == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(21);
        }
        return javaScriptDebugProcess;
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(RunProfileState state) throws ExecutionException {
        String host;
        Matcher matcher;
        int debugPort = -1;
        String parameters = this.getProgramParameters();
        if (parameters != null && (matcher = NodeCommandLineStateKt.getDEBUG_PORT_ARG().toPattern().matcher(parameters)).find()) {
            try {
                debugPort = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                Logger.getInstance(NodeJsRunConfiguration.class).warn("Invalid debug port specified: " + parameters);
            }
        }
        if (debugPort == -1) {
            try {
                debugPort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException("Cannot find available port", (Throwable)e);
            }
        }
        if (state instanceof NodeCommandLineState && (host = ((NodeCommandLineState)state).getDebugHost()) != null) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(host, debugPort);
            if (inetSocketAddress == null) {
                NodeJsRunConfiguration.$$$reportNull$$$0(22);
            }
            return inetSocketAddress;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), debugPort);
        if (inetSocketAddress == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(23);
        }
        return inetSocketAddress;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(24);
        }
        if (profile == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(25);
        }
        return this.getOptions().getPathToJsFile() == null || !this.getOptions().getPathToJsFile().endsWith(".coffee");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/NodeJsRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeProfilingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socketAddress";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartBrowserSettings";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/NodeJsRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProfilingSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "correctExePath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDebugAddress";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setStartBrowserSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNodeProfilingSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setEnvData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfiguration";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "correctExePath";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

