/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.webcore.ui.PathShortener;
import com.jetbrains.nodejs.NodeModuleManager;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRunConfigurationEditor
extends SettingsEditor<NodeJsRunConfiguration> {
    private JPanel panel;
    private TextFieldWithBrowseButton pathToJSFile;
    private TextFieldWithBrowseButton workingDir;
    private RawCommandLineEditor applicationParametersTextField;
    private RawCommandLineEditor nodeParameters;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private JComponent pathToNode;
    private JPanel myChildContainer;
    private NodeJsInterpreterField myInterpreterField;
    private final Project myProject;
    private final List<NodeJsInterpreterChangeListener> myListeners;
    private final FormBuilder myChildBuilder;
    private final ArrayList<SettingsEditor<NodeJsRunConfiguration>> myEmbeddedEditors;

    NodeRunConfigurationEditor(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myListeners = new ArrayList<NodeJsInterpreterChangeListener>();
        this.myChildBuilder = new FormBuilder();
        this.myEmbeddedEditors = new ArrayList();
    }

    public void addChildComponent(@NotNull SettingsEditor<NodeJsRunConfiguration> embeddedEditor) {
        if (embeddedEditor == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myEmbeddedEditors.add(embeddedEditor);
        this.myChildBuilder.addComponent(embeddedEditor.getComponent());
        this.myChildContainer.removeAll();
        this.myChildContainer.add((Component)this.myChildBuilder.getPanel(), "Center");
    }

    protected void resetEditorFrom(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.myInterpreterField.setInterpreterRef(configuration.getOptions().getInterpreterRef());
        this.workingDir.getTextField().setText(PathUtil.toSystemDependentName((String)configuration.getWorkingDirectory()));
        this.pathToJSFile.getTextField().setText(PathUtil.toSystemDependentName((String)configuration.getOptions().getPathToJsFile()));
        this.applicationParametersTextField.setText(configuration.getOptions().getApplicationParameters());
        this.nodeParameters.setText(configuration.getOptions().getNodeParameters());
        this.myEnvVariablesComponent.setEnvData(configuration.getEnvData());
        for (SettingsEditor<NodeJsRunConfiguration> editor : this.myEmbeddedEditors) {
            editor.resetFrom((Object)configuration);
        }
    }

    protected void applyEditorTo(@NotNull NodeJsRunConfiguration nodeJSRunConfiguration) throws ConfigurationException {
        if (nodeJSRunConfiguration == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        NodeJsRunConfigurationState state = nodeJSRunConfiguration.getOptions();
        state.setInterpreterRef(this.myInterpreterField.getInterpreterRef());
        state.setPathToJsFile(PathUtil.toSystemIndependentName((String)PathShortener.getTextWithExpandedUserHome((JTextField)this.pathToJSFile.getTextField())));
        state.setWorkingDir(PathUtil.toSystemIndependentName((String)PathShortener.getAbsolutePath((JTextField)this.workingDir.getTextField())));
        nodeJSRunConfiguration.setApplicationParameters(this.applicationParametersTextField.getText());
        nodeJSRunConfiguration.setProgramParameters(this.nodeParameters.getText());
        nodeJSRunConfiguration.setEnvData(this.myEnvVariablesComponent.getEnvData());
        NodeModuleManager.getInstance(this.myProject).dropNodePathCache();
        for (SettingsEditor<NodeJsRunConfiguration> editor : this.myEmbeddedEditors) {
            editor.applyTo((Object)nodeJSRunConfiguration);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void addListener(@NotNull NodeJsInterpreterChangeListener listener) {
        if (listener == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener);
    }

    private void createUIComponents() {
        this.myChildContainer = new JBPanel((LayoutManager)new BorderLayout());
        this.myInterpreterField = new NodeJsInterpreterField(this.myProject, true);
        this.myInterpreterField.addChangeListener(new NodeJsInterpreterChangeListener(){

            public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                for (NodeJsInterpreterChangeListener listener : NodeRunConfigurationEditor.this.myListeners) {
                    listener.interpreterChanged(newInterpreter);
                }
            }
        });
        this.pathToNode = this.myInterpreterField;
        this.workingDir = NodeRunConfigurationEditor.createWorkingDirectory(this.myProject, (Disposable)this);
        this.pathToJSFile = NodeRunConfigurationEditor.createPathToJsFile(this.myProject, this.workingDir.getTextField());
    }

    protected void disposeEditor() {
        super.disposeEditor();
        for (SettingsEditor<NodeJsRunConfiguration> editor : this.myEmbeddedEditors) {
            Disposer.dispose(editor);
        }
        this.myListeners.clear();
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirectory(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        TextFieldWithBrowseButton workingDir = new TextFieldWithBrowseButton();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        workingDir.addBrowseFolderListener(null, null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        PathShortener.enablePathShortening((JTextField)workingDir.getTextField(), null);
        FileChooserFactory.getInstance().installFileCompletion(workingDir.getTextField(), descriptor, false, parent);
        TextFieldWithBrowseButton textFieldWithBrowseButton = workingDir;
        if (textFieldWithBrowseButton == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        return textFieldWithBrowseButton;
    }

    @NotNull
    private static TextFieldWithBrowseButton createPathToJsFile(@NotNull Project project, @NotNull JTextField workingDir) {
        if (project == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        if (workingDir == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        TextFieldWithBrowseButton pathToJSFile = new TextFieldWithBrowseButton();
        PathShortener.enablePathShortening((JTextField)pathToJSFile.getTextField(), (JTextField)workingDir);
        pathToJSFile.addBrowseFolderListener(null, null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        TextFieldWithBrowseButton textFieldWithBrowseButton = pathToJSFile;
        if (textFieldWithBrowseButton == null) {
            NodeRunConfigurationEditor.$$$reportNull$$$0(10);
        }
        return textFieldWithBrowseButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeJSRunConfiguration";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/NodeRunConfigurationEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/NodeRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkingDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathToJsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChildComponent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createWorkingDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPathToJsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Node interpreter:");
        jLabel.setDisplayedMnemonic('O');
        jLabel.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("JavaScript file:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Application parameters:");
        jLabel3.setDisplayedMnemonic('A');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Node parameters:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.pathToJSFile;
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Working directory:");
        jLabel5.setDisplayedMnemonic('D');
        jLabel5.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.workingDir;
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.nodeParameters = rawCommandLineEditor2 = new RawCommandLineEditor();
        rawCommandLineEditor2.setDialogCaption("Node Parameters");
        jPanel.add((Component)rawCommandLineEditor2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.applicationParametersTextField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Application Parameters");
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(4, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JComponent jComponent = this.pathToNode;
        jPanel.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 1, 1, 7, 0, null, null, null));
        JPanel jPanel2 = this.myChildContainer;
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        environmentVariablesComponent.setAnchor((JComponent)jLabel3);
        jLabel5.setLabelFor((Component)textFieldWithBrowseButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

