/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.reading;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TickIndexer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TimeDistribution;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.TimerEventsReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8OverviewScalesReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8Profile;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8ProfileCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8TickProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.EventsStripeData;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.FlatTopCalls;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CodeScope;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.FlameData;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.io.IntegerRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.RandomRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import com.jetbrains.nodejs.util.CloseableThrowableProcessor;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8LogCachingReader {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.v8log.V8LogCachingReader");
    private static final long MAX_OVERVIEW_POINTS = 2000L;
    public static final int TICK_INDEX_STEP = 100000;
    public static final long GC_STRING_ID = 0L;
    public static final long UNKNOWN_ID = 1L;
    public static final long STACKTRACE_CUT = 2L;
    private final ByteArrayWrapper myDigest;
    private final File myHeaderFile;
    private final File myStackSizeFile;
    private final List<File> myOverviewFiles;
    private final LinksReaderFactory<Long> myDurationFactory;
    private final V8ProfileLine myBottomUp;
    private final V8ProfileLine myTopDown;
    private final CompositeCloseable myResources;
    private final File myTimeFile;
    private final LinksReaderFactory<Long> myStackReader;
    private final LinksReaderFactory<String> myStringsReaderFactory;
    private final double myOneTickApprox;
    private final SequentialRawReader<Long> myTimeReader;
    private final LinksReader<String> myStringsReader;
    private final RandomRawReader<Long> myRandomTimeReader;
    private final LinksReader<Long> myRandomStackReader;
    private final LinksReader<Long> myRandomDurationReader;
    private final V8OverviewScalesReader myOverviewScalesReader;
    private final File myV8LogFile;
    private final FlatTopCalls myFlat;
    @NotNull
    private final File myDistributionFile;
    @NotNull
    private final File mySelfDistributionFile;
    private final SLRUMap<Long, TimeDistribution> myDistributionCache;
    private final RandomRawReader<TimeDistribution> myDistributionReader;
    private final RandomRawReader<TimeDistribution> mySelfDistributionReader;
    private final SLRUMap<Long, TimeDistribution> mySelfDistributionCache;
    private long myLastTs;
    private long myNumTicks;
    private long myNumIdleTicks;
    private long myNumGcTicks;
    @NotNull
    private final TickIndexer myTickIndexer;
    @NotNull
    final TimerEventsReader myTimerEventsReader;
    private final SequentialRawReader<Integer> myStackSizeReader;
    private final Map<String, V8TickProcessor.CodeType> myCodeTypes;
    private int myMaxStackSize;
    private final SLRUMap<Long, String> myStringCache;
    private final SLRUMap<Integer, List<Long>> myStackCache;
    private final SLRUMap<Integer, List<Long>> myDurationCache;
    private final SLRUMap<Long, V8CodeScope> myCodeScopeCache;
    private final Object myLock;
    private final LinksReader<Long> mySequentialDurationReader;

    public V8LogCachingReader cloneReader(long fromTs, long toTs) throws IOException {
        V8Profile recalculated = this.recalculateProfile(fromTs, toTs);
        V8LogCachingReader reader = new V8LogCachingReader(this.myDigest, this.myV8LogFile, this.myHeaderFile, this.myTimeFile, this.myStackSizeFile, this.myStackReader, this.myStringsReaderFactory, this.myTimerEventsReader.getEventsReader(), this.myOverviewFiles, this.myDurationFactory, recalculated.getBottomUpRoot(), recalculated.getTopDownRoot(), recalculated.getFlatTopCallsRoot(), new CompositeCloseable(), this.myTickIndexer, this.myTimerEventsReader.getEventsTickIndexer(), this.myTimerEventsReader.getEventsEndTickIndexer(), this.myCodeTypes, this.myDistributionFile, this.mySelfDistributionFile);
        reader.setNumIdleTicks(recalculated.getIdleTicks());
        reader.setNumGcTicks(recalculated.getGcTicks());
        reader.setMaxStackSize(recalculated.getMaxStackSize());
        reader.setNumTicks(recalculated.getNumTicks());
        return reader;
    }

    public V8LogCachingReader cloneReader() throws IOException {
        return new V8LogCachingReader(this.myDigest, this.myV8LogFile, this.myHeaderFile, this.myTimeFile, this.myStackSizeFile, this.myStackReader, this.myStringsReaderFactory, this.myTimerEventsReader.getEventsReader(), this.myOverviewFiles, this.myDurationFactory, this.myBottomUp, this.myTopDown, this.myFlat, new CompositeCloseable(), this.myTickIndexer, this.myTimerEventsReader.getEventsTickIndexer(), this.myTimerEventsReader.getEventsEndTickIndexer(), this.myCodeTypes, this.myDistributionFile, this.mySelfDistributionFile);
    }

    private V8Profile recalculateProfile(long fromTs, long toTs) throws IOException {
        StackReader stackReader = new StackReader(fromTs, toTs);
        stackReader.execute();
        List<Long> times = stackReader.getTimes();
        List<List<Long>> stackValues = stackReader.getStack();
        V8Profile profile = new V8Profile(V8ProfileCallback.EMPTY);
        int gcTicks = 0;
        int unaccountedTicks = 0;
        int idleTicks = 0;
        int maxStackSize = 0;
        for (int i = 0; i < times.size(); ++i) {
            Long ts = times.get(i);
            if (ts < fromTs || ts > toTs) continue;
            List<Long> currentStack = stackValues.get(i);
            Collections.reverse(currentStack);
            if (!currentStack.isEmpty()) {
                Iterator<Long> iterator = currentStack.iterator();
                while (iterator.hasNext()) {
                    Long id2 = iterator.next();
                    if (id2 == 0L) {
                        ++gcTicks;
                        iterator.remove();
                        continue;
                    }
                    if (id2 != 1L) continue;
                    ++unaccountedTicks;
                    iterator.remove();
                }
            } else {
                ++idleTicks;
            }
            maxStackSize = Math.max(maxStackSize, currentStack.size());
            profile.recordTick(currentStack);
        }
        profile.postProcess(gcTicks, unaccountedTicks, idleTicks, this.myCodeTypes, (ThrowableConvertor<Long, String, IOException>)((ThrowableConvertor)id -> this.getStringById((long)id)), maxStackSize);
        return profile;
    }

    public V8LogCachingReader(@NotNull ByteArrayWrapper digest, File v8LogFile, File headerFile, File timeFile, File stackSizeFile, LinksReaderFactory<Long> stackReader, LinksReaderFactory<String> stringsReader, LinksReaderFactory<V8LogIndexesWriter.TimerEvent> reader, List<File> overviewFiles, LinksReaderFactory<Long> durationFactory, V8ProfileLine bottomUp, V8ProfileLine topDown, FlatTopCalls flat, CompositeCloseable resources, @NotNull TickIndexer eventsIndexer, @NotNull TickIndexer eventsEndIndexer, @NotNull Map<String, V8TickProcessor.CodeType> codeTypes, @NotNull File distributionFile, @NotNull File selfDistributionFile) throws IOException {
        if (digest == null) {
            V8LogCachingReader.$$$reportNull$$$0(0);
        }
        if (eventsIndexer == null) {
            V8LogCachingReader.$$$reportNull$$$0(1);
        }
        if (eventsEndIndexer == null) {
            V8LogCachingReader.$$$reportNull$$$0(2);
        }
        if (codeTypes == null) {
            V8LogCachingReader.$$$reportNull$$$0(3);
        }
        if (distributionFile == null) {
            V8LogCachingReader.$$$reportNull$$$0(4);
        }
        if (selfDistributionFile == null) {
            V8LogCachingReader.$$$reportNull$$$0(5);
        }
        this(digest, v8LogFile, headerFile, timeFile, stackSizeFile, stackReader, stringsReader, reader, overviewFiles, durationFactory, bottomUp, topDown, flat, resources, null, eventsIndexer, eventsEndIndexer, codeTypes, distributionFile, selfDistributionFile);
    }

    private V8LogCachingReader(@NotNull ByteArrayWrapper digest, File v8LogFile, File headerFile, File timeFile, File stackSizeFile, LinksReaderFactory<Long> stackReader, LinksReaderFactory<String> stringsReader, LinksReaderFactory<V8LogIndexesWriter.TimerEvent> timerEventLinksReaderFactory, List<File> overviewFiles, LinksReaderFactory<Long> durationFactory, V8ProfileLine bottomUp, V8ProfileLine topDown, FlatTopCalls flat, CompositeCloseable resources, @Nullable TickIndexer tickIndexer, @NotNull TickIndexer eventsIndexer, @NotNull TickIndexer eventsEndIndexer, @NotNull Map<String, V8TickProcessor.CodeType> codeTypes, @NotNull File distributionFile, @NotNull File selfDistributionFile) throws IOException {
        if (digest == null) {
            V8LogCachingReader.$$$reportNull$$$0(6);
        }
        if (eventsIndexer == null) {
            V8LogCachingReader.$$$reportNull$$$0(7);
        }
        if (eventsEndIndexer == null) {
            V8LogCachingReader.$$$reportNull$$$0(8);
        }
        if (codeTypes == null) {
            V8LogCachingReader.$$$reportNull$$$0(9);
        }
        if (distributionFile == null) {
            V8LogCachingReader.$$$reportNull$$$0(10);
        }
        if (selfDistributionFile == null) {
            V8LogCachingReader.$$$reportNull$$$0(11);
        }
        this.myV8LogFile = v8LogFile;
        this.myFlat = flat;
        this.myDistributionFile = distributionFile;
        this.mySelfDistributionFile = selfDistributionFile;
        this.myLock = new Object();
        this.myDigest = digest;
        this.myHeaderFile = headerFile;
        this.myStackSizeFile = stackSizeFile;
        this.myOverviewFiles = overviewFiles;
        this.myDurationFactory = durationFactory;
        this.myBottomUp = bottomUp;
        this.myTopDown = topDown;
        this.myResources = resources;
        this.myCodeTypes = codeTypes;
        this.myStringCache = new SLRUMap(1024, 1024);
        this.myStackCache = new SLRUMap(1024, 1024);
        this.myDurationCache = new SLRUMap(1024, 1024);
        this.myCodeScopeCache = new SLRUMap(2048, 2048);
        this.myDistributionCache = new SLRUMap(32, 32);
        this.mySelfDistributionCache = new SLRUMap(32, 32);
        this.readHeader();
        this.myOneTickApprox = (double)this.myLastTs / (double)this.myNumTicks;
        this.myTimeFile = timeFile;
        this.myStackReader = stackReader;
        this.myStringsReaderFactory = stringsReader;
        this.myStringsReader = resources.register(this.myStringsReaderFactory.create(false));
        if (tickIndexer == null) {
            TickIndexer indexer = new TickIndexer(100000L);
            this.createTickIndex(indexer);
            this.myTickIndexer = indexer;
        } else {
            this.myTickIndexer = tickIndexer;
        }
        this.myTimerEventsReader = new TimerEventsReader(resources, timerEventLinksReaderFactory, eventsIndexer, eventsEndIndexer);
        this.myStackSizeReader = resources.register(new SequentialRawReader<Integer>(this.myStackSizeFile, new IntegerRawSerializer(), this.myNumTicks));
        this.myTimeReader = resources.register(new SequentialRawReader<Long>(this.myTimeFile, new LongRawSerializer(), this.myNumTicks));
        this.myRandomTimeReader = resources.register(new RandomRawReader<Long>(this.myTimeFile, new LongRawSerializer()));
        this.myRandomStackReader = resources.register(this.myStackReader.create(false));
        this.myRandomDurationReader = resources.register(this.myDurationFactory.create(false));
        this.mySequentialDurationReader = resources.register(this.myDurationFactory.create(true));
        this.myOverviewScalesReader = new V8OverviewScalesReader(this.myOverviewFiles, resources, 50000L);
        this.myDistributionReader = resources.register(new RandomRawReader<TimeDistribution>(distributionFile, TimeDistribution.getSerializer(TimeDistribution.STANDARD)));
        this.mySelfDistributionReader = resources.register(new RandomRawReader<TimeDistribution>(selfDistributionFile, TimeDistribution.getSerializer(TimeDistribution.STANDARD)));
    }

    public ByteArrayWrapper getDigest() {
        return this.myDigest;
    }

    public File getV8LogFile() {
        return this.myV8LogFile;
    }

    public CompositeCloseable getResources() {
        return this.myResources;
    }

    private void createTickIndex(final TickIndexer indexer) throws IOException {
        new SequentialRawReader<Long>(this.myTimeFile, new LongRawSerializer(), this.myNumTicks).iterate(new CloseableThrowableConsumer<Long, IOException>(){

            @Override
            public void close() throws IOException {
            }

            public void consume(Long tick) throws IOException {
                indexer.nextTick(tick);
            }
        });
    }

    private void readHeader() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(FileUtil.loadFileBytes((File)this.myHeaderFile));
        DataInputStream dis = new DataInputStream(is);
        this.myLastTs = dis.readLong();
        this.myNumTicks = dis.readLong();
        this.myMaxStackSize = dis.readInt();
        this.myNumGcTicks = dis.readInt();
        this.myNumIdleTicks = dis.readInt();
    }

    public long getLastTs() {
        return this.myLastTs;
    }

    public long getLastTick() {
        return this.myTickIndexer.getLastTick();
    }

    public long getNumTicks() {
        return this.myNumTicks;
    }

    public int getMaxStackSize() {
        return this.myMaxStackSize;
    }

    public long getNumIdleTicks() {
        return this.myNumIdleTicks;
    }

    public long getNumGcTicks() {
        return this.myNumGcTicks;
    }

    public V8ProfileLine getTopDown() {
        return this.myTopDown;
    }

    public V8ProfileLine getBottomUp() {
        return this.myBottomUp;
    }

    public FlatTopCalls getFlat() {
        return this.myFlat;
    }

    public void setNumIdleTicks(long numIdleTicks) {
        this.myNumIdleTicks = numIdleTicks;
    }

    public void setNumGcTicks(long numGcTicks) {
        this.myNumGcTicks = numGcTicks;
    }

    public void setNumTicks(long numTicks) {
        this.myNumTicks = numTicks;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.myMaxStackSize = maxStackSize;
    }

    @NotNull
    public TickIndexer getEventsTickIndexer() {
        TickIndexer tickIndexer = this.myTimerEventsReader.getEventsTickIndexer();
        if (tickIndexer == null) {
            V8LogCachingReader.$$$reportNull$$$0(12);
        }
        return tickIndexer;
    }

    @NotNull
    public TickIndexer getEventsEndTickIndexer() {
        TickIndexer tickIndexer = this.myTimerEventsReader.getEventsEndTickIndexer();
        if (tickIndexer == null) {
            V8LogCachingReader.$$$reportNull$$$0(13);
        }
        return tickIndexer;
    }

    public Map<String, V8TickProcessor.CodeType> getCodeTypes() {
        return this.myCodeTypes;
    }

    public EventsStripeData getTimerEvents(long from, long to) throws IOException {
        return this.myTimerEventsReader.getTimerEvents(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pair<Long, Integer>> getStackOverview(long from, long to) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            List<Pair<Long, Integer>> mostDetailed;
            from = from < 0L ? 0L : from;
            to = to < 0L || to > this.myTickIndexer.getLastTick() ? this.myTickIndexer.getLastTick() : to;
            List<Pair<Long, Integer>> fromScales = this.myOverviewScalesReader.getStackOverview(from, to);
            if (fromScales != null) {
                return fromScales;
            }
            double numPoints = (double)(to - from) / this.myOneTickApprox;
            if (numPoints > 2000.0 && (mostDetailed = this.myOverviewScalesReader.getMostDetailedOverview(from, to)) != null) {
                return mostDetailed;
            }
            if (this.myTickIndexer.isEmpty()) {
                return Collections.emptyList();
            }
            Integer fromRecord = this.myTickIndexer.getFloorIndexFor(from);
            Integer toRecord = this.myTickIndexer.getCeilIndexFor(to);
            this.myStackSizeReader.reset();
            this.myStackSizeReader.skip(fromRecord.intValue());
            this.myTimeReader.reset();
            this.myTimeReader.skip(fromRecord.intValue());
            ArrayList<Pair<Long, Integer>> result = new ArrayList<Pair<Long, Integer>>();
            for (int i = 0; i < toRecord - fromRecord + 1 && this.myStackSizeReader.hasNext(); ++i) {
                Integer stackSize = this.myStackSizeReader.read();
                Long time = this.myTimeReader.read();
                result.add((Pair<Long, Integer>)Pair.create((Object)time, (Object)stackSize));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringById(long id) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            String string = (String)this.myStringCache.get((Object)id);
            if (string != null) {
                return string;
            }
            string = this.myStringsReader.readRandomLen(id);
            this.myStringCache.put((Object)id, (Object)string);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8CodeScope getCodeScopeByStringId(long id) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            V8CodeScope scope = (V8CodeScope)((Object)this.myCodeScopeCache.get((Object)id));
            if (scope != null) {
                return scope;
            }
            if (0L == id) {
                return V8CodeScope.gc;
            }
            if (2L == id) {
                return V8CodeScope.stackTraceCut;
            }
            String stringById = this.getStringById(id);
            if (stringById.contains(" native ")) {
                this.myCodeScopeCache.put((Object)id, (Object)V8CodeScope.v8);
                return V8CodeScope.v8;
            }
            if (stringById.startsWith("LazyCompile: ") || stringById.startsWith("Function: ")) {
                String[] split = stringById.split(" ");
                for (int i = 1; i < split.length; ++i) {
                    String s = split[i];
                    int idx = s.lastIndexOf(":");
                    if (idx < 0) continue;
                    String path = s.substring(0, idx);
                    if (path.contains("\\") || path.contains("/")) {
                        this.myCodeScopeCache.put((Object)id, (Object)V8CodeScope.local);
                        return V8CodeScope.local;
                    }
                    this.myCodeScopeCache.put((Object)id, (Object)V8CodeScope.node);
                    return V8CodeScope.node;
                }
                this.myCodeScopeCache.put((Object)id, (Object)V8CodeScope.v8);
                return V8CodeScope.v8;
            }
            this.myCodeScopeCache.put((Object)id, (Object)V8CodeScope.v8);
            return V8CodeScope.v8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getDurationList(int idx) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<Long> longs = (ArrayList<Long>)this.myDurationCache.get((Object)idx);
            if (longs != null) {
                return longs;
            }
            longs = new ArrayList<Long>();
            this.myDurationCache.put((Object)idx, longs);
            ArrayList<Long> finalLongs = longs;
            this.myRandomDurationReader.read(idx, (Processor<Long>)((Processor)aLong -> {
                finalLongs.add((Long)aLong);
                return true;
            }));
            return longs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getStackForTsIdx(int idx) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<Long> list = (ArrayList<Long>)this.myStackCache.get((Object)idx);
            if (list != null) {
                return list;
            }
            list = new ArrayList<Long>();
            this.myStackCache.put((Object)idx, list);
            ArrayList<Long> finalList = list;
            this.myRandomStackReader.read(idx, (Processor<Long>)((Processor)stackElement -> {
                if (stackElement == 1L) {
                    return true;
                }
                finalList.add((Long)stackElement);
                return true;
            }));
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlameData getStack(long from, long to) throws IOException {
        TickIndexer tickIndexer = this.myTickIndexer;
        synchronized (tickIndexer) {
            from = from < 0L ? 0L : from;
            to = to < 0L || to > this.myTickIndexer.getLastTick() ? this.myTickIndexer.getLastTick() : to;
            double numPoints = (double)(to - from) / this.myOneTickApprox;
            if (numPoints > 2000.0 && to - from > 2000000L) {
                return null;
            }
            StackReader stackReader = new StackReader(from, to);
            stackReader.execute();
            return stackReader.getFlameData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStatisticalReport(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try (PrintStream ps = new PrintStream(bos);){
            List<V8ProfileLine> unknown = this.myFlat.getUnknown();
            ps.format("Statistical profiling result from %s, (%d ticks, %d unaccounted elements).\n", this.myV8LogFile.getAbsolutePath(), this.myNumTicks, unknown.isEmpty() ? 0 : unknown.get(0).getTotalTicks());
            this.printFlat(ps);
            ps.println();
            this.printBottomUp(ps);
            ps.println();
            this.printTopDown(ps);
        }
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    private void printTopDown(PrintStream ps) {
        ps.println("[Top down (heavy) profile]:\nNote: callees occupying less than 0.1% are not shown.\n\n inclusive          self           name\n ticks   total      ticks   total\n");
        V8LogCachingReader.dfs(this.myTopDown, (PairConsumer<V8ProfileLine, Integer>)((PairConsumer)(line, integer) -> {
            ps.format("%7d  %6.1f%%  %7d  %6.1f%%  ", line.getTotalTicks(), (double)line.getTotalTensPercent() / 10.0, line.getSelfTicks(), (double)line.getSelfTensPercent() / 10.0);
            for (int i = 0; i < integer; ++i) {
                ps.print("  ");
            }
            ps.println(line.getPresentation(true));
        }));
    }

    private void printBottomUp(PrintStream ps) {
        ps.format("[Bottom up (heavy) profile]:\nNote: percentage shows a share of a particular caller in the total amount of its parent calls.\n", new Object[0]);
        ps.format("Callers occupying less than 0.1%% are not shown.\n", new Object[0]);
        ps.println("\n ticks    parent  name\n");
        V8LogCachingReader.dfs(this.myBottomUp, (PairConsumer<V8ProfileLine, Integer>)((PairConsumer)(line, integer) -> {
            ps.format("%7d  %6.1f%%  ", line.getTotalTicks(), (double)line.getTotalTensPercent() / 10.0);
            for (int i = 0; i < integer; ++i) {
                ps.print("  ");
            }
            ps.println(line.getPresentation(true));
        }));
    }

    private static void dfs(V8ProfileLine root, PairConsumer<V8ProfileLine, Integer> consumer) {
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        for (V8ProfileLine line : root.getChildren()) {
            queue.add(Pair.create((Object)line, (Object)0));
        }
        while (!queue.isEmpty()) {
            Pair current = (Pair)queue.removeFirst();
            if (((V8ProfileLine)current.getFirst()).getTotalTensPercent() < 1) continue;
            consumer.consume(current.getFirst(), current.getSecond());
            ArrayList<V8ProfileLine> list = new ArrayList<V8ProfileLine>(((V8ProfileLine)current.getFirst()).getChildren());
            Collections.reverse(list);
            for (V8ProfileLine line : list) {
                queue.addFirst(Pair.create((Object)line, (Object)((Integer)current.getSecond() + 1)));
            }
        }
    }

    private void printFlat(PrintStream ps) {
        List<Pair<String, List<V8ProfileLine>>> presentation = this.myFlat.createPresentation();
        ps.println("\n[Top calls]:");
        for (Pair<String, List<V8ProfileLine>> pair : presentation) {
            ps.println();
            ps.format("[%s]:\nticks  total   name\n", pair.getFirst());
            for (V8ProfileLine line : (List)pair.getSecond()) {
                if (line.getTotalTensPercent() < 1) continue;
                ps.format("%5d %5.1f%%   %s\n", line.getTotalTicks(), (double)line.getTotalTensPercent() / 10.0, line.getPresentation(true));
            }
        }
    }

    @Nullable
    public TimeDistribution getTimesDistribution(long stringId) throws IOException {
        return V8LogCachingReader.getDistributionImpl(stringId, this.myDistributionCache, this.myDistributionReader);
    }

    @Nullable
    public TimeDistribution getSelfTimesDistribution(long stringId) throws IOException {
        return V8LogCachingReader.getDistributionImpl(stringId, this.mySelfDistributionCache, this.mySelfDistributionReader);
    }

    @Nullable
    private static TimeDistribution getDistributionImpl(long stringId, SLRUMap<Long, TimeDistribution> distributionCache, RandomRawReader<TimeDistribution> distributionReader) throws IOException {
        if (stringId < 0L) {
            return null;
        }
        TimeDistribution distribution = (TimeDistribution)distributionCache.get((Object)stringId);
        if (distribution != null) {
            return distribution;
        }
        TimeDistribution read = distributionReader.read(stringId);
        if (read == null) {
            return null;
        }
        distributionCache.put((Object)stringId, (Object)read);
        return read;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsIndexer";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsEndIndexer";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeTypes";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionFile";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfDistributionFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8LogCachingReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8LogCachingReader";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsTickIndexer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsEndTickIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StackReader {
        private final long myFromTs;
        private final long myToTs;
        private final int myFromRecord;
        private final int myToRecord;
        private FlameData myFlameData;
        private List<List<Long>> myStack;
        private List<Long> myTimes;

        public StackReader(long fromTs, long toTs) {
            this.myFromTs = fromTs;
            this.myToTs = toTs;
            this.myFromRecord = V8LogCachingReader.this.myTickIndexer.getFloorIndexFor(fromTs);
            this.myToRecord = V8LogCachingReader.this.myTickIndexer.getCeilIndexFor(toTs);
        }

        public void execute() throws IOException {
            V8LogCachingReader.this.myTimeReader.reset();
            if (this.myFromRecord != 0) {
                V8LogCachingReader.this.myTimeReader.skip(this.myFromRecord);
            }
            this.myTimes = new ArrayList<Long>();
            V8LogCachingReader.this.myTimeReader.iterate(new CloseableThrowableProcessor<Long, IOException>(){
                int cnt;
                {
                    this.cnt = StackReader.this.myFromRecord;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public boolean process(Long ts) throws IOException {
                    if (this.cnt <= StackReader.this.myToRecord) {
                        StackReader.this.myTimes.add(ts);
                    }
                    ++this.cnt;
                    return this.cnt <= StackReader.this.myToRecord;
                }
            });
            this.myStack = new ArrayList<List<Long>>();
            this.myFlameData = new FlameData(this.myFromRecord, this.myTimes);
            LinksReader reader = V8LogCachingReader.this.myStackReader.create(true);
            if (this.myFromRecord != 0) {
                reader.skip(this.myFromRecord, false);
            }
            reader.iterate(new Processor<List<Long>>(){
                int cnt;
                int idxTimes;
                {
                    this.cnt = StackReader.this.myFromRecord;
                    this.idxTimes = 0;
                }

                public boolean process(List<Long> longs) {
                    if (this.idxTimes < StackReader.this.myTimes.size()) {
                        longs = FlameData.filterUnknown(longs);
                        StackReader.this.myStack.add(longs);
                        StackReader.this.myFlameData.tick(longs);
                    }
                    ++this.cnt;
                    ++this.idxTimes;
                    return this.cnt <= StackReader.this.myToRecord;
                }
            });
            this.myFlameData.finish();
        }

        public List<List<Long>> getStack() {
            return this.myStack;
        }

        public List<Long> getTimes() {
            return this.myTimes;
        }

        public FlameData getFlameData() {
            return this.myFlameData;
        }
    }
}

