/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8StackTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.EventsStripe;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartParameters;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartViewUpdater;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.StackTraceTable;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.V8CpuFlameChart;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.V8CpuOverviewChart;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.ZoomFlameChartAnAction;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.view.V8CpuNavigationAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8NavigateToFlameChartIntervalAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import icons.NodeJSIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlameChartView
implements ProfilingView<V8ProfilingCallTreeTable> {
    @NonNls
    public static final String FLAME_CHART = "Flame Chart";
    @NotNull
    private final Project myProject;
    private final V8LogCachingReader myReader;
    private final Consumer<String> myNotificator;
    private final String myDescription;
    @NotNull
    private final V8CpuViewCallback myViewCallback;
    private V8CpuOverviewChart myChart;
    private V8CpuFlameChart myFlameChart;
    private StackTraceTable myStackTraceTable;
    private Splitter mySplitter;
    private JBScrollPane myFlameScroll;
    private DataProviderPanel myWrapper;
    private JBScrollPane myStackScroll;
    private EventsStripe myEventsStripe;
    private ListSelectionListener myStackTraceSelectionListener;
    private final FlameChartViewUpdater myViewUpdater;

    public FlameChartView(@NotNull Project project, @NotNull V8LogCachingReader reader, Consumer<String> notificator, @Nullable Long leftTs, @Nullable Long rightTs, @NotNull FlameChartParameters parameters, String description, @NotNull V8CpuViewCallback viewCallback) throws IOException {
        if (project == null) {
            FlameChartView.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            FlameChartView.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            FlameChartView.$$$reportNull$$$0(2);
        }
        if (viewCallback == null) {
            FlameChartView.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myReader = reader;
        this.myNotificator = notificator;
        this.myDescription = description;
        this.myViewCallback = viewCallback;
        this.myViewUpdater = new FlameChartViewUpdater(this, viewCallback, notificator, parameters);
        final Disposable disposable = new Disposable(){

            public void dispose() {
            }
        };
        reader.getResources().register(new Closeable(){

            @Override
            public void close() throws IOException {
                Disposer.dispose((Disposable)disposable);
            }
        });
        this.createUI(leftTs, rightTs);
        this.myViewUpdater.overviewSelectionChanged();
    }

    public void updateStackTraceTable(@NotNull V8StackTableModel model) {
        if (model == null) {
            FlameChartView.$$$reportNull$$$0(4);
        }
        this.myStackTraceTable.getSelectionModel().removeListSelectionListener(this.myStackTraceSelectionListener);
        this.myStackTraceTable.setModel(model);
        V8Utils.adjustTableColumnWidths(this.myStackTraceTable);
        this.myStackTraceTable.tableChanged(new TableModelEvent(model));
        this.setSelectedRowInTableByChartImpl();
        this.myStackTraceTable.revalidate();
        this.myStackTraceTable.repaint();
    }

    public void setSelectedRowInTableByChart() {
        this.myStackTraceTable.getSelectionModel().removeListSelectionListener(this.myStackTraceSelectionListener);
        this.setSelectedRowInTableByChartImpl();
        this.myStackTraceTable.revalidate();
        this.myStackTraceTable.repaint();
    }

    private void setSelectedRowInTableByChartImpl() {
        int rowInTable;
        Integer selectedInChart = this.myFlameChart.getSelectedInChartRow();
        if (selectedInChart != null && this.myStackTraceTable.getRowCount() > 0 && (rowInTable = this.myStackTraceTable.getRowCount() - selectedInChart - 1) >= 0 && rowInTable < this.myStackTraceTable.getRowCount()) {
            this.myStackTraceTable.setRowSelectionInterval(rowInTable, rowInTable);
            ScrollingUtil.ensureIndexIsVisible((JTable)((Object)this.myStackTraceTable), (int)rowInTable, (int)1);
        }
        if (this.myStackTraceTable.getSelectedRowCount() == 0 && this.myStackTraceTable.getRowCount() > 0) {
            this.myStackTraceTable.setRowSelectionInterval(0, 0);
            ScrollingUtil.ensureIndexIsVisible((JTable)((Object)this.myStackTraceTable), (int)0, (int)1);
        }
        this.addStackTraceSelectionListener();
    }

    @NotNull
    public V8StackTableModel createStackTableModel(int index) throws IOException {
        V8StackTableModel v8StackTableModel = new V8StackTableModel(this.myProject, this.myReader, this.getStackLines(index), this.myReader.getDurationList(index));
        if (v8StackTableModel == null) {
            FlameChartView.$$$reportNull$$$0(5);
        }
        return v8StackTableModel;
    }

    private List<V8CpuLogCall> getStackLines(int index) throws IOException {
        if (index == -1) {
            return Collections.emptyList();
        }
        ArrayList<V8CpuLogCall> lines = new ArrayList<V8CpuLogCall>();
        List<Long> stackIds = this.myReader.getStackForTsIdx(index);
        for (Long id : stackIds) {
            String line = this.myReader.getStringById(id);
            lines.add(V8CpuLogCall.create(StringUtil.notNullize((String)line), id));
        }
        return lines;
    }

    private void createUI(Long leftTs, Long rightTs) throws IOException {
        this.myChart = new V8CpuOverviewChart(0, 0, 0, 50, this.myReader, leftTs == null ? -1L : leftTs, rightTs == null ? -1L : rightTs){

            @Override
            protected void selectionUpdated() {
                FlameChartView.this.myViewUpdater.overviewSelectionChanged();
            }
        };
        this.myFlameChart = new V8CpuFlameChart(0, 0, 2, this.myReader, this.myNotificator, leftTs, rightTs, this.myViewCallback){

            @Override
            protected void detailsChanged() {
                super.detailsChanged();
                FlameChartView.this.myStackTraceTable.getSelectionModel().removeListSelectionListener(FlameChartView.this.myStackTraceSelectionListener);
                FlameChartView.this.myViewUpdater.detailsLineChanged();
                if (FlameChartView.this.myEventsStripe != null) {
                    FlameChartView.this.myEventsStripe.detailsChanged();
                }
            }
        };
        JPanel wrapper = new JPanel(new BorderLayout());
        JPanel innerWrapper = new JPanel(new BorderLayout());
        innerWrapper.add((Component)this.myChart, "North");
        this.myFlameScroll = new JBScrollPane((Component)this.myFlameChart, 22, 30);
        this.myEventsStripe = new EventsStripe(0, UIUtil.getScrollBarWidth(), this.myReader, this.myNotificator, this.myFlameChart);
        this.myChart.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)1));
        this.myFlameChart.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)1, (int)0, (int)0));
        this.myFlameScroll.getVerticalScrollBar().setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)0, (int)1));
        this.myEventsStripe.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)1, (int)0, (int)1));
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myFlameScroll, () -> {
            int diff = this.myFlameScroll.getWidth() - this.myFlameChart.getWidth();
            this.myEventsStripe.setRight(diff);
            this.addStackTraceSelectionListener();
        });
        JPanel legend = new JPanel(){
            private final int myHeight;
            {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                this.setFont(this.getFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
                this.myHeight = fm.getHeight();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(dimension.width, this.myHeight * 2);
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                EventsStripe.drawLegend((Graphics2D)g);
                this.paintBorder(g);
            }
        };
        legend.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)1, (int)1, (int)1));
        innerWrapper.add((Component)legend, "Center");
        innerWrapper.add((Component)this.myEventsStripe, "South");
        wrapper.add((Component)innerWrapper, "North");
        this.myFlameChart.setParentScroll(this.myFlameScroll);
        wrapper.add((Component)this.myFlameScroll, "Center");
        this.myStackTraceTable = new StackTraceTable(this.myProject, new V8StackTableModel(this.myProject, this.myReader, Collections.emptyList(), Collections.emptyList()));
        this.myStackTraceTable.getTableHeader().setReorderingAllowed(false);
        this.mySplitter = new Splitter(false, 0.7f);
        this.mySplitter.setFirstComponent((JComponent)wrapper);
        this.myStackScroll = new JBScrollPane((Component)((Object)this.myStackTraceTable));
        this.mySplitter.setSecondComponent((JComponent)this.myStackScroll);
        V8Utils.LightweightEditSourceAction editSourceAction = new V8Utils.LightweightEditSourceAction((JComponent)((Object)this.myStackTraceTable));
        DefaultActionGroup popupGroup = new DefaultActionGroup();
        popupGroup.add((AnAction)editSourceAction);
        this.addNavigation(popupGroup);
        popupGroup.add((AnAction)new ShowAsStackTraceAction(this.myProject, this.myStackTraceTable));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myStackTraceTable), (ActionGroup)popupGroup, (String)"V8_CPU_PROFILING_POPUP", (ActionManager)ActionManager.getInstance());
        this.myWrapper = new DataProviderPanel(new BorderLayout());
        this.myWrapper.register(V8Utils.DETAILS_POSITION.getName(), (Getter<Object>)((Getter)() -> (Long)this.myFlameChart.getDetailsPosition().getFirst()));
        this.myWrapper.add((Component)this.mySplitter, "Center");
        this.myStackTraceSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FlameChartView.this.myFlameChart.setSelectedCells(FlameChartView.this.myStackTraceTable.getModel().getRowCount(), FlameChartView.this.myStackTraceTable.getSelectedRows());
                FlameChartView.this.myFlameChart.revalidate();
                FlameChartView.this.myFlameChart.repaint();
            }
        };
    }

    private void addStackTraceSelectionListener() {
        this.myStackTraceTable.getSelectionModel().addListSelectionListener(this.myStackTraceSelectionListener);
    }

    @Override
    public JComponent getMainComponent() {
        return this.myWrapper;
    }

    @Override
    public String getName() {
        return FLAME_CHART;
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new ZoomFlameChartAnAction(this.myProject, this.myReader, this.myDescription, this.myNotificator, this, this.myViewCallback));
        this.addNavigation(group);
    }

    private V8CpuNavigationAction addNavigation(DefaultActionGroup group) {
        V8CpuNavigationAction navigationAction = new V8CpuNavigationAction();
        group.add((AnAction)navigationAction);
        navigationAction.getGroup().add((AnAction)new NavigateToStatisticsAction(this.myReader, this.myViewCallback, this.myFlameChart, this.myStackTraceTable, this.myNotificator, "Top Calls"));
        navigationAction.getGroup().add((AnAction)new NavigateToStatisticsAction(this.myReader, this.myViewCallback, this.myFlameChart, this.myStackTraceTable, this.myNotificator, "Bottom-up"));
        navigationAction.getGroup().add((AnAction)new NavigateToStatisticsAction(this.myReader, this.myViewCallback, this.myFlameChart, this.myStackTraceTable, this.myNotificator, "Top-down"));
        V8NavigateToFlameChartIntervalAction.addToGroup(navigationAction.getGroup(), this.myReader, this.myNotificator);
        return navigationAction;
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8ProfilingCallTreeTable getTreeTable() {
        return null;
    }

    @Override
    public void defaultExpand() {
    }

    public V8CpuFlameChart getFlameChart() {
        return this.myFlameChart;
    }

    public V8CpuOverviewChart getOverviewChart() {
        return this.myChart;
    }

    public StackTraceTable getStackTraceTable() {
        return this.myStackTraceTable;
    }

    public EventsStripe getEventsStripe() {
        return this.myEventsStripe;
    }

    public FlameChartViewUpdater getViewUpdater() {
        return this.myViewUpdater;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewCallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateStackTraceTable";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShowAsStackTraceAction
    extends DumbAwareAction {
        private final Project myProject;
        private final StackTraceTable myTable;

        public ShowAsStackTraceAction(Project project, StackTraceTable table) {
            super("Show As Stacktrace");
            this.myProject = project;
            this.myTable = table;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!this.myTable.isEmpty());
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myTable.isEmpty()) {
                return;
            }
            V8StackTableModel model = (V8StackTableModel)this.myTable.getModel();
            String title = "Stacktrace from V8 profiling";
            StringBuilder sb = new StringBuilder("Stacktrace from V8 profiling");
            for (int i = 0; i < model.getRowCount(); ++i) {
                V8CpuLogCall call = model.getCall(i);
                String place = call.getDescriptor() == null ? call.getNotParsedCallable() : call.getDescriptor().getLink();
                sb.append("\n\tat ").append(call.getFunctionName()).append(" (").append(place).append(")");
            }
            AnalyzeStacktraceUtil.addConsole((Project)this.myProject, null, (String)"<Stacktrace from V8 profiling>", (String)sb.toString());
        }
    }

    private static class NavigateToStatisticsAction
    extends AnAction {
        private final V8LogCachingReader myReader;
        private final V8CpuViewCallback myCallback;
        private final V8CpuFlameChart myFlameChart;
        private final StackTraceTable myStackTraceTable;
        private final Consumer<String> myNotificator;
        @NotNull
        private final String myTabName;

        public NavigateToStatisticsAction(V8LogCachingReader reader, V8CpuViewCallback callback, V8CpuFlameChart flameChart, StackTraceTable stackTraceTable, Consumer<String> notificator, @NotNull String tabName) {
            if (tabName == null) {
                NavigateToStatisticsAction.$$$reportNull$$$0(0);
            }
            super("Navigate in " + tabName, "Navigate in " + tabName, NodeJSIcons.Navigate_inMainTree);
            this.myReader = reader;
            this.myCallback = callback;
            this.myFlameChart = flameChart;
            this.myStackTraceTable = stackTraceTable;
            this.myNotificator = notificator;
            this.myTabName = tabName;
        }

        public void actionPerformed(AnActionEvent e) {
            Pair<Long, Integer> position = this.myFlameChart.getDetailsPosition();
            Integer stackTraceIndex = (Integer)position.getSecond();
            if (stackTraceIndex == null || stackTraceIndex < 0) {
                return;
            }
            Integer row = this.myFlameChart.getSelectedInChartRow();
            if (row == null || row < 0) {
                return;
            }
            int rowInTable = this.myStackTraceTable.getRowCount() - row - 1;
            List<Long> stackIds = this.getStack(stackTraceIndex);
            if (stackIds == null) {
                return;
            }
            Point onScreen = this.myStackTraceTable.getLocationOnScreen();
            if ("Top Calls".equals(this.myTabName)) {
                this.myCallback.navigateToTopCalls(stackIds.get(rowInTable), onScreen);
            } else if ("Bottom-up".equals(this.myTabName)) {
                stackIds = stackIds.subList(0, Math.min(stackIds.size(), rowInTable + 1));
                this.myCallback.navigateToBottomUp(stackIds, onScreen);
            } else {
                stackIds = stackIds.subList(rowInTable, stackIds.size());
                this.myCallback.navigateToTopDown(stackIds, onScreen);
            }
        }

        @Nullable
        private List<Long> getStack(Integer stackTraceIndex) {
            List<Long> stackIds;
            try {
                stackIds = this.myReader.getStackForTsIdx(stackTraceIndex);
            }
            catch (IOException e1) {
                this.myNotificator.consume((Object)("Can not navigate to statistics tree: " + e1.getMessage()));
                return null;
            }
            return stackIds;
        }

        public void update(AnActionEvent e) {
            Pair<Long, Integer> position = this.myFlameChart.getDetailsPosition();
            Integer stackTraceIndex = (Integer)position.getSecond();
            Integer row = this.myFlameChart.getSelectedInChartRow();
            e.getPresentation().setEnabled(stackTraceIndex != null && stackTraceIndex >= 0 && row != null && row >= 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartView$NavigateToStatisticsAction", "<init>"));
        }
    }
}

