/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExpandNodeAction
extends DumbAwareAction {
    private final V8ProfilingCallTreeTable myTable;

    public ExpandNodeAction(V8ProfilingCallTreeTable table) {
        super("Expand Node", "Expand node recursively", AllIcons.Actions.Expandall);
        this.myTable = table;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.myTable.getSelectedRow() >= 0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        int row;
        if (e == null) {
            ExpandNodeAction.$$$reportNull$$$0(0);
        }
        if ((row = this.myTable.getSelectedRow()) >= 0) {
            TreeTableWidthController widthController = this.myTable.getWidthController();
            if (widthController != null) {
                widthController.startBatchExpand();
            }
            this.expandRowRecursively(row);
            if (widthController != null) {
                widthController.stopBatchExpand();
            }
        }
    }

    private void expandRowRecursively(int row) {
        this.myTable.getTree().expandRow(row);
        TreePath parentPath = this.myTable.getTree().getPathForRow(row);
        Object component = parentPath.getLastPathComponent();
        TreeTableModel model = this.myTable.getTableModel();
        int count = model.getChildCount(component);
        Object[] pathComponents = parentPath.getPath();
        for (int i = 0; i < count; ++i) {
            Object child = model.getChild(component, i);
            if (child == null) continue;
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(pathComponents));
            list.add(child);
            int childRow = this.myTable.getTree().getRowForPath(new TreePath(ArrayUtil.toObjectArray(list)));
            if (childRow < 0) continue;
            this.expandRowRecursively(childRow);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/cpu/view/ExpandNodeAction", "actionPerformed"));
    }
}

