/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8StackTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.StackTraceTable;
import com.jetbrains.nodejs.run.profile.cpu.view.StatisticsTreeTableWithDetails;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeComponent;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import icons.NodeJSIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SearchInV8TreeAction
extends DumbAwareAction {
    private final Project myProject;
    private final StatisticsTreeTableWithDetails myMainComponent;
    private final V8LogCachingReader myReader;
    @NotNull
    private final Factory<Searcher> mySearcherFactory;
    @NonNls
    public static final String SEARCH_ID = "Node.js.profiling.cpu.search.history";

    public SearchInV8TreeAction(Project project, StatisticsTreeTableWithDetails component, V8LogCachingReader reader, @NotNull Factory<Searcher> searcherFactory) {
        if (searcherFactory == null) {
            SearchInV8TreeAction.$$$reportNull$$$0(0);
        }
        super("Search", "Search", AllIcons.Actions.Search);
        this.myProject = project;
        this.myMainComponent = component;
        this.myReader = reader;
        this.mySearcherFactory = searcherFactory;
    }

    public void actionPerformed(AnActionEvent e) {
        V8ProfilingCallTreeTable table = this.myMainComponent.getTable();
        String text = SearchInV8TreeAction.getSearchString();
        if (!StringUtil.isEmptyOrSpaces((String)text)) {
            Searcher searcher = (Searcher)this.mySearcherFactory.create();
            if (!searcher.search(text.trim(), false)) {
                NodeUIUtil.balloonInfo((Project)this.myProject, (String)("Nothing found by search string '" + text + "'"), (Point)table.getLocationOnScreen(), null);
                return;
            }
            try {
                V8StackTableModel model = new V8StackTableModel(this.myProject, this.myReader, searcher.getUniqueCalls(), searcher.getNumbersOfCalls()).changeLastColumn(new RightAlignedRenderer(), "Number");
                StackTraceTable stackTraceTable = new StackTraceTable(this.myProject, model);
                V8Utils.adjustTableColumnWidths(stackTraceTable);
                DefaultActionGroup tableGroup = new DefaultActionGroup();
                V8Utils.LightweightEditSourceAction editSourceAction = new V8Utils.LightweightEditSourceAction((JComponent)((Object)stackTraceTable));
                tableGroup.add((AnAction)editSourceAction);
                tableGroup.add(this.createNavigateToMainTreeAction(stackTraceTable, searcher));
                PopupHandler.installPopupHandler((JComponent)((Object)stackTraceTable), (ActionGroup)tableGroup, (String)"V8_CPU_PROFILING_POPUP", (ActionManager)ActionManager.getInstance());
                this.myMainComponent.addDetails((JComponent)((Object)stackTraceTable), null, "Search Results for '" + text + "'", true);
                stackTraceTable.addRowSelectionInterval(0, 0);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)stackTraceTable), true));
            }
            catch (IOException e1) {
                NodeUIUtil.balloonInfo((Project)this.myProject, (String)("Error when opening search results: " + e1.getMessage()), (Point)table.getLocationOnScreen(), null);
            }
        }
    }

    private static String getSearchString() {
        SearchTextFieldWithStoredHistory searchField = new SearchTextFieldWithStoredHistory(SEARCH_ID){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                return new Dimension(150, size.height);
            }
        };
        searchField.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        DialogBuilder builder = new DialogBuilder();
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        panel.add((Component)new JBLabel("Search for:"), (Object)"West");
        panel.add((Component)searchField, (Object)"East");
        builder.setTitle("Search in V8 CPU Profiling Log");
        builder.centerPanel((JComponent)panel).setDimensionServiceKey(SEARCH_ID);
        builder.setPreferredFocusComponent((JComponent)searchField);
        if (!builder.showAndGet()) {
            return null;
        }
        searchField.addCurrentTextToHistory();
        return searchField.getText();
    }

    private AnAction createNavigateToMainTreeAction(final @NotNull StackTraceTable stackTable, final Searcher searcher) {
        if (stackTable == null) {
            SearchInV8TreeAction.$$$reportNull$$$0(1);
        }
        return new DumbAwareAction("Show In Tree", "Show In Tree", NodeJSIcons.Navigate_inMainTree){

            public void actionPerformed(AnActionEvent e) {
                V8CpuLogCall call = stackTable.getCall();
                if (call == null) {
                    return;
                }
                SearchInV8TreeAction.showCallsInTree(searcher, call, SearchInV8TreeAction.this.myMainComponent);
            }

            public void update(AnActionEvent e) {
                super.update(e);
                Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
                boolean enabled = project != null && stackTable.getCall() != null;
                e.getPresentation().setEnabled(enabled);
            }
        };
    }

    public static void showCallsInTree(@NotNull Searcher searcher, @NotNull V8CpuLogCall call, @NotNull StatisticsTreeTableWithDetails mainComponent) {
        if (searcher == null) {
            SearchInV8TreeAction.$$$reportNull$$$0(2);
        }
        if (call == null) {
            SearchInV8TreeAction.$$$reportNull$$$0(3);
        }
        if (mainComponent == null) {
            SearchInV8TreeAction.$$$reportNull$$$0(4);
        }
        V8ProfilingCallTreeTable table = mainComponent.getTable();
        V8Utils.collapseAllBare(table);
        table.getTree().expandPath(new TreePath(table.getTree().getModel().getRoot()));
        List<TreePath> paths = searcher.getPathsToExpand(call);
        V8ProfilingCallTreeComponent.resetDataToTable(table, () -> {
            for (TreePath path : paths) {
                table.getTree().expandPath(path.getParentPath());
            }
        }, () -> {
            if (mainComponent == null) {
                SearchInV8TreeAction.$$$reportNull$$$0(5);
            }
            if (call == null) {
                SearchInV8TreeAction.$$$reportNull$$$0(6);
            }
            mainComponent.showSpeedSearch(call);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcherFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainComponent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/SearchInV8TreeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createNavigateToMainTreeAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showCallsInTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showCallsInTree$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Searcher {
        public boolean search(@NotNull String var1, boolean var2);

        public List<V8CpuLogCall> getUniqueCalls();

        public List<Long> getNumbersOfCalls();

        public List<TreePath> getPathsToExpand(@NotNull V8CpuLogCall var1);
    }
}

