/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.execution.ExecutionException;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.nodeJs.NodeChromeDebugProcess;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.view.main.OpenSnapshotWorker;
import com.jetbrains.nodejs.run.profile.heap.view.main.SaveSnapshotDialog;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import icons.NodeJSIcons;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;
import org.jetbrains.wip.WipV8ProfilingHelper;
import org.jetbrains.wip.WipVm;

public class TakeHeapSnapshotAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.NodeJSDebugProcessWithProfiling");
    private static final String USAGE_KEY = "node.js.v8.profiling.take.heap.snapshot";
    @NonNls
    public static final String SNAPSHOT = "snapshot";
    private final Project myProject;
    private final long myPort;
    private final String myConfigurationName;
    private volatile boolean myIsDisposed;
    private volatile boolean myIsInProgress;
    private volatile WipVm myWipVm;

    /*
     * WARNING - void declaration
     */
    public TakeHeapSnapshotAction(@NotNull Project project, long port, String string) {
        void configurationName;
        if (project == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(0);
        }
        super(NodeJSBundle.message("node.js.v8.heap.take.snapshot.action.text", new Object[0]), NodeJSBundle.message("node.js.v8.heap.take.snapshot.action.description", new Object[0]), NodeJSIcons.TakeHeapSnapshot);
        this.myProject = project;
        this.myPort = port;
        this.myConfigurationName = configurationName;
        this.myIsDisposed = false;
    }

    public void setDisposed() {
        this.myIsDisposed = true;
        this.myWipVm = null;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(!this.myIsDisposed && !this.myIsInProgress && (this.myPort != -1L || TakeHeapSnapshotAction.getNodeChromeDebugProcess(e) != null));
    }

    @Nullable
    private static NodeChromeDebugProcess getNodeChromeDebugProcess(AnActionEvent e) {
        XDebugSession session = (XDebugSession)XDebugSession.DATA_KEY.getData(e.getDataContext());
        if (session == null) {
            return null;
        }
        NodeChromeDebugProcess process = (NodeChromeDebugProcess)ObjectUtils.tryCast((Object)session.getDebugProcess(), NodeChromeDebugProcess.class);
        return process == null || !process.canTakeHeapSnapshot() ? null : process;
    }

    public void actionPerformed(AnActionEvent e) {
        UsageTrigger.trigger((String)USAGE_KEY);
        NodeChromeDebugProcess process = TakeHeapSnapshotAction.getNodeChromeDebugProcess(e);
        if (process != null && process.canTakeHeapSnapshot() || this.myPort > 0L) {
            ApplicationManager.getApplication().invokeLater(() -> {
                FileSaverDescriptor descriptor = new FileSaverDescriptor(this.myConfigurationName, "Select a location to save a V8 heap snapshot to.", new String[]{"heapsnapshot"});
                SaveSnapshotDialog dialog = new SaveSnapshotDialog(descriptor, this.myProject);
                VirtualFileWrapper wrapper = dialog.save(this.myProject.getBaseDir(), TakeHeapSnapshotAction.suggestFileName(this.myConfigurationName));
                if (wrapper == null) {
                    return;
                }
                if (!TakeHeapSnapshotAction.checkFilePath(this.myProject, wrapper)) {
                    return;
                }
                this.takeSnapshot(dialog.openCreatedSnapshot(), dialog.showHiddenData(), wrapper, process);
            });
        }
    }

    private void takeSnapshot(final boolean openSnapshot, final boolean showHiddenData, final @NotNull VirtualFileWrapper wrapper, final @Nullable NodeChromeDebugProcess process) {
        if (wrapper == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(1);
        }
        this.myIsInProgress = true;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Taking V8 Heap Snapshot...", true, null){
            private boolean myErrorReported;
            {
                super(arg0, arg1, arg2, arg3);
                this.myErrorReported = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    this.initVm(process);
                    if (TakeHeapSnapshotAction.this.myWipVm == null) {
                        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Can not take V8 Heap Snapshot: please check that --inspect-brk option was passed to Node.js", MessageType.ERROR).notify(this.myProject);
                        return;
                    }
                    String error = new WipV8ProfilingHelper(TakeHeapSnapshotAction.this.myWipVm).takeHeapSnapShot(wrapper.getFile());
                    if (!StringUtil.isEmptyOrSpaces((String)error)) {
                        this.myErrorReported = true;
                        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(error, MessageType.ERROR).notify(this.myProject);
                    }
                }
                catch (Exception e1) {
                    LOG.info((Throwable)e1);
                    this.myErrorReported = true;
                    NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Can not take snapshot: " + e1.getMessage(), MessageType.ERROR).notify(this.myProject);
                }
            }

            public void onFinished() {
                TakeHeapSnapshotAction.this.myIsInProgress = false;
            }

            public void onSuccess() {
                if (!wrapper.getFile().exists() || wrapper.getVirtualFile() == null) {
                    if (!this.myErrorReported) {
                        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Heap snapshot wasn't saved.", MessageType.ERROR).notify(this.myProject);
                    }
                    return;
                }
                NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Heap snapshot was saved to " + TakeHeapSnapshotAction.filePathText(wrapper), MessageType.INFO).notify(this.myProject);
                if (openSnapshot) {
                    OpenSnapshotWorker.work(this.myProject, wrapper.getVirtualFile(), showHiddenData);
                }
            }

            private void initVm(@Nullable NodeChromeDebugProcess process2) throws ExecutionException {
                if (TakeHeapSnapshotAction.this.myWipVm != null) {
                    return;
                }
                if (process2 != null) {
                    TakeHeapSnapshotAction.this.myWipVm = process2.canTakeHeapSnapshot() ? (WipVm)ObjectUtils.tryCast((Object)process2.getConnection().getVm(), WipVm.class) : null;
                } else if (TakeHeapSnapshotAction.this.myPort > 0L) {
                    WipRemoteVmConnection connection = new WipRemoteVmConnection();
                    TakeHeapSnapshotAction.this.myWipVm = (WipVm)ObjectUtils.tryCast((Object)RemoteVmConnectionKt.initRemoteVmConnectionSync((RemoteVmConnection)connection, (int)((int)TakeHeapSnapshotAction.this.myPort)), WipVm.class);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction$1", "run"));
            }
        });
    }

    @NotNull
    private static String filePathText(VirtualFileWrapper wrapper) {
        File file = wrapper.getFile();
        String string = file.getName() + (file.getParentFile() != null ? " (" + file.getParentFile().getAbsolutePath() + ")" : "");
        if (string == null) {
            TakeHeapSnapshotAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String suggestFileName(String name) {
        String suggested = name.replace("\\", "/");
        if ((suggested = StringUtil.trimEnd((String)suggested, (String)"/")).length() == 0) {
            return SNAPSHOT;
        }
        int idx = suggested.lastIndexOf(47);
        if (idx > 0 && (suggested = suggested.substring(idx + 1)).length() == 0) {
            return SNAPSHOT;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < suggested.length(); ++i) {
            char c = suggested.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    private static boolean checkFilePath(Project project, VirtualFileWrapper wrapper) {
        String message = null;
        try {
            if (wrapper.getFile().exists()) {
                return true;
            }
            if (wrapper.getFile().createNewFile()) {
                FileUtil.delete((File)wrapper.getFile());
                return true;
            }
        }
        catch (IOException e1) {
            message = e1.getMessage();
        }
        NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Can not create file '" + wrapper.getFile().getAbsolutePath() + "'. " + StringUtil.notNullize((String)message), MessageType.ERROR).notify(project);
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/TakeHeapSnapshotAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "filePathText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "takeSnapshot";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

