/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.EdgeProcessor;
import com.jetbrains.nodejs.run.profile.heap.calculation.ProcessInPortions;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StringReverseIndexProcessor
implements EdgeProcessor {
    private final ProcessInPortions<Intermediate, LinkedByNameId> myDelegate;
    @NotNull
    private final File myNodesIndexFile;
    private CloseableThrowableConsumer<Intermediate, IOException> myFirstStageCalculator;

    public StringReverseIndexProcessor(@NotNull IndexFiles indexFiles, @NotNull File nodesIndexFile) throws IOException {
        if (indexFiles == null) {
            StringReverseIndexProcessor.$$$reportNull$$$0(0);
        }
        if (nodesIndexFile == null) {
            StringReverseIndexProcessor.$$$reportNull$$$0(1);
        }
        this.myNodesIndexFile = nodesIndexFile;
        this.myDelegate = new ProcessInPortions<Intermediate, LinkedByNameId>(-1L, -1L, new IntermediateRawSerializer(), LinkedByNameId.Serializer.getInstance(), trinity -> trinity.getNameId(), trinity -> {
            LinkedByNameId nameId = new LinkedByNameId(trinity.isNode() ? trinity.getNodeId() : trinity.getEdgeId(), trinity.isNode());
            if (!trinity.isNode()) {
                nameId.setSecondId(trinity.getNodeId());
            }
            return nameId;
        }, indexFiles.generate(V8HeapIndexManager.Category.stringsNumLinks, ".num.index"), indexFiles.generate(V8HeapIndexManager.Category.stringsLinks, ".index"));
        this.myDelegate.setFilter(new MyFilter());
        this.myFirstStageCalculator = this.myDelegate.getFirstStageCalculator();
    }

    public void correctSize(long stringsSize) {
        this.myDelegate.correctSize(stringsSize);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void continueCalculation(@NotNull File edgeIndexFile, long numEdges, long l) throws IOException {
        void nodesCnt;
        if (edgeIndexFile == null) {
            StringReverseIndexProcessor.$$$reportNull$$$0(2);
        }
        this.myFirstStageCalculator.close();
        this.myFirstStageCalculator = null;
        this.myDelegate.continueCalculation((ThrowableConsumer<CloseableThrowableConsumer<Intermediate, IOException>, IOException>)((ThrowableConsumer)arg_0 -> this.lambda$continueCalculation$2((long)nodesCnt, edgeIndexFile, numEdges, arg_0)));
    }

    private static CloseableThrowableConsumer<V8HeapEntry, IOException> createNodeProxy(final @NotNull CloseableThrowableConsumer<Intermediate, IOException> consumer) {
        if (consumer == null) {
            StringReverseIndexProcessor.$$$reportNull$$$0(3);
        }
        return new CloseableThrowableConsumer<V8HeapEntry, IOException>(){

            @Override
            public void close() throws IOException {
            }

            public void consume(V8HeapEntry entry) throws IOException {
                consumer.consume(new Intermediate(entry.getId(), -1L, entry.getNameId()));
            }
        };
    }

    private static CloseableThrowableConsumer<V8HeapEdge, IOException> createEdgeProxy(final @NotNull CloseableThrowableConsumer<Intermediate, IOException> consumer) {
        if (consumer == null) {
            StringReverseIndexProcessor.$$$reportNull$$$0(4);
        }
        return new CloseableThrowableConsumer<V8HeapEdge, IOException>(){

            @Override
            public void close() throws IOException {
            }

            public void consume(V8HeapEdge edge) throws IOException {
                if (edge.hasStringName()) {
                    consumer.consume(new Intermediate(edge.getToIndex(), edge.getId(), edge.getNameId()));
                }
            }
        };
    }

    public CloseableThrowableConsumer<V8HeapEntry, IOException> getNodesFirstStageCalculator() {
        return StringReverseIndexProcessor.createNodeProxy(this.myFirstStageCalculator);
    }

    @Override
    public CloseableThrowableConsumer<V8HeapEdge, IOException> getFirstStageCalculator() {
        return StringReverseIndexProcessor.createEdgeProxy(this.myFirstStageCalculator);
    }

    @Override
    public void close() throws IOException {
        if (this.myFirstStageCalculator != null) {
            this.myFirstStageCalculator.close();
        }
        this.myDelegate.close();
    }

    public LinksReaderFactory<LinkedByNameId> getLinksReaderFactory() throws FileNotFoundException {
        return this.myDelegate.getLinksReaderFactory();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$continueCalculation$2(long nodesCnt, @NotNull File edgeIndexFile, long numEdges, CloseableThrowableConsumer closeableThrowableConsumer) throws IOException {
        void consumer;
        if (edgeIndexFile == null) {
            StringReverseIndexProcessor.$$$reportNull$$$0(5);
        }
        new SequentialRawReader<V8HeapEntry>(this.myNodesIndexFile, V8HeapEntry.MyRawSerializer.getInstance(), nodesCnt).iterate(StringReverseIndexProcessor.createNodeProxy((CloseableThrowableConsumer<Intermediate, IOException>)consumer));
        new SequentialRawReader<V8HeapEdge>(edgeIndexFile, V8HeapEdge.MyRawSerializer.getInstance(), numEdges).iterate(StringReverseIndexProcessor.createEdgeProxy((CloseableThrowableConsumer<Intermediate, IOException>)consumer));
        consumer.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesIndexFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeIndexFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/StringReverseIndexProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "continueCalculation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createNodeProxy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createEdgeProxy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$continueCalculation$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFilter
    implements PairConsumer<Long, Set<LinkedByNameId>> {
        private MyFilter() {
        }

        public void consume(Long aLong, Set<LinkedByNameId> ids) {
            HashSet<Long> nodesWithLinks = new HashSet<Long>();
            for (LinkedByNameId id : ids) {
                if (id.isNode()) continue;
                nodesWithLinks.add(id.getSecondId());
            }
            Iterator<LinkedByNameId> iterator = ids.iterator();
            while (iterator.hasNext()) {
                LinkedByNameId id;
                id = iterator.next();
                if (!id.isNode() || !nodesWithLinks.contains(id.getId())) continue;
                iterator.remove();
            }
        }
    }

    private static class IntermediateRawSerializer
    implements RawSerializer<Intermediate> {
        private IntermediateRawSerializer() {
        }

        @Override
        public void write(@NotNull DataOutput os, @NotNull Intermediate intermediate) throws IOException {
            if (os == null) {
                IntermediateRawSerializer.$$$reportNull$$$0(0);
            }
            if (intermediate == null) {
                IntermediateRawSerializer.$$$reportNull$$$0(1);
            }
            RawSerializer.Helper.serializeLong(intermediate.getNodeId(), os);
            RawSerializer.Helper.serializeLong(intermediate.getEdgeId(), os);
            RawSerializer.Helper.serializeLong(intermediate.getNameId(), os);
        }

        @Override
        public long getRecordSize() {
            return 24L;
        }

        @Override
        public Intermediate read(@NotNull DataInput is) throws IOException {
            if (is == null) {
                IntermediateRawSerializer.$$$reportNull$$$0(2);
            }
            return new Intermediate(RawSerializer.Helper.deserializeLong(is), RawSerializer.Helper.deserializeLong(is), RawSerializer.Helper.deserializeLong(is));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intermediate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "is";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/StringReverseIndexProcessor$IntermediateRawSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Intermediate {
        private final long myNodeId;
        private final long myEdgeId;
        private final long myNameId;

        public Intermediate(long nodeId, long edgeId, long nameId) {
            this.myNodeId = nodeId;
            this.myEdgeId = edgeId;
            this.myNameId = nameId;
        }

        public boolean isNode() {
            return this.myEdgeId == -1L;
        }

        public long getNodeId() {
            return this.myNodeId;
        }

        public long getEdgeId() {
            return this.myEdgeId;
        }

        public long getNameId() {
            return this.myNameId;
        }
    }
}

