/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8HeapSummaryDiffComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import icons.NodeJSIcons;

public class NavigateInSourceSnapshotAction
extends DumbAwareAction {
    private final Project myProject;
    private final String myBaseName;
    private final String myChangedName;
    private final ByteArrayWrapper myBaseDigest;
    private final ByteArrayWrapper myChangedDigest;

    public NavigateInSourceSnapshotAction(Project project, String baseName, String changedName, ByteArrayWrapper baseDigest, ByteArrayWrapper changedDigest) {
        super("Navigate In Source Snapshot", "Navigate In Source Snapshot", NodeJSIcons.Navigate_inMainTree);
        this.myProject = project;
        this.myBaseName = baseName;
        this.myChangedName = changedName;
        this.myBaseDigest = baseDigest;
        this.myChangedDigest = changedDigest;
    }

    public void update(AnActionEvent e) {
        BeforeAfter beforeAfter = (BeforeAfter)V8HeapSummaryDiffComponent.SELECTED_PAIR.getData(e.getDataContext());
        e.getPresentation().setEnabled(beforeAfter != null);
    }

    public void actionPerformed(AnActionEvent e) {
        BeforeAfter beforeAfter = (BeforeAfter)V8HeapSummaryDiffComponent.SELECTED_PAIR.getData(e.getDataContext());
        V8HeapComponent instance = V8HeapComponent.getInstance(this.myProject);
        if (beforeAfter != null && beforeAfter.getAfter() instanceof V8HeapContainmentTreeTableModel.NamedEntry && beforeAfter.getBefore() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            V8HeapSummaryDiffComponent.selectSourceProfile(this.myBaseName, this.myChangedName, e, (Consumer<Boolean>)((Consumer)beforeSelected -> {
                if (Boolean.TRUE.equals(beforeSelected)) {
                    this.navigateToBefore((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)beforeAfter, instance);
                } else {
                    this.navigateToAfter((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)beforeAfter, instance);
                }
            }));
        } else if (beforeAfter != null && beforeAfter.getAfter() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            this.navigateToAfter((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)beforeAfter, instance);
        } else if (beforeAfter != null && beforeAfter.getBefore() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            this.navigateToBefore((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)beforeAfter, instance);
        }
    }

    private void navigateToBefore(BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry> beforeAfter, V8HeapComponent instance) {
        V8MainTreeNavigator navigator = instance.getNavigator(this.myBaseDigest);
        if (navigator != null && navigator.navigateTo(((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getBefore()).getEntry(), null)) {
            instance.activateIfOpen(this.myBaseDigest);
        }
    }

    private void navigateToAfter(BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry> beforeAfter, V8HeapComponent instance) {
        V8MainTreeNavigator navigator = instance.getNavigator(this.myChangedDigest);
        if (navigator != null) {
            navigator.navigateTo(((V8HeapContainmentTreeTableModel.NamedEntry)beforeAfter.getAfter()).getEntry(), null);
            instance.activateIfOpen(this.myChangedDigest);
        }
    }
}

