/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.util.BeforeAfter;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.AggregatesViewDiff;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.SnapshotObjectsComparator;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import gnu.trove.TLongArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class V8DiffCachingReader {
    private final CompositeCloseable myResourses;
    private final V8CachingReader myBaseReader;
    private final V8CachingReader myChangedReader;
    private final TLongArrayList myBaseSnapshotIds;
    private final TLongArrayList myChangedSnapshotIds;
    private final AggregatesViewDiff myAggregatesViewDiff;
    private final SLRUMap<String, List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>>> myMergedAggregatesMap;
    private final Object myLock;
    private final TLongArrayList myBaseSizes;
    private final TLongArrayList myChangedSizes;
    private final List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> myBiggestObjectsDiff;
    private static final int ourMaxBiggestForDiff = 100;

    public V8DiffCachingReader(V8CachingReader baseReader, V8CachingReader changedReader, TLongArrayList baseSnapshotIds, TLongArrayList changedSnapshotIds, TLongArrayList baseSizes, TLongArrayList changedSizes, AggregatesViewDiff aggregatesViewDiff, List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> biggestObjectsDiff) {
        this.myBaseSizes = baseSizes;
        this.myChangedSizes = changedSizes;
        this.myBiggestObjectsDiff = biggestObjectsDiff;
        this.myResourses = new CompositeCloseable();
        this.myBaseReader = baseReader;
        this.myChangedReader = changedReader;
        this.myBaseSnapshotIds = baseSnapshotIds;
        this.myChangedSnapshotIds = changedSnapshotIds;
        this.myAggregatesViewDiff = aggregatesViewDiff;
        this.myMergedAggregatesMap = new SLRUMap(200, 500);
        this.myLock = new Object();
        this.prepare();
    }

    public List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> getBiggestObjectsDiff() {
        return this.myBiggestObjectsDiff;
    }

    public CompositeCloseable getResourses() {
        return this.myResourses;
    }

    public AggregatesViewDiff getAggregatesViewDiff() {
        return this.myAggregatesViewDiff;
    }

    public V8CachingReader getBaseReader() {
        return this.myBaseReader;
    }

    public V8CachingReader getChangedReader() {
        return this.myChangedReader;
    }

    public void prepare() {
        List<AggregatesViewDiff.AggregateDifference> list = this.myAggregatesViewDiff.getList();
        Iterator<AggregatesViewDiff.AggregateDifference> iterator = list.iterator();
        while (iterator.hasNext()) {
            AggregatesViewDiff.AggregateDifference difference = iterator.next();
            if (!this.getChildren(difference).isEmpty()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> getChildren(AggregatesViewDiff.AggregateDifference difference) {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> list = (ArrayList<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>>)this.myMergedAggregatesMap.get((Object)difference.getClassIdx());
            if (list != null) {
                return list;
            }
            list = new ArrayList<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>>();
            this.myMergedAggregatesMap.put((Object)difference.getClassIdx(), list);
            if (difference.getBase() == null) {
                int id = difference.getChanged().getId();
                List<Long> children = V8DiffCachingReader.getSortedOneSideChildren(id, this.myChangedReader);
                for (Long child : children) {
                    list.add((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)new BeforeAfter(null, (Object)V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(child, this.myChangedReader)));
                }
                return list;
            }
            if (difference.getChanged() == null) {
                int id = difference.getBase().getId();
                List<Long> children = V8DiffCachingReader.getSortedOneSideChildren(id, this.myBaseReader);
                for (Long child : children) {
                    list.add((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)new BeforeAfter((Object)V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(child, this.myBaseReader), null));
                }
                return list;
            }
            if (!this.merge(difference, list)) {
                this.myMergedAggregatesMap.remove((Object)difference.getClassIdx());
                return Collections.emptyList();
            }
            return list;
        }
    }

    private boolean merge(AggregatesViewDiff.AggregateDifference difference, List<BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>> list) {
        List<Long> changedChildren = this.myChangedReader.getAggregatesChildren(difference.getChanged().getId());
        List<Long> baseChildren = this.myBaseReader.getAggregatesChildren(difference.getBase().getId());
        SnapshotObjectsComparator comparator = new SnapshotObjectsComparator(this.myBaseReader, this.myChangedReader, this.myBaseSnapshotIds, this.myChangedSnapshotIds, baseChildren, difference.isSystem());
        this.calculateMovement(comparator, baseChildren, changedChildren, difference);
        Collections.sort(changedChildren, V8DiffCachingReader.createByRetainedSizesComparator(this.myChangedReader));
        Collections.sort(baseChildren, V8DiffCachingReader.createByRetainedSizesComparator(this.myBaseReader));
        for (Long child : changedChildren) {
            Long idInBase = comparator.getBaseForChanged(child);
            if (idInBase != null) {
                boolean sizesDiffer;
                boolean retainedSizesDiffer = this.myChangedReader.getRetainedSize(child.intValue()) != this.myBaseReader.getRetainedSize(idInBase.intValue());
                boolean bl = sizesDiffer = this.myChangedSizes.get(child.intValue()) != this.myBaseSizes.get(idInBase.intValue());
                if (!sizesDiffer && !retainedSizesDiffer) continue;
            }
            V8HeapContainmentTreeTableModel.NamedEntry changedEntry = V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(child, this.myChangedReader);
            V8HeapContainmentTreeTableModel.NamedEntry baseEntry = idInBase == null ? null : V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(idInBase, this.myBaseReader);
            list.add((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)new BeforeAfter((Object)baseEntry, (Object)changedEntry));
            if (list.size() < 100) continue;
            break;
        }
        for (Long child : baseChildren) {
            if (list.size() >= 100) break;
            if (comparator.haveEquivalent(child)) continue;
            V8HeapContainmentTreeTableModel.NamedEntry entry = V8HeapContainmentTreeTableModel.NamedEntry.createWithoutLink(child, this.myBaseReader);
            list.add((BeforeAfter<V8HeapContainmentTreeTableModel.NamedEntry>)new BeforeAfter((Object)entry, null));
        }
        return !list.isEmpty();
    }

    private void calculateMovement(SnapshotObjectsComparator comparator, List<Long> baseChildren, List<Long> changedChildren, AggregatesViewDiff.AggregateDifference difference) {
        int addedCnt = 0;
        int removedCnt = 0;
        long addedSize = 0L;
        long removedSize = 0L;
        for (Long changedId : changedChildren) {
            Long baseId = comparator.getBaseForChanged(changedId);
            long changedSize = this.myChangedSizes.get(changedId.intValue());
            if (baseId == null) {
                ++addedCnt;
                addedSize += changedSize;
                continue;
            }
            long sizeDiff = changedSize - this.myBaseSizes.get(baseId.intValue());
            if (sizeDiff > 0L) {
                addedSize += sizeDiff;
                continue;
            }
            removedSize += sizeDiff;
        }
        for (Long baseId : baseChildren) {
            if (comparator.haveEquivalent(baseId)) continue;
            ++removedCnt;
            removedSize += this.myBaseSizes.get(baseId.intValue());
        }
        difference.setAddedCnt(addedCnt);
        difference.setAddedSize(addedSize);
        difference.setRemovedCnt(removedCnt);
        difference.setRemovedSize(removedSize);
    }

    @NotNull
    private static List<Long> getSortedOneSideChildren(int id, V8CachingReader reader) {
        List<Long> children = reader.getAggregatesChildren(id);
        Collections.sort(children, V8DiffCachingReader.createByRetainedSizesComparator(reader));
        List<Long> list = children;
        if (list == null) {
            V8DiffCachingReader.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static Comparator<Long> createByRetainedSizesComparator(V8CachingReader reader) {
        Comparator comparator = (o1, o2) -> {
            int retainedCompare = new Long(reader.getRetainedSize(o2.intValue())).compareTo(reader.getRetainedSize(o1.intValue()));
            return retainedCompare == 0 ? o1.compareTo((Long)o2) : retainedCompare;
        };
        if (comparator == null) {
            V8DiffCachingReader.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    public void close() throws IOException {
        this.myResourses.close();
        this.myBaseReader.close();
        this.myChangedReader.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/nodejs/run/profile/heap/calculation/diff/V8DiffCachingReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedOneSideChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createByRetainedSizesComparator";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

