/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.io;

import com.jetbrains.nodejs.run.profile.heap.io.Positioned;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jetbrains.annotations.NotNull;

public class RandomRawWriter<T extends Positioned>
implements Closeable {
    @NotNull
    private final RawSerializer<T> mySerializer;
    private final RandomAccessFile myRandomAccessFile;

    public RandomRawWriter(@NotNull File file, @NotNull RawSerializer<T> serializer) throws FileNotFoundException {
        if (file == null) {
            RandomRawWriter.$$$reportNull$$$0(0);
        }
        if (serializer == null) {
            RandomRawWriter.$$$reportNull$$$0(1);
        }
        this.mySerializer = serializer;
        this.myRandomAccessFile = new RandomAccessFile(file, "rw");
    }

    public void write(T t) throws IOException {
        this.myRandomAccessFile.seek(t.getOffset());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(out);
        this.mySerializer.write(stream, t);
        this.myRandomAccessFile.write(out.toByteArray());
    }

    @Override
    public void close() throws IOException {
        this.myRandomAccessFile.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serializer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/io/RandomRawWriter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

