/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.SearchResultsTreeModelFactory;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class FindResultsWithOneTree {
    private final Project myProject;
    private final V8CachingReader myReader;
    private final String myText;
    private final int myNumResults;
    private final V8MainTreeNavigator myNavigator;
    private Integer myLimit;
    private SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> myByStringsModel;
    private SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> myByTypes;
    private V8HeapTreeTable myTable;

    public FindResultsWithOneTree(Project project, V8CachingReader reader, String text, int numResults, V8MainTreeNavigator navigator) {
        this.myProject = project;
        this.myReader = reader;
        this.myText = text;
        this.myNumResults = numResults;
        this.myNavigator = navigator;
    }

    public DataProviderPanel showMe(SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> byStringsModel, SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> byTypes) {
        this.myByStringsModel = byStringsModel;
        this.myByTypes = byTypes;
        this.myTable = V8Utils.createTable(this.myProject, byTypes, this.myReader);
        V8Utils.installHeapPopupMenu(this.myProject, this.myTable, this.myReader, this.myNavigator);
        DataProviderPanel wrapper = DataProviderPanel.wrap((JComponent)new JBScrollPane((Component)((Object)this.myTable)));
        this.fillDataContext(this.myTable, wrapper);
        this.myTable.getSelectionModel().setSelectionMode(0);
        return wrapper;
    }

    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new GroupByAction());
        MarkUnmarkAction markUnmarkAction = new MarkUnmarkAction(this.myProject, this.myReader);
        markUnmarkAction.setTable(this.myTable);
        group.add((AnAction)markUnmarkAction);
        V8NavigateToMainTreeAction toMainTreeAction = new V8NavigateToMainTreeAction();
        toMainTreeAction.setTable(this.myTable);
        group.add((AnAction)toMainTreeAction);
        group.add((AnAction)new GoToSourceAction(this.myReader, this.myTable));
        group.add((AnAction)new V8Utils.ExpandAllAction(this.myTable));
        group.add((AnAction)new V8Utils.CollapseAllAction(this.myTable));
    }

    public void defaultExpand() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myNumResults <= 10) {
                TreeUtil.expandAll((JTree)this.myTable.getTree());
            } else {
                SearchResultsTreeModelFactory.expandTop(this.myTable.getTree(), this.myTable.getTableModel());
            }
            if (this.myByStringsModel.getChildCount(this.myByStringsModel.getRoot()) > 0) {
                this.myTable.addRowSelectionInterval(0, 0);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTable), true));
        });
    }

    private void fillDataContext(final TreeTable table, DataProviderPanel wrapper) {
        Convertor convertor = convertor1 -> {
            ChainTreeTableModel.Node node;
            TreePath value = table.getTree().getSelectionPath();
            if (value != null && value.getLastPathComponent() instanceof ChainTreeTableModel.Node && (node = (ChainTreeTableModel.Node)value.getLastPathComponent()).getT() instanceof FixedRetainerNode) {
                return convertor1.convert((Object)((FixedRetainerNode)node.getT()));
            }
            return null;
        };
        wrapper.register(V8NavigateToMainTreeAction.TREE_PATH.getName(), (Getter<Object>)((Getter)() -> convertor.convert(node -> {
            ArrayList<V8HeapContainmentTreeTableModel.NamedEntry> list = new ArrayList<V8HeapContainmentTreeTableModel.NamedEntry>();
            TreePath value = table.getTree().getSelectionPath();
            ChainTreeTableModel.Node current = (ChainTreeTableModel.Node)value.getLastPathComponent();
            if (current.getT() instanceof FixedRetainerNode && ((FixedRetainerNode)current.getT()).isUnreachable()) {
                return null;
            }
            while (true) {
                list.add((V8HeapContainmentTreeTableModel.NamedEntry)current.getT());
                if (current.getChildren().isEmpty()) break;
                current = current.getChildren().get(0);
            }
            list.add(new V8HeapContainmentTreeTableModel.NamedEntry(this.myReader.getNode(0L), "", "", -1L));
            Collections.reverse(list);
            return new TreePath(ArrayUtil.toObjectArray(list));
        })));
        wrapper.register(MarkUnmarkAction.SELECTED_NODE.getName(), (Getter<Object>)((Getter)() -> convertor.convert(o -> o.getEntry())));
        wrapper.register(MarkUnmarkAction.UNREACHABLE_NODE.getName(), (Getter<Object>)((Getter)() -> convertor.convert(o -> o.isUnreachable() ? Boolean.TRUE : null)));
        wrapper.register(MarkUnmarkAction.SELECTED_LINK.getName(), (Getter<Object>)((Getter)() -> convertor.convert(o -> o.getLinkOffset() / 37L)));
        wrapper.register(MarkUnmarkAction.REVALIDATION.getName(), new Getter<Object>(){
            private final Runnable runnable = () -> {
                table.revalidate();
                table.repaint();
            };

            public Object get() {
                return this.runnable;
            }
        });
    }

    public void moreResultsThan(Integer limit) {
        this.myLimit = limit;
    }

    private class GroupByAction
    extends ToggleAction {
        private boolean myIsGroupedByType;

        public GroupByAction() {
            super("Group by Type", "Group by Type", AllIcons.Actions.GroupByPrefix);
            this.myIsGroupedByType = true;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myIsGroupedByType;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myIsGroupedByType = state;
            if (this.myIsGroupedByType) {
                FindResultsWithOneTree.this.myTable.setModel(FindResultsWithOneTree.this.myByTypes);
            } else {
                FindResultsWithOneTree.this.myTable.setModel(FindResultsWithOneTree.this.myByStringsModel);
            }
            V8Utils.afterModelReset(FindResultsWithOneTree.this.myProject, FindResultsWithOneTree.this.myReader, FindResultsWithOneTree.this.myTable);
            FindResultsWithOneTree.this.myTable.revalidate();
            FindResultsWithOneTree.this.myTable.repaint();
            FindResultsWithOneTree.this.defaultExpand();
        }
    }
}

