/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.main;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.nodejs.run.profile.heap.view.main.LoadSnapshotDialog;
import com.jetbrains.nodejs.run.profile.heap.view.main.OpenSnapshotWorker;
import icons.NodeJSIcons;
import org.jetbrains.annotations.NonNls;

public class LoadSnapshotAction
extends DumbAwareAction {
    private static final String USAGE_KEY = "node.js.v8.profiling.open.heap.snapshot.action";
    @NonNls
    private static final String LOAD_V8_HEAP_SNAPSHOT = "Analyze V8 Heap Snapshot";

    public LoadSnapshotAction() {
        super("Analyze V8 Heap Snapshot...", LOAD_V8_HEAP_SNAPSHOT, NodeJSIcons.OpenV8HeapSnapshot);
    }

    public void actionPerformed(AnActionEvent e) {
        UsageTrigger.trigger((String)USAGE_KEY);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        LoadSnapshotDialog dialog = new LoadSnapshotDialog(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"heapsnapshot"), project);
        VirtualFile[] files = dialog.choose(project, new VirtualFile[0]);
        if (files.length == 1) {
            OpenSnapshotWorker.work(project, files[0], dialog.showHiddenData());
        }
    }
}

