/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.renderers;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableCell;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class DirectTreeTableRenderer
extends ColoredTreeCellRenderer {
    private static final int MAX_CONTENTS_LEN = 100;
    public static final int WINDOW_LINK_LIMIT = 60;
    private final SimpleTextAttributes myBlackTextAttributes;
    private final SimpleTextAttributes mySelectionAttributes;
    private final V8HeapComponent myHeapComponent;
    @NotNull
    protected V8CachingReader myReader;
    private final SimpleTextAttributes myObjBackAtt;
    private final SimpleTextAttributes myCodeAtt;
    private final SimpleTextAttributes myClosureAtt;
    private final SimpleTextAttributes myRegExpAtt;
    private final SimpleTextAttributes mySyntheticAtt;
    private final SimpleTextAttributes myPropAtt;
    private final EditorColorsScheme myScheme;
    private boolean myReverseAsDirect;
    private int myMaxWidth;
    private int myMinWidth;
    private boolean myFocusState;
    private static final JBColor detached = new JBColor(new Color(255, 210, 210), new Color(132, 66, 66));
    private static final JBColor detachedUnfocusedSelected = new JBColor(new Color(234, 191, 191), new Color(84, 75, 124));
    private static final JBColor detachedSelected = new JBColor(new Color(120, 159, 196), new Color(84, 75, 124));
    private static final JBColor accessibleFromWindow = new JBColor(new Color(255, 254, 220), new Color(99, 98, 78));
    private static final JBColor accessibleFromWindowUnfocusedSelected = new JBColor(new Color(233, 232, 198), new Color(47, 77, 110));
    private static final JBColor accessibleFromWindowSelected = new JBColor(new Color(104, 165, 255), new Color(94, 129, 140));

    public DirectTreeTableRenderer(@NotNull Project project, @NotNull V8CachingReader reader) {
        SimpleTextAttributes keyword;
        if (project == null) {
            DirectTreeTableRenderer.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            DirectTreeTableRenderer.$$$reportNull$$$0(1);
        }
        this.myBlackTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableForeground(), null, null);
        this.mySelectionAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableSelectionForeground(), null, null);
        this.myMaxWidth = -1;
        this.myMinWidth = -1;
        this.myReader = reader;
        this.myScheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myObjBackAtt = keyword = this.convert(this.myScheme.getAttributes(DefaultLanguageHighlighterColors.KEYWORD));
        this.myCodeAtt = new SimpleTextAttributes(0, null, (Color)new JBColor(new Color(45, 250, 240), new Color(45, 250, 240)));
        this.myClosureAtt = new SimpleTextAttributes(0, (Color)new JBColor(keyword.getFgColor(), keyword.getFgColor()));
        this.myRegExpAtt = new SimpleTextAttributes(0, null, (Color)new JBColor(new Color(120, 250, 190, 57), new Color(120, 250, 190, 57)));
        this.mySyntheticAtt = new SimpleTextAttributes(1, UIUtil.getInactiveTextColor());
        this.myPropAtt = this.convert(this.myScheme.getAttributes(DefaultLanguageHighlighterColors.INSTANCE_FIELD));
        this.myHeapComponent = V8HeapComponent.getInstance(project);
    }

    protected boolean calcFocusedState() {
        return this.myFocusState;
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean selectedForeground;
        if (tree == null) {
            DirectTreeTableRenderer.$$$reportNull$$$0(2);
        }
        this.setPaintFocusBorder(false);
        int width = this.getWidth(tree, row);
        boolean lineHasFocus = ((TreeTableTree)tree).getTreeTable().hasFocus();
        this.getTree().putClientProperty("TreeTableTree", lineHasFocus);
        this.myFocusState = lineHasFocus;
        this.setBackground(selected && !lineHasFocus ? UIUtil.getTreeUnfocusedSelectionBackground() : null);
        boolean bl = selectedForeground = selected && (lineHasFocus || UIUtil.isUnderDarcula());
        if (value instanceof ChainTreeTableModel.Node) {
            value = ((ChainTreeTableModel.Node)value).getT();
        }
        SimpleTextAttributes defaultAttrs = selectedForeground ? this.mySelectionAttributes : this.myBlackTextAttributes;
        ArrayList<PartRenderer> list = new ArrayList<PartRenderer>();
        if (value instanceof FixedRetainerNode) {
            FixedRetainerNode entry = (FixedRetainerNode)value;
            if (entry.isUnreachable()) {
                list.add(new FixedTextRenderer("<unreachable or hidden>", defaultAttrs));
            }
            this.appendMarkRenderer(entry, list);
            this.appendDetachedRenderer(list, entry.getEntry(), selected, lineHasFocus);
            this.appendReachableFromWindowRenderer(list, entry.getEntry(), selected, lineHasFocus);
            this.appendLinkRenderer(entry, list, tree, row);
            if (this.myReverseAsDirect) {
                list.add(new FixedTextRenderer(" : : ", defaultAttrs));
                this.appendObjectTypeRenderer(entry.getEntry(), entry.getName(), list);
                this.appendObjectIdRenderer(entry.getEntry(), list);
            } else if (entry.getParent() != null) {
                list.add(new FixedTextRenderer(" in ", defaultAttrs));
                this.appendObjectTypeRenderer(entry.getParent(), entry.getParentName(), list);
                this.appendObjectIdRenderer(entry.getParent(), list);
            }
            this.adaptiveRendering(list, width, selectedForeground);
        } else if (value instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            V8HeapContainmentTreeTableModel.NamedEntry entry = (V8HeapContainmentTreeTableModel.NamedEntry)value;
            this.appendMarkRenderer(entry, list);
            this.appendDetachedRenderer(list, entry.getEntry(), selected, lineHasFocus);
            this.appendReachableFromWindowRenderer(list, entry.getEntry(), selected, lineHasFocus);
            if (!entry.isDoNotShowLink()) {
                this.appendLinkRenderer(entry, list, tree, row);
                list.add(new FixedTextRenderer(" : : ", defaultAttrs));
            }
            this.appendObjectTypeRenderer(entry.getEntry(), entry.getName(), list);
            this.appendObjectIdRenderer(entry.getEntry(), list);
            this.adaptiveRendering(list, width, selectedForeground);
        } else if (value instanceof Aggregate) {
            this.appendAggregateNameRenderer((Aggregate)value, ((Aggregate)value).getPresentation(this.myReader), list, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.adaptiveRendering(list, width, selectedForeground);
        } else {
            this.append(value.toString(), defaultAttrs);
        }
    }

    private void appendDetachedRenderer(List<PartRenderer> list, V8HeapEntry entry, boolean selected, boolean focused) {
        if (this.myReader.isDetached((int)entry.getId())) {
            this.setBackground((Color)(selected ? (focused ? detachedSelected : detachedUnfocusedSelected) : detached));
        }
    }

    private void appendReachableFromWindowRenderer(List<PartRenderer> list, V8HeapEntry entry, boolean selected, boolean focused) {
        if (this.myReader.isReachableFromWindow(entry)) {
            this.setBackground((Color)(selected ? (focused ? accessibleFromWindowSelected : accessibleFromWindowUnfocusedSelected) : accessibleFromWindow));
        }
    }

    protected int getWidth(@NotNull JTree tree, int row) {
        int width;
        if (tree == null) {
            DirectTreeTableRenderer.$$$reportNull$$$0(3);
        }
        if (this.myMaxWidth < 0) {
            this.myMinWidth = this.getFontMetrics(this.getFont()).stringWidth("compareDocument :: compareDocument @114509");
            this.myMaxWidth = 2 * this.myMinWidth;
        }
        if (tree instanceof TreeTableTree) {
            int rowX = V8Utils.getTableRowX(tree, row);
            TreeTable table = ((TreeTableTree)tree).getTreeTable();
            width = table.getColumnModel().getColumn(0).getWidth() - rowX;
        } else {
            width = tree.getWidth();
        }
        return Math.min(Math.max(width, this.myMinWidth), this.myMaxWidth);
    }

    protected void adaptiveRendering(List<PartRenderer> renderers, int totalWidth, boolean selected) {
        int width = 0;
        int nonCutWidth = 0;
        int cutParts = 0;
        ArrayList<Pair> textParams = new ArrayList<Pair>();
        for (PartRenderer renderer : renderers) {
            String text = renderer.getFullText();
            SimpleTextAttributes attributes = this.getAttributesFromRenderer(selected, renderer);
            Font font = this.getFont().deriveFont(attributes.getFontStyle());
            int w = this.getFontMetrics(font).stringWidth(text);
            width += w;
            if (renderer.canBeCut()) {
                ++cutParts;
                textParams.add(Pair.create((Object)text.length(), (Object)w));
                continue;
            }
            textParams.add(Pair.create((Object)-1, (Object)-1));
            nonCutWidth += w;
        }
        if (width <= totalWidth || cutParts == 0) {
            this.renderFullTexts(renderers, selected);
            return;
        }
        int partWidth = Math.max(50, totalWidth - nonCutWidth) / cutParts;
        int leftParts = 0;
        int newNonCutWidth = nonCutWidth;
        for (int i = 0; i < renderers.size(); ++i) {
            PartRenderer renderer = renderers.get(i);
            if (!renderer.canBeCut()) continue;
            if ((Integer)((Pair)textParams.get(i)).getSecond() <= partWidth) {
                newNonCutWidth += ((Integer)((Pair)textParams.get(i)).getSecond()).intValue();
                textParams.set(i, Pair.create((Object)-1, (Object)-1));
                continue;
            }
            ++leftParts;
        }
        if (leftParts == 0) {
            this.renderFullTexts(renderers, selected);
            return;
        }
        int cutWidth = 0;
        partWidth = Math.max(50, totalWidth - newNonCutWidth) / leftParts;
        for (int i = 0; i < renderers.size(); ++i) {
            PartRenderer renderer = renderers.get(i);
            SimpleTextAttributes attributes = this.getAttributesFromRenderer(selected, renderer);
            if (renderer.canBeCut() && (Integer)((Pair)textParams.get(i)).getFirst() > 0) {
                Pair params = (Pair)textParams.get(i);
                int numSymb = (int)Math.floor((double)partWidth / ((double)((Integer)params.getSecond()).intValue() / (double)((Integer)params.getFirst()).intValue())) - 1;
                numSymb = Math.max(8, numSymb);
                String cutText = renderer.getCutText(numSymb);
                this.append(cutText, attributes);
                Font font = this.getFont().deriveFont(attributes.getFontStyle());
                int w = this.getFontMetrics(font).stringWidth(cutText);
                partWidth = --leftParts == 0 ? 0 : (totalWidth - nonCutWidth - (cutWidth += w)) / leftParts;
                continue;
            }
            this.append(renderer.getFullText(), attributes);
        }
    }

    private void renderFullTexts(List<PartRenderer> renderers, boolean selected) {
        for (PartRenderer renderer : renderers) {
            SimpleTextAttributes attributes = this.getAttributesFromRenderer(selected, renderer);
            this.append(renderer.getFullText(), attributes);
        }
    }

    private SimpleTextAttributes getAttributesFromRenderer(boolean selected, PartRenderer renderer) {
        SimpleTextAttributes attributes;
        SimpleTextAttributes simpleTextAttributes = attributes = selected ? renderer.getSelectedAttributes() : renderer.getAttributes();
        if (attributes == null) {
            attributes = selected ? this.mySelectionAttributes : this.myBlackTextAttributes;
        }
        return attributes;
    }

    private void appendMarkRenderer(V8HeapContainmentTreeTableModel.NamedEntry entry, List<PartRenderer> list) {
        String mark = this.myHeapComponent.getMark(this.myReader.getDigest(), entry.getEntry());
        if (!StringUtil.isEmptyOrSpaces((String)mark)) {
            list.add(new MarkRenderer(mark, SimpleTextAttributes.ERROR_ATTRIBUTES));
        }
    }

    private void appendObjectIdRenderer(V8HeapEntry entry, List<PartRenderer> list) {
        if (entry.getId() == 0L) {
            list.add(new FixedTextRenderer("<root>", SimpleTextAttributes.REGULAR_ATTRIBUTES));
        } else {
            list.add(new FixedTextRenderer(" @" + String.valueOf(entry.getSnapshotObjectId()), SimpleTextAttributes.GRAYED_ATTRIBUTES));
        }
    }

    private void appendLinkRenderer(V8HeapContainmentTreeTableModel.NamedEntry entry, List<PartRenderer> list, JTree tree, int row) {
        String presentation = entry.getLinkPresentation();
        SimpleTextAttributes linkAtt = entry.isLinkHidden() ? SimpleTextAttributes.GRAYED_ATTRIBUTES : (entry.isProperty() ? this.myPropAtt : this.myBlackTextAttributes);
        list.add(new LinkRenderer(presentation, linkAtt, tree, row));
    }

    private void appendObjectTypeRenderer(V8HeapEntry entry, String name, List<PartRenderer> list) {
        SimpleTextAttributes att = this.getAtt(entry.getType());
        if (V8HeapNodeType.kClosure.equals((Object)entry.getType())) {
            list.add(new FixedTextRenderer("function " + name + "()", att));
            return;
        }
        if (V8HeapNodeType.kArray.equals((Object)entry.getType())) {
            list.add(new ArrayTypeRenderer(name, att));
            return;
        }
        if (V8HeapNodeType.kObject.equals((Object)entry.getType()) && name.startsWith("Window")) {
            list.add(new WindowRenderer(name, att));
            return;
        }
        list.add(new SimpleCuttableRenderer(name, att));
    }

    protected void appendAggregateNameRenderer(Aggregate aggregate, String presentation, List<PartRenderer> list, SimpleTextAttributes att) {
        if (V8HeapNodeType.kObject.equals((Object)aggregate.getType()) && presentation.startsWith("Window")) {
            list.add(new WindowRenderer(presentation, att));
            return;
        }
        list.add(new SimpleCuttableRenderer(presentation, att));
    }

    private SimpleTextAttributes getAtt(@NotNull V8HeapNodeType type) {
        if (type == null) {
            DirectTreeTableRenderer.$$$reportNull$$$0(4);
        }
        switch (type) {
            case kHidden: {
                return SimpleTextAttributes.GRAY_ATTRIBUTES;
            }
            case kNative: {
                return SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES;
            }
            case kSynthetic: {
                return this.mySyntheticAtt;
            }
            case kArray: 
            case kHeapNumber: 
            case kSymbol: {
                return this.myBlackTextAttributes;
            }
            case kString: 
            case kConsString: 
            case kSlicedString: {
                return this.convert(this.myScheme.getAttributes(DefaultLanguageHighlighterColors.STRING));
            }
            case kObject: {
                return this.myBlackTextAttributes;
            }
            case kCode: {
                return this.myCodeAtt;
            }
            case kClosure: {
                return this.myClosureAtt;
            }
            case kRegExp: {
                return this.myRegExpAtt;
            }
        }
        return this.myBlackTextAttributes;
    }

    private SimpleTextAttributes convert(TextAttributes ta) {
        return new SimpleTextAttributes(ta.getBackgroundColor(), ta.getForegroundColor(), ta.getEffectColor(), ta.getFontType());
    }

    public void setReverseAsDirect(boolean reverseAsDirect) {
        this.myReverseAsDirect = reverseAsDirect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/renderers/DirectTreeTableRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getWidth";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAtt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WindowRenderer
    extends FixedTextRenderer {
        public WindowRenderer(String text, SimpleTextAttributes attrs) {
            super(text, attrs);
        }

        @Override
        public String getCutText(int maxSymbols) {
            if (this.myText.length() <= maxSymbols) {
                return this.myText;
            }
            int idx1 = this.myText.indexOf("/");
            if (idx1 <= 0) {
                return this.myText;
            }
            String fragment = this.myText.substring(idx1 + 1).trim();
            int protocolIdx = fragment.indexOf("://");
            if (protocolIdx > 0) {
                fragment = fragment.substring(protocolIdx + 3).trim();
            }
            if (fragment.length() > maxSymbols) {
                String cut;
                int firstPart = maxSymbols / 2;
                fragment = cut = fragment.substring(0, firstPart) + "..." + fragment.substring(fragment.length() - (maxSymbols - firstPart));
            }
            return "Window / " + fragment;
        }

        @Override
        public boolean canBeCut() {
            return true;
        }
    }

    private static class ArrayTypeRenderer
    extends SimpleCuttableRenderer {
        public ArrayTypeRenderer(String text, SimpleTextAttributes attrs) {
            super(text, attrs);
        }

        @Override
        public String getFullText() {
            return super.getFullText() + "[]";
        }

        @Override
        public String getCutText(int maxSymbols) {
            String text = super.getCutText(maxSymbols - 2);
            return text + "[]";
        }
    }

    private static class LinkRenderer
    extends SimpleCuttableRenderer {
        private final TreeTableTree myTree;
        private final int myRow;

        public LinkRenderer(String text, SimpleTextAttributes attrs, JTree tree, int row) {
            super(text, attrs);
            this.myRow = row;
            this.myTree = tree instanceof TreeTableTree ? (TreeTableTree)tree : null;
        }

        @Override
        public boolean canBeCut() {
            if (this.myTree != null) {
                boolean isExpanded = false;
                TreeTable table = this.myTree.getTreeTable();
                ExpandableItemsHandler handler = table.getExpandableItemsHandler();
                if (handler.isEnabled() && !handler.getExpandedItems().isEmpty()) {
                    Collection items = handler.getExpandedItems();
                    for (TableCell item : items) {
                        if (item.row != this.myRow || item.column != 0) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static class MarkRenderer
    extends FixedTextRenderer {
        private MarkRenderer(String markText, SimpleTextAttributes attrs) {
            super(markText, attrs);
        }

        @Override
        public String getFullText() {
            return "[" + super.getFullText() + "]";
        }

        @Override
        public String getCutText(int maxSymbols) {
            if (this.myText.length() + 2 <= maxSymbols) {
                return this.getFullText();
            }
            return "[" + this.myText.substring(0, maxSymbols - 5) + "...]";
        }

        @Override
        public boolean canBeCut() {
            return true;
        }
    }

    private static class SimpleCuttableRenderer
    extends FixedTextRenderer {
        public SimpleCuttableRenderer(String text, SimpleTextAttributes attrs) {
            super(text, attrs);
        }

        @Override
        public String getCutText(int maxSymbols) {
            if (this.myText.length() <= maxSymbols) {
                return this.myText;
            }
            return this.myText.substring(0, maxSymbols - 3) + "...";
        }

        @Override
        public boolean canBeCut() {
            return true;
        }
    }

    private static class FixedTextRenderer
    implements PartRenderer {
        private final SimpleTextAttributes myAttrs;
        private final SimpleTextAttributes mySelectedAttrs;
        protected final String myText;

        private FixedTextRenderer(String text, SimpleTextAttributes attrs) {
            this.myText = text;
            this.myAttrs = attrs;
            this.mySelectedAttrs = this.myAttrs.derive(attrs.getStyle(), UIUtil.getTreeSelectionForeground(), attrs.getBgColor(), attrs.getWaveColor());
        }

        @Override
        public SimpleTextAttributes getAttributes() {
            return this.myAttrs;
        }

        @Override
        public SimpleTextAttributes getSelectedAttributes() {
            return this.mySelectedAttrs;
        }

        @Override
        public String getFullText() {
            return this.myText;
        }

        @Override
        public String getCutText(int maxSymbols) {
            return this.myText;
        }

        @Override
        public boolean canBeCut() {
            return false;
        }
    }

    protected static interface PartRenderer {
        public SimpleTextAttributes getAttributes();

        public SimpleTextAttributes getSelectedAttributes();

        public String getFullText();

        public String getCutText(int var1);

        public boolean canBeCut();
    }
}

