/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import com.jetbrains.nodejs.util.ui.WithDisplayName;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIHelper {
    public static final String UNAVAILABLE = "Unavailable";

    private UIHelper() {
    }

    @NotNull
    public static JPanel createGrowingDownPanelWithHorizontallyStretchedComponent(@NotNull Component upperComponent) {
        if (upperComponent == null) {
            UIHelper.$$$reportNull$$$0(0);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(upperComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel empty = UIHelper.createEmptyPanel();
        panel.add((Component)empty, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            UIHelper.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createEmptyPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (jPanel == null) {
            UIHelper.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    public static ComboBox<WithDisplayName> createCombobox(final @NotNull String prototypeDisplayValue, final @NotNull WithDisplayName displayNameWhenListIsEmpty) {
        if (prototypeDisplayValue == null) {
            UIHelper.$$$reportNull$$$0(3);
        }
        if (displayNameWhenListIsEmpty == null) {
            UIHelper.$$$reportNull$$$0(4);
        }
        ComboBox comboBox = new ComboBox();
        comboBox.setPrototypeDisplayValue((Object)new WithDisplayName(){

            @Override
            public String getDisplayName() {
                return prototypeDisplayValue;
            }
        });
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<WithDisplayName>(){

            public void customize(JList list, WithDisplayName option, int index, boolean selected, boolean hasFocus) {
                this.setText(option != null ? option.getDisplayName() : displayNameWhenListIsEmpty.getDisplayName());
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            UIHelper.$$$reportNull$$$0(5);
        }
        return comboBox2;
    }

    @NotNull
    public static <E extends WithDisplayName> ComboBox<E> createCombobox(final @NotNull String displayNameForEmptyList) {
        if (displayNameForEmptyList == null) {
            UIHelper.$$$reportNull$$$0(6);
        }
        ComboBox comboBox = new ComboBox();
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<WithDisplayName>(){

            public void customize(JList list, WithDisplayName option, int index, boolean selected, boolean hasFocus) {
                if (option != null) {
                    String text = option.getDisplayName();
                    if (text.length() < displayNameForEmptyList.length()) {
                        char[] a = new char[2 * (displayNameForEmptyList.length() - text.length())];
                        Arrays.fill(a, ' ');
                        text = text + new String(a);
                    }
                    this.setText(text);
                } else {
                    this.setText(displayNameForEmptyList);
                }
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            UIHelper.$$$reportNull$$$0(7);
        }
        return comboBox2;
    }

    @NotNull
    public static JPanel wrapInCenteredPanel(@NotNull String text) {
        if (text == null) {
            UIHelper.$$$reportNull$$$0(8);
        }
        JBLabel comp = new JBLabel(text);
        comp.setForeground(UIUtil.getInactiveTextColor());
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 0));
        listPane.add(Box.createHorizontalGlue());
        listPane.add((Component)comp);
        listPane.setBackground(UIUtil.getTableBackground());
        listPane.add(Box.createHorizontalGlue());
        JPanel jPanel = listPane;
        if (jPanel == null) {
            UIHelper.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    public static void enableShortenedPath(@NotNull JTextField textField, @Nullable JTextField baseDirComponent) {
        if (textField == null) {
            UIHelper.$$$reportNull$$$0(10);
        }
        PathShortener.enableShortenedPath((JTextField)textField, (JTextField)baseDirComponent);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull JTextField textField) {
        if (textField == null) {
            UIHelper.$$$reportNull$$$0(11);
        }
        String string = PathShortener.getAbsolutePath((JTextField)textField);
        if (string == null) {
            UIHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String getTextWithExpandedUserHome(@NotNull JTextField textField) {
        if (textField == null) {
            UIHelper.$$$reportNull$$$0(13);
        }
        String string = PathShortener.getTextWithExpandedUserHome((JTextField)textField);
        if (string == null) {
            UIHelper.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperComponent";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/util/ui/UIHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototypeDisplayValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayNameWhenListIsEmpty";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayNameForEmptyList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/util/ui/UIHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createGrowingDownPanelWithHorizontallyStretchedComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyPanel";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCombobox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInCenteredPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithExpandedUserHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGrowingDownPanelWithHorizontallyStretchedComponent";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCombobox";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCenteredPanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enableShortenedPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithExpandedUserHome";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

