/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.distributedtask.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.AlmHttpClientBase;
import com.microsoft.alm.client.model.ApiResourceVersion;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.distributedtask.webapi.model.ServiceEndpoint;
import com.microsoft.alm.distributedtask.webapi.model.TaskAgent;
import com.microsoft.alm.distributedtask.webapi.model.TaskAgentJobRequest;
import com.microsoft.alm.distributedtask.webapi.model.TaskAgentMessage;
import com.microsoft.alm.distributedtask.webapi.model.TaskAgentPool;
import com.microsoft.alm.distributedtask.webapi.model.TaskAgentQueue;
import com.microsoft.alm.distributedtask.webapi.model.TaskAgentQueueActionFilter;
import com.microsoft.alm.distributedtask.webapi.model.TaskAgentSession;
import com.microsoft.alm.distributedtask.webapi.model.TaskDefinition;
import com.microsoft.alm.distributedtask.webapi.model.TaskDefinitionEndpoint;
import com.microsoft.alm.distributedtask.webapi.model.TaskPackageMetadata;
import com.microsoft.visualstudio.services.webapi.model.IdentityRef;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Invocation;

public abstract class TaskAgentHttpClientBase
extends AlmHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected TaskAgentHttpClientBase(Object jaxrsClient, URI baseUrl) {
        super(jaxrsClient, baseUrl);
    }

    protected TaskAgentHttpClientBase(Object tfsConnection) {
        super(tfsConnection);
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public TaskAgent addAgent(TaskAgent agent, int poolId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)agent, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgent)super.sendRequest((Object)httpRequest, TaskAgent.class);
    }

    public void deleteAgent(int poolId, int agentId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public TaskAgent getAgent(int poolId, int agentId, Boolean includeCapabilities, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCapabilities", (Object)includeCapabilities);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TaskAgent)super.sendRequest((Object)httpRequest, TaskAgent.class);
    }

    public List<TaskAgent> getAgents(int poolId, String agentName, Boolean includeCapabilities, List<String> propertyFilters, List<String> demands) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("agentName", agentName);
        queryParameters.addIfNotNull("includeCapabilities", (Object)includeCapabilities);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        queryParameters.addIfNotNull("demands", demands);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskAgent>>(){});
    }

    public TaskAgent replaceAgent(TaskAgent agent, int poolId, int agentId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)agent, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgent)super.sendRequest((Object)httpRequest, TaskAgent.class);
    }

    public TaskAgent updateAgent(TaskAgent agent, int poolId, int agentId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)agent, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgent)super.sendRequest((Object)httpRequest, TaskAgent.class);
    }

    public List<String> queryEndpoint(TaskDefinitionEndpoint endpoint) {
        UUID locationId = UUID.fromString("f223b809-8c33-4b7d-b53f-07232569b5d6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)endpoint, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<String>>(){});
    }

    public InputStream getTaskIcon(UUID taskId, String versionString) {
        UUID locationId = UUID.fromString("63463108-174d-49d4-b8cb-235eea42a5e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("taskId", taskId);
        routeValues.put("versionString", versionString);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public void deleteAgentRequest(int poolId, long requestId, UUID lockToken) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Number> routeValues = new HashMap<String, Number>();
        routeValues.put("poolId", poolId);
        routeValues.put("requestId", requestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("lockToken", (Object)lockToken);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public TaskAgentJobRequest getAgentRequest(int poolId, long requestId) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Number> routeValues = new HashMap<String, Number>();
        routeValues.put("poolId", poolId);
        routeValues.put("requestId", requestId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (TaskAgentJobRequest)super.sendRequest((Object)httpRequest, TaskAgentJobRequest.class);
    }

    public TaskAgentJobRequest queueAgentRequest(TaskAgentJobRequest request, int poolId) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)request, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgentJobRequest)super.sendRequest((Object)httpRequest, TaskAgentJobRequest.class);
    }

    public TaskAgentJobRequest updateAgentRequest(TaskAgentJobRequest request, int poolId, long requestId, UUID lockToken) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Number> routeValues = new HashMap<String, Number>();
        routeValues.put("poolId", poolId);
        routeValues.put("requestId", requestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("lockToken", (Object)lockToken);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)request, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TaskAgentJobRequest)super.sendRequest((Object)httpRequest, TaskAgentJobRequest.class);
    }

    public void deleteMessage(int poolId, long messageId, UUID sessionId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Number> routeValues = new HashMap<String, Number>();
        routeValues.put("poolId", poolId);
        routeValues.put("messageId", messageId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("sessionId", (Object)sessionId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public TaskAgentMessage getMessage(int poolId, UUID sessionId, Integer lastMessageId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("sessionId", (Object)sessionId);
        queryParameters.addIfNotNull("lastMessageId", (Object)lastMessageId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TaskAgentMessage)super.sendRequest((Object)httpRequest, TaskAgentMessage.class);
    }

    public void refreshAgent(int poolId, int agentId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"agentId", (Object)String.valueOf(agentId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void refreshAgents(int poolId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void sendMessage(TaskAgentMessage message, int poolId, long requestId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put((Object)"requestId", (Object)String.valueOf(requestId));
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)message, APPLICATION_JSON_TYPE, (Map)queryParameters, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public TaskPackageMetadata getPackage(String packageType) {
        UUID locationId = UUID.fromString("8ffcd551-079c-493a-9c02-54346299d144");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("packageType", packageType);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (TaskPackageMetadata)super.sendRequest((Object)httpRequest, TaskPackageMetadata.class);
    }

    public List<TaskPackageMetadata> getPackages() {
        UUID locationId = UUID.fromString("8ffcd551-079c-493a-9c02-54346299d144");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskPackageMetadata>>(){});
    }

    public InputStream getPackageZip(String packageType) {
        UUID locationId = UUID.fromString("8ffcd551-079c-493a-9c02-54346299d144");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, String> routeValues = new HashMap<String, String>();
        routeValues.put("packageType", packageType);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public List<IdentityRef> getAgentPoolRoles(Integer poolId) {
        UUID locationId = UUID.fromString("381dd2bb-35cf-4103-ae8c-3c815b25763c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRef>>(){});
    }

    public TaskAgentPool addAgentPool(TaskAgentPool pool) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)pool, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgentPool)super.sendRequest((Object)httpRequest, TaskAgentPool.class);
    }

    public void deleteAgentPool(int poolId) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public TaskAgentPool getAgentPool(int poolId, List<String> properties) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("properties", properties);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TaskAgentPool)super.sendRequest((Object)httpRequest, TaskAgentPool.class);
    }

    public List<TaskAgentPool> getAgentPools(String poolName, List<String> properties) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("poolName", poolName);
        queryParameters.addIfNotNull("properties", properties);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskAgentPool>>(){});
    }

    public TaskAgentPool updateAgentPool(TaskAgentPool pool, int poolId) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PATCH, locationId, routeValues, apiVersion, (Object)pool, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgentPool)super.sendRequest((Object)httpRequest, TaskAgentPool.class);
    }

    public List<IdentityRef> getAgentQueueRoles(Integer queueId) {
        UUID locationId = UUID.fromString("b0c6d64d-c9fa-4946-b8de-77de623ee585");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("queueId", queueId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<IdentityRef>>(){});
    }

    public TaskAgentQueue addAgentQueue(TaskAgentQueue queue) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, apiVersion, (Object)queue, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgentQueue)super.sendRequest((Object)httpRequest, TaskAgentQueue.class);
    }

    public void deleteAgentQueue(int queueId) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("queueId", queueId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public TaskAgentQueue getAgentQueue(int queueId, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("queueId", queueId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("actionFilter", (Object)actionFilter);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TaskAgentQueue)super.sendRequest((Object)httpRequest, TaskAgentQueue.class);
    }

    public List<TaskAgentQueue> getAgentQueues(String queueName, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("queueName", queueName);
        queryParameters.addIfNotNull("actionFilter", (Object)actionFilter);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskAgentQueue>>(){});
    }

    public ServiceEndpoint createServiceEndpoint(ServiceEndpoint endpoint, UUID scopeIdentifier, UUID endpointId) {
        UUID locationId = UUID.fromString("ca373c13-fec3-4b30-9525-35a117731384");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("endpointId", endpointId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, (Object)endpoint, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (ServiceEndpoint)super.sendRequest((Object)httpRequest, ServiceEndpoint.class);
    }

    public void deleteServiceEndpoint(UUID scopeIdentifier, UUID endpointId) {
        UUID locationId = UUID.fromString("ca373c13-fec3-4b30-9525-35a117731384");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("endpointId", endpointId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public ServiceEndpoint getServiceEndpointDetails(UUID scopeIdentifier, UUID endpointId) {
        UUID locationId = UUID.fromString("ca373c13-fec3-4b30-9525-35a117731384");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        routeValues.put("endpointId", endpointId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        return (ServiceEndpoint)super.sendRequest((Object)httpRequest, ServiceEndpoint.class);
    }

    public List<ServiceEndpoint> getServiceEndpoints(UUID scopeIdentifier, String type, List<String> authSchemes) {
        UUID locationId = UUID.fromString("ca373c13-fec3-4b30-9525-35a117731384");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1-preview.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("scopeIdentifier", scopeIdentifier);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        queryParameters.addIfNotNull("authSchemes", authSchemes);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<ServiceEndpoint>>(){});
    }

    public TaskAgentSession createAgentSession(TaskAgentSession session, int poolId) {
        UUID locationId = UUID.fromString("134e239e-2df3-4794-a6f6-24f1f19ec8dc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.POST, locationId, routeValues, apiVersion, (Object)session, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgentSession)super.sendRequest((Object)httpRequest, TaskAgentSession.class);
    }

    public void deleteAgentSession(int poolId, UUID sessionId) {
        UUID locationId = UUID.fromString("134e239e-2df3-4794-a6f6-24f1f19ec8dc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Comparable<Integer>> routeValues = new HashMap<String, Comparable<Integer>>();
        routeValues.put("poolId", Integer.valueOf(poolId));
        routeValues.put("sessionId", sessionId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public void deleteTaskDefinition(UUID taskId) {
        UUID locationId = UUID.fromString("60aac929-f0cd-4bc8-9ce4-6b30e8f1b1bd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("taskId", taskId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.DELETE, locationId, routeValues, apiVersion, APPLICATION_JSON_TYPE);
        super.sendRequest((Object)httpRequest);
    }

    public InputStream getTaskContentZip(UUID taskId, String versionString, List<String> visibility, Boolean scopeLocal) {
        UUID locationId = UUID.fromString("60aac929-f0cd-4bc8-9ce4-6b30e8f1b1bd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("taskId", taskId);
        routeValues.put("versionString", versionString);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("visibility", visibility);
        queryParameters.addIfNotNull("scopeLocal", (Object)scopeLocal);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_ZIP_TYPE);
        return (InputStream)super.sendRequest((Object)httpRequest, InputStream.class);
    }

    public TaskDefinition getTaskDefinition(UUID taskId, String versionString, List<String> visibility, Boolean scopeLocal) {
        UUID locationId = UUID.fromString("60aac929-f0cd-4bc8-9ce4-6b30e8f1b1bd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("taskId", taskId);
        routeValues.put("versionString", versionString);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("visibility", visibility);
        queryParameters.addIfNotNull("scopeLocal", (Object)scopeLocal);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (TaskDefinition)super.sendRequest((Object)httpRequest, TaskDefinition.class);
    }

    public List<TaskDefinition> getTaskDefinitions(UUID taskId, List<String> visibility, Boolean scopeLocal) {
        UUID locationId = UUID.fromString("60aac929-f0cd-4bc8-9ce4-6b30e8f1b1bd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, UUID> routeValues = new HashMap<String, UUID>();
        routeValues.put("taskId", taskId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("visibility", visibility);
        queryParameters.addIfNotNull("scopeLocal", (Object)scopeLocal);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.GET, locationId, routeValues, apiVersion, (Map)queryParameters, APPLICATION_JSON_TYPE);
        return (List)super.sendRequest((Object)httpRequest, (TypeReference)new TypeReference<List<TaskDefinition>>(){});
    }

    public TaskAgent updateAgentUserCapabilities(HashMap<String, String> userCapabilities, int poolId, int agentId) {
        UUID locationId = UUID.fromString("30ba3ada-fedf-4da8-bbb5-dacf2f82e176");
        ApiResourceVersion apiVersion = new ApiResourceVersion("2.1");
        HashMap<String, Integer> routeValues = new HashMap<String, Integer>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        Invocation httpRequest = super.createRequest(AlmHttpClientBase.HttpMethod.PUT, locationId, routeValues, apiVersion, userCapabilities, APPLICATION_JSON_TYPE, APPLICATION_JSON_TYPE);
        return (TaskAgent)super.sendRequest((Object)httpRequest, TaskAgent.class);
    }
}

