/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.javascript.debugger.Annotation;
import com.intellij.javascript.debugger.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.ConsolePrinter;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.LineAnnotation;
import com.intellij.javascript.debugger.LineAnnotationMaps;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugSession;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\fJ\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020\fJ\u0006\u0010!\u001a\u00020\fJ\u0006\u0010\"\u001a\u00020\fJ\u0006\u0010#\u001a\u00020\fJ\u000e\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\nJ \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010*\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010+\u001a\u00020\fJ\u0010\u0010,\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/javascript/debugger/ConsoleMessageBuilder;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "tasks", "", "Lcom/intellij/util/Consumer;", "Lcom/intellij/javascript/debugger/ConsolePrinter;", "addFileLink", "", "url", "", "suggestedLine", "", "suggestedColumn", "functionName", "resolveToScript", "", "scriptId", "append", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "appendError", "clear", "doPrintIndent", "it", "getLinkText", "groupEnd", "groupStart", "indentIn", "indentOut", "newLine", "print", "consolePrinter", "printAndStoreValueToInspect", "value", "Lorg/jetbrains/debugger/values/Value;", "expression", "printBrowserLink", "printIndent", "printSystem", "intellij.javascript.debugger"})
public final class ConsoleMessageBuilder {
    private final List<Consumer<ConsolePrinter>> tasks;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    public final void appendError(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
        this.append(text, consoleViewContentType);
    }

    private final String getLinkText(String url) {
        return JsFileUtil.trimTitle(url);
    }

    public final void addFileLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        Annotation annotation;
        VirtualFile file;
        Url parsedUrl;
        SourceInfo sourceInfo;
        SourceInfo sourceInfo2;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        int line = suggestedLine;
        int column = suggestedColumn;
        if (resolveToScript) {
            Vm vm = this.debugProcess.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            sourceInfo2 = this.debugProcess.getSourceInfo(vm, scriptId, url, functionName, line, column);
        } else {
            sourceInfo2 = sourceInfo = null;
        }
        if (sourceInfo == null) {
            parsedUrl = Urls.parse((String)url, (boolean)true);
            file = parsedUrl == null ? null : JavaScriptDebugProcess.findFile$default(this.debugProcess, parsedUrl, false, null, 6, null);
        } else {
            file = sourceInfo.getFile();
            line = sourceInfo.getLine();
            column = sourceInfo.getColumn();
            parsedUrl = null;
        }
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        Project project = xDebugSession.getProject();
        if (file == null) {
            Url url2 = parsedUrl;
            if (url2 == null) {
                url2 = (Url)Urls.newUnparsable((String)url);
            }
            annotation = new Annotation(url2, line, column);
        } else {
            annotation = line < 0 ? new Annotation(file, line, column, null) : new Annotation(file, line, column, LazyRangeMarkerFactory.getInstance((Project)project).createRangeMarker(file, line, column, false));
        }
        this.tasks.add(new Consumer<ConsolePrinter>(annotation){
            final /* synthetic */ Annotation $annotation;

            public final void consume(ConsolePrinter it) {
                ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                if (consoleView != null) {
                    int annoLine = this.$annotation.getLine();
                    VirtualFile annoFile = this.$annotation.getFile();
                    Annotation existingAnno = annoLine >= 0 && annoFile != null ? it.getLineToAnnotation$intellij_javascript_debugger().find(annoFile, annoLine, this.$annotation.getColumn()) : null;
                    LineAnnotationMaps lineAnnotationMaps = it.getLineToAnnotation$intellij_javascript_debugger();
                    int n = consoleView.getContentSize();
                    Annotation annotation = existingAnno;
                    if (annotation == null) {
                        annotation = this.$annotation;
                    }
                    lineAnnotationMaps.add(n, new LineAnnotation(annotation, 0), existingAnno == null);
                }
            }
            {
                this.$annotation = annotation;
            }
        });
    }

    public static /* bridge */ /* synthetic */ void addFileLink$default(ConsoleMessageBuilder consoleMessageBuilder, String string, int n, int n2, String string2, boolean bl, String string3, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            string3 = null;
        }
        consoleMessageBuilder.addFileLink(string, n, n2, string2, bl, string3);
    }

    public final void indentIn() {
        this.tasks.add(indentIn.1.INSTANCE);
    }

    public final void indentOut() {
        this.tasks.add(indentOut.1.INSTANCE);
    }

    public final void newLine() {
        this.printSystem("\n");
    }

    public final void printIndent() {
        this.tasks.add(new Consumer<ConsolePrinter>(this){
            final /* synthetic */ ConsoleMessageBuilder this$0;

            public final void consume(ConsolePrinter it) {
                ConsolePrinter consolePrinter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)consolePrinter), (String)"it");
                ConsoleMessageBuilder.access$doPrintIndent(this.this$0, consolePrinter);
            }
            {
                this.this$0 = consoleMessageBuilder;
            }
        });
    }

    private final void doPrintIndent(ConsolePrinter it) {
        int l = it.getIndentLevel$intellij_javascript_debugger();
        while (l-- > 0) {
            ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
            if (consoleView == null) {
                Intrinsics.throwNpe();
            }
            consoleView.print("  ", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    public final void groupStart() {
        this.tasks.add(groupStart.1.INSTANCE);
    }

    public final void groupEnd() {
        this.tasks.add(groupEnd.1.INSTANCE);
    }

    private final void printSystem(String text) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.SYSTEM_OUTPUT");
        this.append(text, consoleViewContentType);
    }

    public final void append(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        this.tasks.add(new Consumer<ConsolePrinter>(text, contentType){
            final /* synthetic */ String $text;
            final /* synthetic */ ConsoleViewContentType $contentType;

            public final void consume(ConsolePrinter it) {
                if (this.$text.length() > 1 && StringsKt.contains$default((CharSequence)this.$text, (char)'\n', (boolean)false, (int)2, null)) {
                    it.setHasNewLines$intellij_javascript_debugger(true);
                }
                AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
                decoder.escapeText(this.$text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(this, it){
                    final /* synthetic */ append.1 this$0;
                    final /* synthetic */ ConsolePrinter $it;

                    public final void coloredTextAvailable(@NotNull String textChunk, @NotNull Key<Object> attributes) {
                        Intrinsics.checkParameterIsNotNull((Object)textChunk, (String)"textChunk");
                        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
                        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(attributes);
                        if (consoleViewContentType == null) {
                            consoleViewContentType = this.this$0.$contentType;
                        }
                        ConsoleViewContentType chunkContentType = consoleViewContentType;
                        ConsoleView consoleView = this.$it.getConsoleView$intellij_javascript_debugger();
                        if (consoleView == null) {
                            Intrinsics.throwNpe();
                        }
                        consoleView.print(textChunk, chunkContentType);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$it = consolePrinter;
                    }
                });
            }
            {
                this.$text = string;
                this.$contentType = consoleViewContentType;
            }
        });
    }

    public static /* bridge */ /* synthetic */ void append$default(ConsoleMessageBuilder consoleMessageBuilder, String string, ConsoleViewContentType consoleViewContentType, int n, Object object) {
        if ((n & 2) != 0) {
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType2, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
            consoleViewContentType = consoleViewContentType2;
        }
        consoleMessageBuilder.append(string, consoleViewContentType);
    }

    public final void printBrowserLink(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.tasks.add(new Consumer<ConsolePrinter>(this, url){
            final /* synthetic */ ConsoleMessageBuilder this$0;
            final /* synthetic */ String $url;

            public final void consume(ConsolePrinter it) {
                ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                if (consoleView == null) {
                    Intrinsics.throwNpe();
                }
                consoleView.printHyperlink(ConsoleMessageBuilder.access$getLinkText(this.this$0, this.$url), (HyperlinkInfo)new OpenUrlHyperlinkInfo(this.$url, this.this$0.getDebugProcess().getConnection().getBrowser()));
            }
            {
                this.this$0 = consoleMessageBuilder;
                this.$url = string;
            }
        });
    }

    public final void clear() {
        this.tasks.add(clear.1.INSTANCE);
    }

    public final void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        this.tasks.add(new Consumer<ConsolePrinter>(this, value, expression, contentType){
            final /* synthetic */ ConsoleMessageBuilder this$0;
            final /* synthetic */ Value $value;
            final /* synthetic */ String $expression;
            final /* synthetic */ ConsoleViewContentType $contentType;

            public final void consume(ConsolePrinter it) {
                GlobalEvaluator globalEvaluator = this.this$0.getDebugProcess().getGlobalEvaluator();
                ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                if (consoleView == null) {
                    Intrinsics.throwNpe();
                }
                globalEvaluator.printAndStoreValueToInspect(this.$value, this.$expression, this.$contentType, consoleView);
            }
            {
                this.this$0 = consoleMessageBuilder;
                this.$value = value;
                this.$expression = string;
                this.$contentType = consoleViewContentType;
            }
        });
    }

    public final void print(@NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)consolePrinter), (String)"consolePrinter");
        if (consolePrinter.getIndentLevel$intellij_javascript_debugger() != 0) {
            this.doPrintIndent(consolePrinter);
        }
        Iterable $receiver$iv = this.tasks;
        for (Object element$iv : $receiver$iv) {
            Consumer it = (Consumer)element$iv;
            it.consume((Object)consolePrinter);
        }
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public ConsoleMessageBuilder(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        List list;
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        ConsoleMessageBuilder consoleMessageBuilder = this;
        consoleMessageBuilder.tasks = list = (List)new ArrayList();
    }

    public static final /* synthetic */ void access$doPrintIndent(ConsoleMessageBuilder $this, @NotNull ConsolePrinter it) {
        $this.doPrintIndent(it);
    }

    @NotNull
    public static final /* synthetic */ String access$getLinkText(ConsoleMessageBuilder $this, @NotNull String url) {
        return $this.getLinkText(url);
    }
}

