/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.Annotation;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.LineAnnotation;
import com.intellij.javascript.debugger.LineAnnotationMaps;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.awt.Color;
import java.awt.Graphics;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 J2\u00020\u0001:\u0001JB\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JK\u0010'\u001a\u00020(\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u0002H)2\u001c\u0010+\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u00050,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\u00100J\u0006\u00101\u001a\u00020(J\u0018\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0016J\r\u00106\u001a\u00020(H\u0000\u00a2\u0006\u0002\b7J \u00108\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020(2\u0006\u00104\u001a\u000205H\u0016J(\u0010<\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00162\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0016J\u0012\u0010@\u001a\u0004\u0018\u00010\b2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010B\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0016J\"\u0010C\u001a\u0004\u0018\u00010D2\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\u0006\u0010E\u001a\u00020\u0005H\u0002J\u001a\u0010F\u001a\u0004\u0018\u00010D2\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0016J\u001a\u0010G\u001a\u0004\u0018\u00010D2\u0006\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0016J\b\u0010H\u001a\u00020\u0005H\u0016J\u0010\u0010I\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/intellij/javascript/debugger/ConsolePrinter;", "Lcom/intellij/execution/console/BasicGutterContentProvider;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "isLineRelationshipComputable", "", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Z)V", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "getConsoleView$intellij_javascript_debugger", "()Lcom/intellij/execution/ui/ConsoleView;", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "hasNewLines", "getHasNewLines$intellij_javascript_debugger", "setHasNewLines$intellij_javascript_debugger", "indentLevel", "", "getIndentLevel$intellij_javascript_debugger", "()I", "setIndentLevel$intellij_javascript_debugger", "(I)V", "lastMessage", "", "lineToAnnotation", "Lcom/intellij/javascript/debugger/LineAnnotationMaps;", "getLineToAnnotation$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/LineAnnotationMaps;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock$intellij_javascript_debugger", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "relatedLines", "Lcom/intellij/javascript/debugger/SegmentList;", "addMessage", "", "T", "messageData", "messageDataEquals", "Lkotlin/Function2;", "messageGetter", "Lkotlin/Function1;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "clear", "doAction", "line", "editor", "Lcom/intellij/openapi/editor/Editor;", "doClear", "doClear$intellij_javascript_debugger", "doIsShowSeparatorLine", "document", "Lcom/intellij/openapi/editor/Document;", "documentCleared", "drawIcon", "g", "Ljava/awt/Graphics;", "y", "getConsoleView", "notifyEdited", "getLineStartGutterOverlap", "getStringInfo", "", "toolTip", "getText", "getToolTip", "hasText", "increaseLastMessageRepeatCount", "Companion", "intellij.javascript.debugger"})
public final class ConsolePrinter
extends BasicGutterContentProvider {
    private boolean enabled;
    private Object lastMessage;
    private int indentLevel;
    @NotNull
    private final LineAnnotationMaps lineToAnnotation;
    private final SegmentList relatedLines;
    private boolean hasNewLines;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private static final Key<Object> CONSOLE_INFO_KEY;
    public static final Companion Companion;

    @Nullable
    public final ConsoleView getConsoleView$intellij_javascript_debugger() {
        return this.getConsoleView(false);
    }

    private final ConsoleView getConsoleView(boolean notifyEdited) {
        if (!this.enabled) {
            return null;
        }
        XDebugSession session = this.debugProcess.getSession();
        if (session instanceof XDebugSessionImpl && ((XDebugSessionImpl)session).getSessionTab() == null) {
            return null;
        }
        return this.debugProcess.getJSConsoleView(notifyEdited);
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final int getIndentLevel$intellij_javascript_debugger() {
        return this.indentLevel;
    }

    public final void setIndentLevel$intellij_javascript_debugger(int n) {
        this.indentLevel = n;
    }

    @NotNull
    public final LineAnnotationMaps getLineToAnnotation$intellij_javascript_debugger() {
        return this.lineToAnnotation;
    }

    public final boolean getHasNewLines$intellij_javascript_debugger() {
        return this.hasNewLines;
    }

    public final void setHasNewLines$intellij_javascript_debugger(boolean bl) {
        this.hasNewLines = bl;
    }

    @NotNull
    public final ReentrantReadWriteLock getLock$intellij_javascript_debugger() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentCleared(@NotNull Editor editor) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.doClear$intellij_javascript_debugger();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            ConsoleView consoleView = this.getConsoleView(true);
            if (consoleView != null) {
                consoleView.clear();
            }
            this.doClear$intellij_javascript_debugger();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public final void doClear$intellij_javascript_debugger() {
        this.lineToAnnotation.clear();
        this.relatedLines.clear();
        this.debugProcess.consoleCleared();
        this.hasNewLines = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void addMessage(T messageData, @NotNull Function2<Object, Object, Boolean> messageDataEquals, @NotNull Function1<? super T, ? extends ConsoleMessage> messageGetter) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkParameterIsNotNull(messageDataEquals, (String)"messageDataEquals");
        Intrinsics.checkParameterIsNotNull(messageGetter, (String)"messageGetter");
        ConsoleView consoleView = this.getConsoleView(true);
        if (consoleView == null) {
            JavaScriptDebugProcessKt.getLOG().debug("message is missed");
            return;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            readLock.unlock();
        }
        Lock lock = reentrantReadWriteLock.writeLock();
        ((ReentrantReadWriteLock.WriteLock)lock).lock();
        try {
            int n7;
            if (((Boolean)messageDataEquals.invoke(this.lastMessage, messageData)).booleanValue()) {
                this.increaseLastMessageRepeatCount(consoleView);
                n7 = 1;
            } else {
                n7 = 0;
            }
            n6 = n7;
        }
        finally {
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                n = n3++;
                readLock.lock();
            }
            ((ReentrantReadWriteLock.WriteLock)lock).unlock();
        }
        int messageIsDuplicated = n6;
        if (messageIsDuplicated == 0) {
            ConsoleMessage message = (ConsoleMessage)messageGetter.invoke(messageData);
            ConsoleMessageBuilder messageBuilder = new ConsoleMessageBuilder(this.debugProcess);
            message.print(messageBuilder);
            ReentrantReadWriteLock reentrantReadWriteLock2 = this.lock;
            lock = reentrantReadWriteLock2.readLock();
            n6 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
            n3 = 0;
            n2 = n6;
            while (n3 < n2) {
                n = n3++;
                ((ReentrantReadWriteLock.ReadLock)lock).unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock2.writeLock();
            writeLock.lock();
            try {
                if (((Boolean)messageDataEquals.invoke(this.lastMessage, messageData)).booleanValue()) {
                    this.increaseLastMessageRepeatCount(consoleView);
                } else {
                    int startOffset = consoleView.getContentSize();
                    this.hasNewLines = false;
                    try {
                        messageBuilder.print(this);
                    }
                    finally {
                        boolean markAsRelatedLines = this.hasNewLines;
                        this.hasNewLines = false;
                        if (markAsRelatedLines) {
                            int endOffset = consoleView.getContentSize();
                            this.relatedLines.add(startOffset, endOffset);
                        }
                    }
                    this.lastMessage = messageData;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n8 = n6;
                while (n < n8) {
                    int n9 = n++;
                    ((ReentrantReadWriteLock.ReadLock)lock).lock();
                }
                writeLock.unlock();
            }
        }
    }

    private final void increaseLastMessageRepeatCount(ConsoleView consoleView) {
        boolean bl;
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.lock.isWriteLockedByCurrentThread());
        Pair<Integer, LineAnnotation> annotation = this.lineToAnnotation.getLast();
        if (annotation == null) {
            JavaScriptDebugProcessKt.getLOG().error("No last annotation");
            return;
        }
        LineAnnotation lineAnnotation = (LineAnnotation)annotation.getSecond();
        lineAnnotation.setRepeatCount(lineAnnotation.getRepeatCount() + 1);
        int shownRepeatCount = lineAnnotation.getRepeatCount() + 1;
        if (shownRepeatCount < 10) {
            return;
        }
        int newRepeatCountLength = Integer.toString(shownRepeatCount).length();
        if (newRepeatCountLength <= Integer.toString(shownRepeatCount - 1).length()) {
            return;
        }
        int excess = newRepeatCountLength + 1 - 2;
        boolean bl2 = bl = excess > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int version = this.lineToAnnotation.getVersion();
        int consoleOffset = ((Number)annotation.getFirst()).intValue();
        ApplicationManager.getApplication().invokeLater(new Runnable(this, consoleView, version, consoleOffset, excess){
            final /* synthetic */ ConsolePrinter this$0;
            final /* synthetic */ ConsoleView $consoleView;
            final /* synthetic */ int $version;
            final /* synthetic */ int $consoleOffset;
            final /* synthetic */ int $excess;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if ((ConsoleViewImpl)this.$consoleView == null) {
                    return;
                }
                ReentrantReadWriteLock.WriteLock writeLock = this.this$0.getLock$intellij_javascript_debugger().writeLock();
                if (writeLock.tryLock(50L, TimeUnit.MILLISECONDS)) {
                    try {
                        if (this.$version != this.this$0.getLineToAnnotation$intellij_javascript_debugger().getVersion()) {
                            return;
                        }
                        ((ConsoleViewImpl)this.$consoleView).flushDeferredText();
                        Editor editor = ((ConsoleViewImpl)this.$consoleView).getEditor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"consoleView.editor");
                        Document document = editor.getDocument();
                        int lineNumber = document.getLineNumber(this.$consoleOffset);
                        int lineStartOffset = document.getLineStartOffset(lineNumber);
                        Document document2 = document;
                        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                        int missed = this.$excess - StringUtil.countChars((CharSequence)document2.getImmutableCharSequence(), (char)' ', (int)lineStartOffset, (boolean)true);
                        if (missed <= 0) return;
                        document.insertString(lineStartOffset, (CharSequence)StringUtil.repeat((String)" ", (int)missed));
                        return;
                    }
                    finally {
                        writeLock.unlock();
                    }
                } else {
                    ApplicationManager.getApplication().invokeLater((Runnable)this);
                }
            }
            {
                this.this$0 = $outer;
                this.$consoleView = $captured_local_variable$1;
                this.$version = $captured_local_variable$2;
                this.$consoleOffset = $captured_local_variable$3;
                this.$excess = $captured_local_variable$4;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasText() {
        boolean bl;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            bl = !this.lineToAnnotation.isEmpty();
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @Nullable
    public String getText(int line, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.getStringInfo(line, editor, false);
    }

    @Nullable
    public String getToolTip(int line, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.getStringInfo(line, editor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getStringInfo(int line, Editor editor, boolean toolTip) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            String name;
            Object object = this.lineToAnnotation.get(line, editor);
            if (object == null || (object = ((LineAnnotation)object).getAnno()) == null) {
                String string = null;
                return string;
            }
            Object annotation = object;
            VirtualFile file = ((Annotation)annotation).getFile();
            if (toolTip) {
                if (((Annotation)annotation).getUrl() != null) {
                    String string = ((Annotation)annotation).getUrl().trimParameters().toDecodedForm();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"annotation.url.trimParameters().toDecodedForm()");
                    name = string;
                } else {
                    VirtualFile virtualFile = file;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    XDebugSession xDebugSession = this.debugProcess.getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                    String string = JsFileUtil.getShortenedFilePath(virtualFile, xDebugSession.getProject());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JsFileUtil.getShortenedF\u2026gProcess.session.project)");
                    name = string;
                }
            } else {
                if (((Annotation)annotation).getUrl() == null) {
                    boolean bl;
                    boolean bl2 = bl = file != null;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    VirtualFile virtualFile = file;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    String string = virtualFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file!!.name");
                    name = string;
                } else {
                    String string = ((Annotation)annotation).getUrl().trimParameters().toDecodedForm();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"annotation.url.trimParameters().toDecodedForm()");
                    name = string;
                }
                String string = StringUtil.trimMiddle((String)name, (int)100);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.trimMiddle(name, 100)");
                name = string;
            }
            String string = ((Annotation)annotation).getLine() < 0 ? name : name + ':' + (((Annotation)annotation).getLine() + 1);
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(int line, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Annotation currentAnnotation = null;
        VirtualFile newFile = null;
        RangeMarker newPosition = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Annotation annotation;
            LineAnnotation lineAnnotation = this.lineToAnnotation.get(line, editor);
            currentAnnotation = annotation = lineAnnotation != null ? lineAnnotation.getAnno() : null;
            if (annotation != null) {
                OpenFileDescriptor descriptor;
                VirtualFile file = annotation.getFile();
                if (file == null) {
                    Url url = annotation.getUrl();
                    if (url == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((file = this.debugProcess.findFileOrAny(url)) == null) {
                        this.debugProcess.getSession().reportError("Cannot navigate");
                        return;
                    }
                    newFile = file;
                }
                if (annotation.getPosition() == null || annotation.getLine() < 0) {
                    XDebugSession xDebugSession = this.debugProcess.getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                    descriptor = new OpenFileDescriptor(xDebugSession.getProject(), file, annotation.getLine(), annotation.getColumn());
                    newPosition = descriptor.getRangeMarker();
                } else {
                    XDebugSession xDebugSession = this.debugProcess.getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                    Project project = xDebugSession.getProject();
                    RangeMarker rangeMarker = annotation.getPosition();
                    if (rangeMarker == null) {
                        Intrinsics.throwNpe();
                    }
                    descriptor = new OpenFileDescriptor(project, file, rangeMarker.getStartOffset());
                }
                descriptor.navigate(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        if (newFile != null || newPosition != null) {
            int n;
            reentrantReadWriteLock = this.lock;
            readLock = reentrantReadWriteLock.readLock();
            int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                n = n3++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Annotation anno;
                LineAnnotation lineAnnotation = this.lineToAnnotation.get(line, editor);
                Annotation annotation = anno = lineAnnotation != null ? lineAnnotation.getAnno() : null;
                if (anno != null && Intrinsics.areEqual((Object)anno, (Object)currentAnnotation)) {
                    if (newFile != null) {
                        anno.setFile(newFile);
                    }
                    if (newPosition != null) {
                        anno.setPosition(newPosition);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2;
                while (n < n5) {
                    int n6 = n++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawIcon(int line, @NotNull Graphics g, int y, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            if (super.drawIcon(line, g, y, editor)) {
                boolean bl = true;
                return bl;
            }
            LineAnnotation annotation = this.lineToAnnotation.get(line, editor);
            if (annotation == null || annotation.getRepeatCount() <= 0) {
                boolean bl = false;
                return bl;
            }
            String text = String.valueOf(annotation.getRepeatCount() + 1);
            g.setColor((Color)JBColor.LIGHT_GRAY);
            g.drawString(text, 3, y);
            boolean bl = true;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIsShowSeparatorLine(int line, @NotNull Editor editor, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        int lineStartOffset = document.getLineStartOffset(line);
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            int rangeIndex = this.relatedLines.getRangeIndex(lineStartOffset);
            if (rangeIndex != -1) {
                boolean bl = !this.relatedLines.rangeContains(rangeIndex, document.getLineStartOffset(line + 1));
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return this.isLineRelationshipComputable;
    }

    public int getLineStartGutterOverlap(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return EditorUtil.getSpaceWidth((int)0, (Editor)editor) * 3;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public ConsolePrinter(@NotNull JavaScriptDebugProcess<?> debugProcess, boolean isLineRelationshipComputable) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(isLineRelationshipComputable);
        this.debugProcess = debugProcess;
        this.enabled = true;
        this.lineToAnnotation = new LineAnnotationMaps();
        this.relatedLines = new SegmentList();
        this.lock = new ReentrantReadWriteLock();
    }

    static {
        Companion = new Companion(null);
        CONSOLE_INFO_KEY = new Key("CONSOLE_INFO_KEY");
        ConsoleViewContentType.registerNewConsoleViewType(CONSOLE_INFO_KEY, (TextAttributesKey)ConsoleViewContentType.LOG_EXPIRED_ENTRY);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/ConsolePrinter$Companion;", "", "()V", "CONSOLE_INFO_KEY", "Lcom/intellij/openapi/util/Key;", "getCONSOLE_INFO_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final Key<Object> getCONSOLE_INFO_KEY() {
            return CONSOLE_INFO_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

