/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J<\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "", "canSetRemoteUrl", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findFile", "url", "Lcom/intellij/util/Url;", "findByName", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "getRemoteUrls", "", "isOnlySourceMappedBreakpoints", "intellij.javascript.debugger"})
public interface DebuggableFileFinder {
    @Nullable
    public VirtualFile findFile(@NotNull Url var1, @NotNull Project var2, boolean var3, @Nullable String var4, @Nullable Script var5);

    @Nullable
    public Navigatable findNavigatable(@NotNull Url var1, @NotNull Project var2);

    public boolean canSetRemoteUrl(@NotNull VirtualFile var1, @NotNull Project var2);

    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile var1);

    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile var1);

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static /* bridge */ /* synthetic */ VirtualFile findFile$default(DebuggableFileFinder debuggableFileFinder, Url url, Project project, boolean bl, String string, Script script, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findFile");
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            if ((n & 0x10) != 0) {
                script = null;
            }
            return debuggableFileFinder.findFile(url, project, bl, string, script);
        }

        @Nullable
        public static Navigatable findNavigatable(DebuggableFileFinder $this, @NotNull Url url, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (Navigatable)JsFileUtil.createNavigatable(project, DefaultImpls.findFile$default($this, url, project, false, null, null, 28, null));
        }

        public static boolean canSetRemoteUrl(DebuggableFileFinder $this, @NotNull VirtualFile file, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return false;
        }

        public static boolean isOnlySourceMappedBreakpoints(DebuggableFileFinder $this, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            FileType fileType = file.getFileType();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"file.fileType");
            JavaScriptDebugAware debugAware = JavaScriptDebugAware.Companion.getBreakpointAware(fileType);
            return debugAware != null && debugAware.isOnlySourceMappedBreakpoints();
        }
    }
}

