/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import com.jetbrains.plugins.webDeployment.actions.PublishedFileBrowserUrlProvider;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

class DeploymentServerFileUrlMapper
extends FileUrlMapper {
    DeploymentServerFileUrlMapper() {
    }

    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file, @NotNull Project project, @Nullable String currentAuthority) {
        if (file == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)PublishedFileBrowserUrlProvider.getUrl((Project)project, (VirtualFile)file));
        if (list == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(2);
        }
        return list;
    }

    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        VirtualFile result2;
        if (url == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DeploymentServerFileUrlMapper.$$$reportNull$$$0(4);
        }
        if (url.isInLocalFileSystem()) {
            return null;
        }
        List servers = WebServersConfigManager.getInstance((Project)project).getServers(false);
        String authority = url.getAuthority();
        if (StringUtil.isEmpty((String)authority) || servers.isEmpty()) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        WebServerConfig defaultServer = publishConfig.findDefaultServer();
        VirtualFile virtualFile = result2 = defaultServer == null || defaultServer.validateUrl() != null ? null : DeploymentServerFileUrlMapper.urlToFile(url, defaultServer, authority, publishConfig);
        if (result2 == null) {
            TreeMap sortedServers = new TreeMap(Comparator.reverseOrder());
            for (WebServerConfig server : servers) {
                if (server == defaultServer || server.validateUrl() != null) continue;
                sortedServers.put(server.getUrl(), server);
            }
            for (WebServerConfig server : sortedServers.values()) {
                result2 = DeploymentServerFileUrlMapper.urlToFile(url, server, authority, publishConfig);
                if (result2 == null) continue;
                return result2;
            }
        }
        return result2;
    }

    @Nullable
    private static VirtualFile urlToFile(Url url, WebServerConfig server, String authority, PublishConfig publishConfig) {
        DeploymentPathMapping mapping;
        URL javaUrl;
        try {
            javaUrl = new URL(server.getUrl());
            if (!authority.equalsIgnoreCase(javaUrl.getAuthority())) {
                return null;
            }
        }
        catch (MalformedURLException ignored) {
            return null;
        }
        String path = url.getPath();
        if (!StringUtil.isEmpty((String)javaUrl.getPath())) {
            if (!path.startsWith(javaUrl.getPath())) {
                return null;
            }
            path = path.substring(javaUrl.getPath().length());
        }
        if ((mapping = publishConfig.getNearestMappingForWeb(path, false, true, false, (Mappable)server)) != null) {
            VirtualFile parent = LocalFileFinder.findFile((String)mapping.getLocalPath());
            String pathRemainderForWeb = parent == null ? null : mapping.getPathRemainderForWeb(path);
            return pathRemainderForWeb == null ? null : parent.findFileByRelativePath(pathRemainderForWeb);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/DeploymentServerFileUrlMapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/DeploymentServerFileUrlMapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

