/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.locationResolving.JSFileUrlMappings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.wip.WipScript;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J4\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0004J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/debugger/JSFileFinderBase;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "()V", "fileMappings", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "doFindFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findByName", "", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "findFile", "getCachedRemoteUrls", "", "file", "isFileMatchingScript", "setFileMappings", "", "map", "intellij.javascript.debugger"})
public abstract class JSFileFinderBase
implements DebuggableFileFinder {
    private volatile JSFileUrlMappings fileMappings = new JSFileUrlMappings();

    @Override
    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.fileMappings.findFile(url, !findByName2, sourceContent, script, (Function0<? extends VirtualFile>)((Function0)new Function0<VirtualFile>(this, url, project, findByName2, sourceContent, script){
            final /* synthetic */ JSFileFinderBase this$0;
            final /* synthetic */ Url $url;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $findByName;
            final /* synthetic */ String $sourceContent;
            final /* synthetic */ Script $script;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final VirtualFile invoke() {
                void var1_1;
                VirtualFile result2 = this.this$0.doFindFile(this.$url, this.$project, this.$findByName, this.$sourceContent, this.$script);
                if (result2 != null && this.$script != null && !JSFileFinderBase.access$isFileMatchingScript(this.this$0, result2, this.$script)) {
                    result2 = null;
                }
                return var1_1;
            }
            {
                this.this$0 = jSFileFinderBase;
                this.$url = url;
                this.$project = project;
                this.$findByName = bl;
                this.$sourceContent = string;
                this.$script = script;
                super(0);
            }
        }));
    }

    @Nullable
    protected VirtualFile doFindFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return FileResolverByContentKt.resolveFileBySourceUrl(project, url, sourceContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isFileMatchingScript(VirtualFile file, Script script) {
        if (file.isDirectory()) {
            return false;
        }
        if (script.getLine() == 0) {
            Closeable closeable = new BufferedReader(new InputStreamReader(file.getInputStream(), file.getCharset()));
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)closeable;
                int c = reader.read();
                int count = 0;
                int newLineCount = 0;
                while (c != -1) {
                    ++count;
                    if (c == 10) {
                        ++newLineCount;
                    }
                    c = reader.read();
                }
                if (script.getEndLine() < newLineCount || script.getEndLine() > newLineCount + 2) {
                    JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file.getCanonicalPath() + " found by url " + script.getUrl() + ": script.endLine = " + script.getEndLine() + ", file.endLine = " + newLineCount);
                    boolean bl = false;
                    return bl;
                }
                int sourceParam = ("\n//# sourceURL=" + script.getUrl()).length();
                if (script instanceof WipScript && ((WipScript)script).getLength() != count && ((WipScript)script).getLength() != count + 66 && ((WipScript)script).getLength() != count + 63 && (!((WipScript)script).getHasSourceURL() || ((WipScript)script).getLength() - sourceParam != count && ((WipScript)script).getLength() - sourceParam + 1 != count)) {
                    JavaScriptDebugProcessKt.getLOG().debug("Incorrect file " + file.getCanonicalPath() + " found by url " + script.getUrl() + ": script.length = " + ((WipScript)script).getLength() + ", " + "file.length = " + file.getLength());
                    boolean bl = false;
                    return bl;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return true;
    }

    @Nullable
    protected final List<Url> getCachedRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.fileMappings.getCachedRemoteUrls(file);
    }

    public final void setFileMappings(@NotNull JSFileUrlMappings map) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        this.fileMappings = map;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.findNavigatable(this, url, project);
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.canSetRemoteUrl(this, file, project);
    }

    @Override
    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints(this, file);
    }

    public static final /* synthetic */ boolean access$isFileMatchingScript(JSFileFinderBase $this, @NotNull VirtualFile file, @NotNull Script script) {
        return $this.isFileMatchingScript(file, script);
    }
}

