/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JF\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\fH&J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0014J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100$2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "getBrowserFamily", "()Lcom/intellij/ide/browsers/BrowserFamily;", "requiresExtension", "", "getRequiresExtension", "()Z", "checkAvailability", "", "project", "Lcom/intellij/openapi/project/Project;", "createDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "initialUrl", "Lcom/intellij/util/Url;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "usePreliminaryPage", "isBrowserSupported", "isPreferredEngineForFile", "file", "Lcom/intellij/psi/PsiFile;", "prepareDebugger", "Lorg/jetbrains/concurrency/Promise;", "Companion", "intellij.javascript.debugger"})
public abstract class JavaScriptDebugEngine {
    private final boolean requiresExtension = true;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract JavaScriptDebugProcess<VmConnection<?>> createDebugProcess(@NotNull XDebugSession var1, @NotNull WebBrowser var2, @NotNull DebuggableFileFinder var3, @Nullable Url var4, @Nullable ExecutionResult var5, boolean var6);

    @NotNull
    public final Promise<Unit> prepareDebugger(@NotNull Project project, @NotNull WebBrowser browser) {
        Promise promise2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        if (this.getRequiresExtension()) {
            Promise promise3 = BrowserConnectionManager.getInstance().ensureExtensionInstalled(browser, project).then(new Function<T, SUB_RESULT>(browser, project){
                final /* synthetic */ WebBrowser $browser;
                final /* synthetic */ Project $project;

                public final void fun(Object it) {
                    BrowserConnectionManager.getInstance().launchBrowser(this.$browser, this.$project);
                }
                {
                    this.$browser = webBrowser;
                    this.$project = project;
                }
            });
            promise2 = promise3;
            Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"BrowserConnectionManager\u2026owser(browser, project) }");
        } else {
            promise2 = Promises.resolvedPromise();
        }
        return promise2;
    }

    @Nullable
    public WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().getFirstBrowserOrNull(this.getBrowserFamily());
    }

    @NotNull
    public abstract BrowserFamily getBrowserFamily();

    public void checkAvailability(@NotNull Project project) throws RuntimeConfigurationError {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
    }

    public boolean isBrowserSupported(@NotNull WebBrowser browser) {
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        return browser.getFamily() == this.getBrowserFamily();
    }

    protected boolean isPreferredEngineForFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return false;
    }

    public boolean getRequiresExtension() {
        return this.requiresExtension;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugEngine$Companion;", "", "()V", "findByBrowser", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "useExtension", "", "findByBrowserIdOrName", "Lcom/intellij/openapi/util/Pair;", "browserIdOrName", "", "getPreferredBrowser", "file", "Lcom/intellij/psi/PsiFile;", "intellij.javascript.debugger"})
    public static final class Companion {
        @JvmOverloads
        @Nullable
        public final Pair<JavaScriptDebugEngine, WebBrowser> findByBrowserIdOrName(@NotNull String browserIdOrName, boolean useExtension) {
            Pair pair;
            Intrinsics.checkParameterIsNotNull((Object)browserIdOrName, (String)"browserIdOrName");
            WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(browserIdOrName);
            if (browser == null) {
                int n = 0;
                JavaScriptDebugEngine[] $receiver$iv = JavaScriptDebugEngineKt.getEngines();
                int n2 = $receiver$iv.length;
                if (n < n2) {
                    JavaScriptDebugEngine file$iv = $receiver$iv[n];
                    JavaScriptDebugEngine engine = file$iv;
                    if (JavaScriptDebugEngineKt.access$checkByBrowserIdOrName(engine, browserIdOrName) && engine.getRequiresExtension() == useExtension) {
                        WebBrowser webBrowser = engine.getBrowser();
                        if (webBrowser != null) {
                            WebBrowser webBrowser2;
                            WebBrowser it = webBrowser2 = webBrowser;
                            return Pair.create((Object)engine, (Object)it);
                        }
                    }
                    return null;
                }
                return null;
            }
            JavaScriptDebugEngine javaScriptDebugEngine = this.findByBrowser(browser, useExtension);
            if (javaScriptDebugEngine != null) {
                JavaScriptDebugEngine javaScriptDebugEngine2;
                JavaScriptDebugEngine it = javaScriptDebugEngine2 = javaScriptDebugEngine;
                pair = Pair.create((Object)it, (Object)browser);
            } else {
                pair = null;
            }
            return pair;
        }

        @JvmOverloads
        @Nullable
        public static /* bridge */ /* synthetic */ Pair findByBrowserIdOrName$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.findByBrowserIdOrName(string, bl);
        }

        @JvmOverloads
        @Nullable
        public final Pair<JavaScriptDebugEngine, WebBrowser> findByBrowserIdOrName(@NotNull String browserIdOrName) {
            return com.intellij.javascript.debugger.JavaScriptDebugEngine$Companion.findByBrowserIdOrName$default(this, browserIdOrName, false, 2, null);
        }

        @JvmOverloads
        @Nullable
        public final JavaScriptDebugEngine findByBrowser(@NotNull WebBrowser browser, boolean useExtension) {
            JavaScriptDebugEngine javaScriptDebugEngine;
            block4: {
                JavaScriptDebugEngine javaScriptDebugEngine2;
                JavaScriptDebugEngine it;
                JavaScriptDebugEngine[] javaScriptDebugEngineArray;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
                    for (JavaScriptDebugEngine javaScriptDebugEngine3 : javaScriptDebugEngineArray = JavaScriptDebugEngineKt.getEngines()) {
                        it = javaScriptDebugEngine3;
                        if (!(Intrinsics.areEqual((Object)it.getBrowser(), (Object)browser) && it.getRequiresExtension() == useExtension)) continue;
                        javaScriptDebugEngine2 = javaScriptDebugEngine3;
                        break block3;
                    }
                    javaScriptDebugEngine2 = javaScriptDebugEngine = null;
                }
                if (javaScriptDebugEngine2 == null) {
                    for (JavaScriptDebugEngine javaScriptDebugEngine3 : javaScriptDebugEngineArray = JavaScriptDebugEngineKt.getEngines()) {
                        it = javaScriptDebugEngine3;
                        if (!(it.isBrowserSupported(browser) && it.getRequiresExtension() == useExtension)) continue;
                        javaScriptDebugEngine = javaScriptDebugEngine3;
                        break block4;
                    }
                    javaScriptDebugEngine = null;
                }
            }
            return javaScriptDebugEngine;
        }

        @JvmOverloads
        @Nullable
        public static /* bridge */ /* synthetic */ JavaScriptDebugEngine findByBrowser$default(Companion companion, WebBrowser webBrowser, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.findByBrowser(webBrowser, bl);
        }

        @JvmOverloads
        @Nullable
        public final JavaScriptDebugEngine findByBrowser(@NotNull WebBrowser browser) {
            return com.intellij.javascript.debugger.JavaScriptDebugEngine$Companion.findByBrowser$default(this, browser, false, 2, null);
        }

        @Nullable
        public final WebBrowser getPreferredBrowser(@NotNull PsiFile file) {
            JavaScriptDebugEngine javaScriptDebugEngine;
            block1: {
                JavaScriptDebugEngine[] javaScriptDebugEngineArray;
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                for (JavaScriptDebugEngine javaScriptDebugEngine2 : javaScriptDebugEngineArray = JavaScriptDebugEngineKt.getEngines()) {
                    JavaScriptDebugEngine it = javaScriptDebugEngine2;
                    if (!it.isPreferredEngineForFile(file)) continue;
                    javaScriptDebugEngine = javaScriptDebugEngine2;
                    break block1;
                }
                javaScriptDebugEngine = null;
            }
            return javaScriptDebugEngine != null ? javaScriptDebugEngine.getBrowser() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

