/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FilePathRegExpCreator;
import com.intellij.javascript.debugger.JSLineBreakpointManagerBase;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManagerKt;
import com.intellij.javascript.debugger.LineVisitor;
import com.intellij.javascript.debugger.PsiVisitorKt;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptRegExpBreakpointTarget;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0002>?B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J.\u0010\u0018\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000eH\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u001b2\u0006\u0010\u001f\u001a\u00020\u0007J\"\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020!H\u0002J<\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u001c\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J$\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u001b2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u0010/\u001a\u00020\u0017J`\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001022\b\b\u0002\u00103\u001a\u00020\u000eJ\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u00106\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u00107\u001a\u00020\u00172\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0017J\u0016\u00109\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u00107\u001a\u00020\u0017J0\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+J\u001a\u0010<\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010$\u001a\u00020%J\u0010\u0010=\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0014R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "Lcom/intellij/javascript/debugger/JSLineBreakpointManagerBase;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "anyFirstLineBreakpoints", "Lcom/intellij/util/containers/ConcurrentList;", "Lorg/jetbrains/debugger/Breakpoint;", "kotlin.jvm.PlatformType", "beforeBreakpointRemoved", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "disable", "", "checkDuplicates", "newTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "location", "Lorg/jetbrains/debugger/Location;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "createNameRegExp", "", "createTarget", "isTemporary", "doRunToLocation", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "findBreakpoints", "vmBreakpoint", "findExisting", "Lorg/jetbrains/debugger/ScriptRegExpBreakpointTarget;", "findRawLocationsFromExactPosition", "Lorg/jetbrains/debugger/SourceInfo;", "vm", "Lorg/jetbrains/debugger/Vm;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "scriptUrl", "Lcom/intellij/util/Url;", "findTopFirstLineBreakpoints", "context", "Lorg/jetbrains/debugger/SuspendContext;", "scriptName", "getActualLocations", "outSourceMappedLocationFound", "Lcom/intellij/openapi/util/Ref;", "keepEmptySourceMappedLocation", "isAnyFirstLineBreakpoint", "isUseScriptIdTarget", "setAnyFirstLineBreakpoint", "regExp", "condition", "setMeteorAnyClientScriptBreakpointIfNeed", "sourceMapFound", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "sourceMapNotFound", "unregisterAnyFirstLineBreakpoint", "Companion", "VmBreakpointLocation", "intellij.javascript.debugger"})
public final class JavaScriptLineBreakpointManager
extends JSLineBreakpointManagerBase {
    private final ConcurrentList<Breakpoint> anyFirstLineBreakpoints;
    @NotNull
    private static final Key<Set<XLineBreakpoint<?>>> ACTUAL_LOCATIONS_NOT_FOUND_KEY;
    public static final Companion Companion;

    @Override
    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return this.anyFirstLineBreakpoints.contains((Object)breakpoint);
    }

    @Override
    protected void unregisterAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        this.anyFirstLineBreakpoints.remove((Object)breakpoint);
    }

    public final void setAnyFirstLineBreakpoint(@NotNull Vm vm, @NotNull String regExp, @Nullable String condition) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        BreakpointManager breakpointManager = vm.getBreakpointManager();
        JavaScriptDebugProcessKt.getLOG().assertTrue(breakpointManager.getRegExpBreakpointSupported());
        int n = 0;
        Url url = null;
        String string = condition;
        BreakpointManager.SetBreakpointResult setBreakpointResult = BreakpointManager.DefaultImpls.setBreakpoint$default((BreakpointManager)breakpointManager, (BreakpointTarget)((BreakpointTarget)new ScriptRegExpBreakpointTarget(regExp, null, 2, null)), (int)0, (int)0, url, (String)string, (int)n, (int)36, null);
        if (setBreakpointResult instanceof BreakpointManager.BreakpointCreated) {
            this.anyFirstLineBreakpoints.add((Object)((BreakpointManager.BreakpointCreated)setBreakpointResult).getBreakpoint());
        }
    }

    public static /* bridge */ /* synthetic */ void setAnyFirstLineBreakpoint$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, Vm vm, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        javaScriptLineBreakpointManager.setAnyFirstLineBreakpoint(vm, string, string2);
    }

    public final void setMeteorAnyClientScriptBreakpointIfNeed(@NotNull Vm vm, @NotNull String regExp) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            if (breakpointTarget == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.ScriptRegExpBreakpointTarget");
            }
            if (!Intrinsics.areEqual((Object)((ScriptRegExpBreakpointTarget)breakpointTarget).toString(), (Object)regExp)) continue;
            return;
        }
        JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this, vm, regExp, null, 4, null);
    }

    @Override
    protected void beforeBreakpointRemoved(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        if (!disable) {
            for (Vm vm : this.getDebugProcess$intellij_javascript_debugger().getCollectVMs()) {
                Set value = (Set)vm.getUserData(ACTUAL_LOCATIONS_NOT_FOUND_KEY);
                if (value == null || !value.remove(breakpoint) || !value.isEmpty()) continue;
                vm.putUserData(ACTUAL_LOCATIONS_NOT_FOUND_KEY, null);
            }
        }
    }

    private final boolean isUseScriptIdTarget(Location location) {
        Url url = location.getUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
        if (Intrinsics.areEqual((Object)url.getScheme(), (Object)"vm")) {
            return true;
        }
        if (this.getDebugProcess$intellij_javascript_debugger().getScriptsCanBeReloaded()) {
            return false;
        }
        if (this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem()) {
            return true;
        }
        if (!this.anyFirstLineBreakpoints.isEmpty()) {
            String scriptUrl = location.getUrl().toExternalForm();
            for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
                if (!(breakpoint.getTarget() instanceof ScriptRegExpBreakpointTarget)) continue;
                String string = breakpoint.getTarget().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"breakpoint.target.toString()");
                String string2 = scriptUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"scriptUrl");
                if (!JavaScriptLineBreakpointManagerKt.match(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> breakpoint, @NotNull BreakpointManager breakpointManager, @NotNull Location location, boolean isTemporary) {
        Script script;
        block7: {
            block8: {
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                script = location.getScript();
                if (isTemporary) break block7;
                if (script != null && this.isUseScriptIdTarget(location)) {
                    return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
                }
                if (script != null) {
                    String string = script.getUrl().toExternalForm();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.url.toExternalForm()");
                    charSequence = string;
                    if (!(charSequence.length() == 0)) {
                        return (BreakpointTarget)new BreakpointTarget.ScriptName(script.getUrl().toExternalForm());
                    }
                }
                if (!breakpointManager.getRegExpBreakpointSupported()) break block7;
                Url url = location.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
                if (url.isInLocalFileSystem()) break block8;
                Url url2 = location.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"location.url");
                charSequence = url2.getAuthority();
                if (charSequence == null || charSequence.length() == 0) break block7;
            }
            return (BreakpointTarget)new ScriptRegExpBreakpointTarget(this.createNameRegExp(location), this.getDebugProcess$intellij_javascript_debugger().getBreakpointLanguageHint(breakpoint, location));
        }
        if (script == null) {
            return (BreakpointTarget)new BreakpointTarget.ScriptName(location.getUrl().toExternalForm());
        }
        return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
    }

    @Override
    @Nullable
    protected Breakpoint checkDuplicates(@NotNull BreakpointTarget newTarget, @NotNull Location location, @NotNull BreakpointManager breakpointManager) {
        Intrinsics.checkParameterIsNotNull((Object)newTarget, (String)"newTarget");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
        if (location.getScript() != null && newTarget instanceof ScriptRegExpBreakpointTarget) {
            Breakpoint breakpoint = this.findExisting(breakpointManager, location, (ScriptRegExpBreakpointTarget)newTarget);
            if (breakpoint != null) {
                Breakpoint breakpoint2;
                Breakpoint it = breakpoint2 = breakpoint;
                return it;
            }
        }
        return super.checkDuplicates(newTarget, location, breakpointManager);
    }

    private final Breakpoint findExisting(BreakpointManager breakpointManager, Location location, ScriptRegExpBreakpointTarget newTarget) {
        for (Breakpoint breakpoint : breakpointManager.getBreakpoints()) {
            BreakpointTarget target = breakpoint.getTarget();
            if (!(target instanceof ScriptRegExpBreakpointTarget) || this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != location.getLine() || breakpoint.getColumn() != -1 && breakpoint.getColumn() != location.getColumn()) continue;
            String string = newTarget.toString();
            String string2 = target.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.toString()");
            if (!StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            return breakpoint;
        }
        return null;
    }

    private final String createNameRegExp(Location location) {
        CharSequence charSequence;
        boolean useCaseSensitiveUrl;
        String property = System.getProperty("js.debug.url.case.sensitive");
        boolean bl = property == null ? SystemInfoRt.isFileSystemCaseSensitive && !this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem() : (useCaseSensitiveUrl = (charSequence = (CharSequence)property).length() == 0 || Boolean.parseBoolean((String)(charSequence = property)));
        if (this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem() && this.getDebugProcess$intellij_javascript_debugger() instanceof FilePathRegExpCreator) {
            FilePathRegExpCreator filePathRegExpCreator = (FilePathRegExpCreator)((Object)this.getDebugProcess$intellij_javascript_debugger());
            Url url = location.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
            return filePathRegExpCreator.createFilePathRegExp(url, false);
        }
        return JavaScriptLineBreakpointManagerKt.access$createUrlRegExp(location, useCaseSensitiveUrl);
    }

    public final void sourceMapNotFound(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        ((Set)vm.putUserDataIfAbsent(ACTUAL_LOCATIONS_NOT_FOUND_KEY, (Object)ContainerUtil.newConcurrentSet())).add(breakpoint);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<VmBreakpointLocation> sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        v0 = (Set)vm.getUserData(JavaScriptLineBreakpointManager.ACTUAL_LOCATIONS_NOT_FOUND_KEY);
        if (v0 == null) {
            return CollectionsKt.emptyList();
        }
        actualLocationNotFound = v0;
        if (actualLocationNotFound.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (!this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem() || script == null) ** GOTO lbl-1000
        v1 = script.getUrl().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"script.url.path");
        if (StringsKt.contains$default((CharSequence)v1, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isScriptInNodeModules = v2;
        sourceMapFound = null;
        var10_10 = var11_9 = (iterator = actualLocationNotFound.iterator());
        while (var10_10.hasNext()) {
            breakpoint = (XLineBreakpoint)var10_10.next();
            if (breakpoint.getSourcePosition() == null) {
                continue;
            }
            if (isScriptInNodeModules) {
                v3 = breakpointLocation;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"breakpointLocation");
                v4 = v3.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"breakpointLocation.file");
                v5 = v4.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"breakpointLocation.file.path");
                if (!StringsKt.contains$default((CharSequence)v5, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) continue;
            }
            if (!((var13_13 = (Collection)(actualLocations = JavaScriptLineBreakpointManager.getActualLocations$default(this, breakpoint, vm, map, script, scriptUrl, null, false, 96, null))).isEmpty() == false)) continue;
            iterator.remove();
            if (sourceMapFound == null) {
                sourceMapFound = (List)new SmartList();
            }
            sourceMapFound.add(new VmBreakpointLocation(breakpoint, actualLocations));
        }
        v6 = sourceMapFound;
        if (v6 == null) {
            v6 = CollectionsKt.emptyList();
        }
        return v6;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getActualLocations(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Vm vm, @Nullable SourceMap map, @Nullable Script script, @Nullable Url scriptUrl, @Nullable Ref<Boolean> outSourceMappedLocationFound, boolean keepEmptySourceMappedLocation) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        XDebugSession xDebugSession = this.getDebugProcess$intellij_javascript_debugger().getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        List<SourceInfo> positionsInLine = PsiVisitorKt.getPositionsInLine(breakpoint, project);
        Iterable iterable = $receiver$iv = (Iterable)positionsInLine;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List<Location> rawLocationsFromExactPosition;
            SourceInfo it = (SourceInfo)element$iv$iv;
            List rawLocations = SourceMapHelperKt.getRawLocations(this.getDebugProcess$intellij_javascript_debugger(), vm, it.getFile(), it.getLine(), map, script, scriptUrl, it.getColumn());
            if (rawLocations.size() > 1 && it.getColumn() == -1 && !(rawLocationsFromExactPosition = this.findRawLocationsFromExactPosition(it, vm, map, script, scriptUrl)).isEmpty()) {
                rawLocations = rawLocationsFromExactPosition;
            }
            if (outSourceMappedLocationFound != null && !rawLocations.isEmpty()) {
                outSourceMappedLocationFound.set((Object)true);
            }
            Iterable list$iv$iv = keepEmptySourceMappedLocation && rawLocations.isEmpty() ? CollectionsKt.listOf((Object)new Location(it.getUrl(), it.getLine(), it.getColumn())) : rawLocations;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getActualLocations$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, XLineBreakpoint xLineBreakpoint, Vm vm, SourceMap sourceMap, Script script, Url url, Ref ref, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            sourceMap = null;
        }
        if ((n & 8) != 0) {
            script = null;
        }
        if ((n & 0x10) != 0) {
            url = null;
        }
        if ((n & 0x20) != 0) {
            ref = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return javaScriptLineBreakpointManager.getActualLocations(xLineBreakpoint, vm, sourceMap, script, url, (Ref<Boolean>)ref, bl);
    }

    private final List<Location> findRawLocationsFromExactPosition(SourceInfo position, Vm vm, SourceMap map, Script script, Url scriptUrl) {
        List<Location> list;
        Ref firstVarColumn = new Ref((Object)-1);
        XSourcePosition xSourcePosition = (XSourcePosition)position;
        XDebugSession xDebugSession = this.getDebugProcess$intellij_javascript_debugger().getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        PsiVisitors.visit((XSourcePosition)xSourcePosition, (Project)xDebugSession.getProject(), (PsiVisitors.Visitor)new LineVisitor(this, firstVarColumn){
            final /* synthetic */ JavaScriptLineBreakpointManager this$0;
            final /* synthetic */ Ref $firstVarColumn;

            public void visitJSElement(@Nullable JSElement node) {
                if (node instanceof JSVarStatement) {
                    JSVariable[] variables = ((JSVarStatement)node).getVariables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)variables, (String)"variables");
                    JSVariable[] jSVariableArray = variables;
                    if (!(jSVariableArray.length == 0)) {
                        XDebugSession xDebugSession = this.this$0.getDebugProcess$intellij_javascript_debugger().getSession();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                        Document document = PsiDocumentManager.getInstance((Project)xDebugSession.getProject()).getDocument(((JSVarStatement)node).getContainingFile());
                        if (document != null) {
                            JSVariable jSVariable = variables[0];
                            Intrinsics.checkExpressionValueIsNotNull((Object)jSVariable, (String)"variables[0]");
                            TextRange textRange = jSVariable.getTextRange();
                            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"variables[0].textRange");
                            int offset = textRange.getStartOffset();
                            this.$firstVarColumn.set((Object)(offset - DocumentUtil.getLineStartOffset((int)offset, (Document)document)));
                        }
                    }
                }
                this.isStopped = true;
            }
            {
                this.this$0 = $outer;
                this.$firstVarColumn = $captured_local_variable$1;
            }
        });
        Integer n = (Integer)firstVarColumn.get();
        if (n == null || n != -1) {
            JavaScriptDebugProcess<?> javaScriptDebugProcess = this.getDebugProcess$intellij_javascript_debugger();
            VirtualFile virtualFile = position.getFile();
            int n2 = position.getLine();
            Object object = firstVarColumn.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"firstVarColumn.get()");
            list = SourceMapHelperKt.getRawLocations(javaScriptDebugProcess, vm, virtualFile, n2, map, script, scriptUrl, ((Number)object).intValue());
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findTopFirstLineBreakpoints(@NotNull SuspendContext<?> context, @NotNull String scriptName) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scriptName, (String)"scriptName");
        CallFrame callFrame = context.getTopFrame();
        int breakLine = callFrame != null ? callFrame.getLine() : 0;
        for (Breakpoint breakpoint : context.getVm().getBreakpointManager().getBreakpoints()) {
            boolean bl;
            if (this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != 0 && breakpoint.getLine() != breakLine) continue;
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            BreakpointTarget breakpointTarget2 = breakpointTarget;
            if (breakpointTarget2 instanceof ScriptRegExpBreakpointTarget) {
                String string = breakpointTarget.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"breakpointTarget.toString()");
                bl = JavaScriptLineBreakpointManagerKt.match(string, scriptName);
            } else {
                Script script;
                bl = breakpointTarget2 instanceof BreakpointTarget.ScriptName ? Intrinsics.areEqual((Object)scriptName, (Object)breakpointTarget.toString()) : (breakpointTarget2 instanceof BreakpointTarget.ScriptId ? Intrinsics.areEqual((Object)scriptName, (Object)(script = ((BreakpointTarget.ScriptId)breakpointTarget).script).getUrl().trimParameters().toExternalForm()) || Intrinsics.areEqual((Object)scriptName, (Object)script.getUrl().trimParameters().toDecodedForm()) : false);
            }
            if (!bl) continue;
            List list = (List)this.getVmToIdeBreakpoints().get((Object)breakpoint);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findBreakpoints(@NotNull Breakpoint vmBreakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)vmBreakpoint, (String)"vmBreakpoint");
        List list = (List)this.getVmToIdeBreakpoints().get((Object)vmBreakpoint);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Breakpoint> doRunToLocation(@NotNull XSourcePosition position) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Vm vm = this.getDebugProcess$intellij_javascript_debugger().getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        Vm activeVm = vm;
        List locations2 = SourceMapHelperKt.getRawLocations$default(this.getDebugProcess$intellij_javascript_debugger(), activeVm, position, null, null, null, 56, null);
        if (locations2.isEmpty()) {
            DebuggableFileFinder debuggableFileFinder = this.getDebugProcess$intellij_javascript_debugger().getFinder();
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"position.file");
            if (debuggableFileFinder.isOnlySourceMappedBreakpoints(virtualFile)) {
                String message = "Cannot run to location, source location is not mapped: " + position;
                this.getDebugProcess$intellij_javascript_debugger().getSession().reportError(message);
                JavaScriptDebugProcessKt.getLOG().warn(message);
                return CollectionsKt.emptyList();
            }
        }
        if (locations2.isEmpty()) {
            DebuggableFileFinder debuggableFileFinder = this.getDebugProcess$intellij_javascript_debugger().getFinder();
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"position.file");
            List<Url> urls = debuggableFileFinder.getRemoteUrls(virtualFile);
            Url url = (Url)CollectionsKt.first(urls);
            int n = position.getLine();
            XSourcePosition xSourcePosition = position;
            if (!(xSourcePosition instanceof SourceInfo)) {
                xSourcePosition = null;
            }
            SourceInfo sourceInfo = (SourceInfo)xSourcePosition;
            list = CollectionsKt.listOfNotNull((Object)JSLineBreakpointManagerBase.doSetBreakpoint$default(this, activeVm, null, new Location(url, n, sourceInfo != null ? sourceInfo.getColumn() : -1), true, null, 16, null));
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)locations2;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Breakpoint breakpoint;
                Object element$iv$iv = element$iv$iv$iv;
                Location it = (Location)element$iv$iv;
                if (JSLineBreakpointManagerBase.doSetBreakpoint$default(this, activeVm, null, it, true, null, 16, null) == null) continue;
                Breakpoint it$iv$iv = breakpoint;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public JavaScriptLineBreakpointManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(debugProcess);
        this.anyFirstLineBreakpoints = ContainerUtil.createConcurrentList();
    }

    static {
        Companion = new Companion(null);
        ACTUAL_LOCATIONS_NOT_FOUND_KEY = new Key("js.debugger.actual.locations.not.found");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "actualLocations", "", "Lorg/jetbrains/debugger/Location;", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;Ljava/util/List;)V", "getActualLocations", "()Ljava/util/List;", "getBreakpoint", "()Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.debugger"})
    public static final class VmBreakpointLocation {
        @NotNull
        private final XLineBreakpoint<?> breakpoint;
        @NotNull
        private final List<Location> actualLocations;

        @NotNull
        public final XLineBreakpoint<?> getBreakpoint() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> getActualLocations() {
            return this.actualLocations;
        }

        public VmBreakpointLocation(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull(actualLocations, (String)"actualLocations");
            this.breakpoint = breakpoint;
            this.actualLocations = actualLocations;
        }

        @NotNull
        public final XLineBreakpoint<?> component1() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> component2() {
            return this.actualLocations;
        }

        @NotNull
        public final VmBreakpointLocation copy(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull(actualLocations, (String)"actualLocations");
            return new VmBreakpointLocation(breakpoint, actualLocations);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ VmBreakpointLocation copy$default(VmBreakpointLocation vmBreakpointLocation, XLineBreakpoint xLineBreakpoint, List list, int n, Object object) {
            if ((n & 1) != 0) {
                xLineBreakpoint = vmBreakpointLocation.breakpoint;
            }
            if ((n & 2) != 0) {
                list = vmBreakpointLocation.actualLocations;
            }
            return vmBreakpointLocation.copy(xLineBreakpoint, list);
        }

        public String toString() {
            return "VmBreakpointLocation(breakpoint=" + this.breakpoint + ", actualLocations=" + this.actualLocations + ")";
        }

        public int hashCode() {
            XLineBreakpoint<?> xLineBreakpoint = this.breakpoint;
            List<Location> list = this.actualLocations;
            return (xLineBreakpoint != null ? xLineBreakpoint.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VmBreakpointLocation)) break block3;
                    VmBreakpointLocation vmBreakpointLocation = (VmBreakpointLocation)object;
                    if (!Intrinsics.areEqual(this.breakpoint, vmBreakpointLocation.breakpoint) || !Intrinsics.areEqual(this.actualLocations, vmBreakpointLocation.actualLocations)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$Companion;", "", "()V", "ACTUAL_LOCATIONS_NOT_FOUND_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getACTUAL_LOCATIONS_NOT_FOUND_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final Key<Set<XLineBreakpoint<?>>> getACTUAL_LOCATIONS_NOT_FOUND_KEY() {
            return ACTUAL_LOCATIONS_NOT_FOUND_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

